/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.service.job.wrapper.MessageSenderWrapper;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.Sender;
import com.kingdee.eas.csinterface.monitor.MonitorLogInfo;
import com.kingdee.eas.csinterface.util.MessageContent;
import com.kingdee.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Logger;

public class MessageSender {
    private static ConcurrentLinkedQueue<MessageContent> queue = new ConcurrentLinkedQueue();
    public static final String NOTICETIELE_L1 = "noticeTitle_L1";
    public static final String NOTICETIELE_L2 = "noticeTitle_L2";
    public static final String NOTICETIELE_L3 = "noticeTitle_L3";
    public static final String NOTICECONTENT_L1 = "noticeContent_L1";
    public static final String NOTICECONTENT_L2 = "noticeContent_L2";
    public static final String NOTICECONTENT_L3 = "noticeContent_L3";
    public static final String ISSENDMAIL = "isSendMail";
    public static final String ISSENDSMS = "isSendSms";
    public static final String SCHEDULELEVEL = "scheduleLevel";
    public static final String ISFORSCHEDULE = "isForSchedule";
    public static final String ISFOREIP = "isForEIP";
    public static final String EIPLEVEL = "eipLevel";
    private final Logger logger = Logger.getLogger(MessageSender.class);
    private String configPath = System.getProperty("eas.properties.dir") + "/eip/msg.properties";
    private Long lastupdatetime = 0L;
    private Map<String, String> config = new HashMap<String, String>();
    private MessageSenderWrapper msgSender = null;
    private List<String> levels = new ArrayList<String>(Arrays.asList("\u6b63\u5728\u8fd0\u884c", "\u6210\u529f", "\u90e8\u5206\u6210\u529f", "\u8b66\u544a", "\u5f02\u5e38", "\u5931\u8d25"));

    private MessageSender() {
        try {
            this.initMsgSender(true);
            this.initHandler();
        }
        catch (Exception e) {
            this.logger.error((Object)"\u3010eip\u3011\u90ae\u4ef6\u53d1\u9001\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
        }
    }

    private void initHandler() {
        if (this.msgSender != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        if (!queue.isEmpty()) {
                            MessageSender.this.sendMessage((MessageContent)queue.poll());
                            continue;
                        }
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            }, "EIPSendMsg").start();
        }
    }

    private boolean needReload() {
        if (this.lastupdatetime == -1L) {
            return false;
        }
        if (this.lastupdatetime == 0L) {
            return true;
        }
        Long last = new File(this.configPath).lastModified();
        return last > this.lastupdatetime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties(boolean first) {
        if (!first && !this.needReload()) {
            return;
        }
        File file = new File(this.configPath);
        if (!file.exists()) {
            this.lastupdatetime = -1L;
            return;
        }
        this.lastupdatetime = file.lastModified();
        Properties prop = new Properties();
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(this.configPath));
            prop.load(in);
            for (Object key : prop.keySet()) {
                if (key == null) continue;
                this.config.put(key.toString(), prop.getProperty(key.toString()));
            }
        }
        catch (IOException e) {
            this.logger.error((Object)("\u3010eip\u3011\u914d\u7f6e\u6587\u4ef6(" + this.configPath + ")\u8bfb\u53d6\u5931\u8d25"), (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)e);
                }
            }
        }
    }

    private void initMsgSender(boolean first) {
        this.loadProperties(first);
        if (!this.isForEip()) {
            return;
        }
        MessageSenderWrapper.MessageReceiver[] receivers = this.getReceivers();
        if (receivers.length == 0) {
            this.logger.error((Object)"\u3010eip\u3011\u672a\u68c0\u6d4b\u5230\u6709\u6548\u90ae\u4ef6\u63a5\u6536\u4eba");
            return;
        }
        this.msgSender = new MessageSenderWrapper(receivers, this.getMessages(), this.isSendMail(), this.isSendSms());
    }

    public static final MessageSender getInstance() {
        return MessageSenderHoder.instance;
    }

    public Map<String, String> getConfig() {
        return Collections.unmodifiableMap(this.config);
    }

    public void storeConfig(Map<String, String> newConfig) throws IOException {
        File file = new File(this.configPath);
        if (!file.exists()) {
            file.createNewFile();
        }
        Properties prop = new Properties();
        try (FileInputStream fis = new FileInputStream(this.configPath);
             FileOutputStream fos = new FileOutputStream(this.configPath);){
            prop.load(fis);
            Set<Map.Entry<String, String>> entrys = newConfig.entrySet();
            for (Map.Entry<String, String> entry : entrys) {
                if (entry.getValue() == null) continue;
                this.config.put(entry.getKey(), entry.getValue());
                prop.setProperty(entry.getKey(), entry.getValue());
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            prop.store(fos, "Update value in " + sdf.format(new Date()));
            fos.flush();
        }
        catch (IOException e) {
            this.logger.error((Object)"\u3010eip\u3011\u8f93\u51fa\u90ae\u4ef6\u914d\u7f6e\u9519\u8bef");
            throw e;
        }
    }

    private int getCurrentLevel() {
        String level = this.config.get(EIPLEVEL);
        if (StringUtils.isEmpty((String)level)) {
            return 2;
        }
        if ("NONE".equals(level = level.toUpperCase())) {
            return 6;
        }
        if ("SUCCESS".equals(level)) {
            return 1;
        }
        if ("WARN".equals(level)) {
            return 2;
        }
        if ("ERROR".equals(level)) {
            return 4;
        }
        return 2;
    }

    public boolean getScheduleConfig(String item) {
        String schduleLevel = this.config.get(SCHEDULELEVEL);
        if (StringUtils.isEmpty((String)schduleLevel)) {
            return false;
        }
        return (schduleLevel = schduleLevel.toLowerCase(Locale.ENGLISH)).indexOf(item) > -1;
    }

    private boolean isForEip() {
        return Boolean.valueOf(this.config.get(ISFOREIP));
    }

    public boolean isForSchedule() {
        return Boolean.valueOf(this.config.get(ISFORSCHEDULE));
    }

    public boolean isSendMail() {
        return Boolean.valueOf(this.config.get(ISSENDMAIL));
    }

    public boolean isSendSms() {
        return Boolean.valueOf(this.config.get(ISSENDSMS));
    }

    public void send(Context ctx, MonitorLogInfo monitorLogInfo) {
        if (this.msgSender != null && this.needSend(monitorLogInfo.getStatus())) {
            StringBuilder detail = new StringBuilder();
            detail.append("\u65e5\u5fd7id").append(monitorLogInfo.getId()).append("\n").append("\u5355\u636e\u4fe1\u606f\uff1a").append(monitorLogInfo.getBillNumber()).append("\n").append("\u64cd\u4f5c\u6765\u6e90\uff1a").append(monitorLogInfo.getOperatorSource()).append("\n").append("\u5f00\u59cb\u65f6\u95f4\uff1a").append(monitorLogInfo.getStartTime()).append("\n").append("\u6301\u7eed\u65f6\u95f4\uff1a").append(monitorLogInfo.getDuration()).append("\n").append("\u670d\u52a1\u5668\uff1a").append(monitorLogInfo.getServerIp()).append(":").append(monitorLogInfo.getRpcPort()).append("\n").append("\u8fc7\u6ee4\u6761\u4ef6\uff1a").append(monitorLogInfo.getSrcWhere()).append("\n").append("\u8be6\u7ec6\u5185\u5bb9\uff1a").append(monitorLogInfo.getContent()).append("\n").append("\u5f02\u5e38\u5806\u6808").append(monitorLogInfo.getStackTrace()).append("\n");
            queue.add(new MessageContent(ctx, monitorLogInfo.getSummary(), monitorLogInfo.getStatus(), detail.toString()));
        }
    }

    private boolean needSend(String status) {
        return this.levels.indexOf(status) >= this.getCurrentLevel();
    }

    private void sendMessage(MessageContent mc) {
        String[] receivers = this.getPersonIds();
        String userids = this.getUserIds(mc, receivers, true);
        if (userids == null) {
            this.logger.error((Object)"\u3010eip\u3011\u6ca1\u6709\u6d88\u606f\u63a5\u6536\u8005");
            return;
        }
        Message msg = this.createMessage(mc);
        msg.setStringHeader("receiver", userids);
        String title = null;
        MessageSenderWrapper.MessageTemplate[] templates = this.getMessages();
        for (int i = 0; i < templates.length; ++i) {
            MessageSenderWrapper.MessageTemplate t = templates[i];
            String tmp = MessageSender.conver(mc, t.title);
            if (title == null) {
                title = tmp;
            }
            msg.setLocaleStringHeader("title", tmp, t.locale);
            msg.setLocaleStringHeader("body", MessageSender.conver(mc, t.body), t.locale);
        }
        Sender sender = com.kingdee.bos.service.message.agent.MessageSender.getInstance();
        sender.sendMessage(msg);
        if (this.isSendMail() || this.isSendSms()) {
            userids = this.getUserIds(mc, receivers, false);
            msg.setStringHeader("receiver", userids);
            if (this.isSendMail()) {
                msg.setBooleanHeader("isSendEmail", true);
                msg.setBooleanHeader("isSendMobile", false);
                msg.setBooleanHeader("isSendCommon", false);
                sender.sendMessage(msg);
            }
            if (this.isSendSms()) {
                msg.setBooleanHeader("isSendEmail", false);
                msg.setBooleanHeader("isSendMobile", true);
                msg.setBooleanHeader("isSendCommon", false);
                sender.sendMessage(msg);
            }
        }
    }

    private String[] getPersonIds() {
        MessageSenderWrapper.MessageReceiver[] receivers = this.getReceivers();
        if (receivers == null) {
            return null;
        }
        String[] personIds = new String[receivers.length];
        for (int i = 0; i < personIds.length; ++i) {
            personIds[i] = receivers[i].personId;
        }
        return personIds;
    }

    public MessageSenderWrapper.MessageReceiver[] getReceivers() {
        ArrayList<MessageSenderWrapper.MessageReceiver> persons = new ArrayList<MessageSenderWrapper.MessageReceiver>();
        String receivers = this.config.get("receivers");
        if (receivers != null) {
            String[] receiverGroups;
            for (String receiverGroup : receiverGroups = receivers.split(";")) {
                String[] receiverGroupSplit = receiverGroup.split(",");
                if (receiverGroupSplit.length != 2) continue;
                String receiverName = receiverGroupSplit[0];
                String receiverID = receiverGroupSplit[1];
                if (StringUtils.isEmpty((String)receiverName) || StringUtils.isEmpty((String)receiverID)) continue;
                persons.add(new MessageSenderWrapper.MessageReceiver(receiverID, receiverName));
            }
        }
        return persons.toArray(new MessageSenderWrapper.MessageReceiver[0]);
    }

    private MessageSenderWrapper.MessageTemplate[] getMessages() {
        ArrayList<MessageSenderWrapper.MessageTemplate> messages = new ArrayList<MessageSenderWrapper.MessageTemplate>();
        String title_L1 = this.config.get(NOTICETIELE_L1);
        String title_L2 = this.config.get(NOTICETIELE_L2);
        String title_L3 = this.config.get(NOTICETIELE_L3);
        String body_L1 = this.config.get(NOTICECONTENT_L1);
        String body_L2 = this.config.get(NOTICECONTENT_L2);
        String body_L3 = this.config.get(NOTICECONTENT_L3);
        MessageSenderWrapper.MessageTemplate template_l1 = null;
        MessageSenderWrapper.MessageTemplate template_l2 = null;
        MessageSenderWrapper.MessageTemplate template_l3 = null;
        if (StringUtils.isEmpty((String)title_L1)) {
            title_L1 = "Eip Services (<%Title%>) <%State%>!";
        }
        if (StringUtils.isEmpty((String)body_L1)) {
            body_L1 = "<%Detail%>";
        }
        template_l1 = new MessageSenderWrapper.MessageTemplate(new Locale("l1"), title_L1, body_L1);
        messages.add(template_l1);
        if (StringUtils.isEmpty((String)title_L2)) {
            title_L2 = "\u96c6\u6210\u65b9\u6848  {<%Title%>}  <%State%> !";
        }
        if (StringUtils.isEmpty((String)body_L2)) {
            body_L2 = "<%Detail%>";
        }
        template_l2 = new MessageSenderWrapper.MessageTemplate(new Locale("l2"), title_L2, body_L2);
        messages.add(template_l2);
        if (StringUtils.isEmpty((String)title_L3)) {
            title_L3 = "\u96c6\u6210\u65b9\u6848 {<%Title%>}  <%State%> !";
        }
        if (StringUtils.isEmpty((String)body_L3)) {
            body_L3 = "<%Detail%>}";
        }
        template_l3 = new MessageSenderWrapper.MessageTemplate(new Locale("l3"), title_L3, body_L3);
        messages.add(template_l3);
        return messages.toArray(new MessageSenderWrapper.MessageTemplate[0]);
    }

    private static String conver(MessageContent mc, String template) {
        int j;
        int i;
        StringBuffer sb = new StringBuffer();
        int k = 0;
        while ((i = template.indexOf("<%", k)) >= 0 && (j = template.indexOf("%>", i)) >= 0) {
            if (k == 0) {
                sb.append(template.substring(0, i));
            } else {
                sb.append(template.substring(k, i));
            }
            String field = template.substring(i + 2, j).trim().toLowerCase(Locale.ENGLISH);
            Object value = MessageSender.getField(mc, field);
            sb.append(value);
            k = j + 2;
        }
        if (k < template.length()) {
            sb.append(template.substring(k));
        }
        return sb.toString();
    }

    private static Object getField(MessageContent mc, String field) {
        if ("title".equals(field)) {
            return mc.getTitle();
        }
        if ("state".equals(field)) {
            return mc.getState();
        }
        if ("detail".equals(field)) {
            return mc.getDetail();
        }
        return "<%" + field + "%>";
    }

    private Message createMessage(MessageContent mc) {
        Message message = MessageFactory.newMessage();
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 50);
        message.setIntHeader("priority", 10);
        message.setIntHeader("sourceStatus", 0);
        message.setStringHeader("sender", "Eip");
        message.setLocaleStringHeader("sender", "Eip", new Locale("l1"));
        message.setLocaleStringHeader("sender", "Eip", new Locale("l2"));
        message.setLocaleStringHeader("sender", "Eip", new Locale("l3"));
        message.setStringHeader("databaseCenter", mc.getCtx().getAIS());
        message.setStringHeader("solution", mc.getCtx().getSolution());
        message.setBooleanHeader("isSendEmail", false);
        message.setBooleanHeader("isSendMobile", false);
        message.setBooleanHeader("isSendCommon", true);
        return message;
    }

    private String getUserIds(MessageContent mc, String[] receivers, boolean all) {
        ArrayList items;
        if (receivers == null || receivers.length == 0) {
            return null;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select fid,fpersonid from t_pm_user where fpersonid in(");
        for (int i = 0; i < receivers.length; ++i) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append("'").append(receivers[i]).append("'");
        }
        sql.append(")");
        try {
            items = SQL.executeQuery((Context)mc.getCtx(), (String)sql.toString());
        }
        catch (BOSException e) {
            this.logger.error((Object)("\u3010eip\u3011\u67e5\u8be2\u7528\u6237\u51fa\u9519\uff0csql:" + sql.toString()), (Throwable)e);
            return null;
        }
        if (items.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < items.size(); ++i) {
            String s = ((HashMap)items.get(i)).get("fpersonid").toString();
            if (!all && set.contains(s)) continue;
            set.add(s);
            if (i > 0) {
                sb.append(";");
            }
            sb.append(((HashMap)items.get(i)).get("fid"));
        }
        return sb.toString();
    }

    private static final class MessageSenderHoder {
        private static MessageSender instance = new MessageSender();

        private MessageSenderHoder() {
        }
    }
}

