/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.util.gson;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.fm.EJBAccessFactory;
import com.kingdee.eas.csinterface.util.gson.EIPJSONUtils;

public class ContextConvertUtil {
    private static final String BOSTYPE = "bosType";
    private static final String METATYPE = "metaType";
    private static final String OPERATIONPK = "operationPK";
    private static final String CTXARRAY = "ctxArray";
    public static final String SERVICECONTEXT = "serviceContext";

    public static JSONObject serialize(IServiceContext serviceContext) {
        JSONObject ctxOj = new JSONObject();
        JSONArray ctxArray = new JSONArray();
        Object[] contextParam = serviceContext.getOperationParameters();
        int j = contextParam.length;
        for (int i = 1; i < j; ++i) {
            if (contextParam[i] instanceof IObjectValue || contextParam[i] instanceof IObjectCollection) {
                try {
                    ctxArray.add((Object)EIPJSONUtils.convertObjectToJson(serviceContext.getContext(), contextParam[i]));
                }
                catch (BOSException bOSException) {}
                continue;
            }
            if (contextParam[i] instanceof String[]) {
                String[] values = (String[])contextParam[i];
                JSONArray array = new JSONArray();
                String[] stringArray = values;
                int n = stringArray.length;
                for (int k = 0; k < n; ++k) {
                    String a = stringArray[k];
                    array.add((Object)a);
                }
                ctxArray.add((Object)array);
                continue;
            }
            if (contextParam[i] instanceof ObjectUuidPK) {
                ctxArray.add((Object)contextParam[i].toString());
                continue;
            }
            if (contextParam[i] instanceof IObjectPK[]) {
                JSONArray array = new JSONArray();
                for (IObjectPK pk : (IObjectPK[])contextParam[i]) {
                    if (pk instanceof ObjectUuidPK) {
                        array.add((Object)pk.toString());
                        continue;
                    }
                    array.add((Object)pk);
                }
                ctxArray.add((Object)array);
                continue;
            }
            ctxArray.add(contextParam[i]);
        }
        String bosType = serviceContext.getBoType().toString();
        String metaType = serviceContext.getMetaType().toString();
        String operationPK = serviceContext.getOperationPK().toString();
        ctxOj.put(BOSTYPE, (Object)bosType);
        ctxOj.put(METATYPE, (Object)metaType);
        ctxOj.put(OPERATIONPK, (Object)operationPK);
        ctxOj.put(CTXARRAY, (Object)ctxArray);
        return ctxOj;
    }

    public static IServiceContext deserialize(Context ctx, JSONObject ctxObj) {
        String bosTypeStr = ctxObj.getString(BOSTYPE);
        BOSObjectType bosType = BOSObjectType.create((String)bosTypeStr);
        String metaTypeStr = ctxObj.getString(METATYPE);
        BOSObjectType metaType = BOSObjectType.create((String)metaTypeStr);
        String operationPKStr = ctxObj.getString(OPERATIONPK);
        MetaDataPK operationPK = MetaDataPK.create((String)operationPKStr);
        JSONArray array = ctxObj.getJSONArray(CTXARRAY);
        Object[] operParam = new Object[array.size() + 1];
        operParam[0] = ctx;
        Object obj = null;
        int j = array.size();
        for (int i = 0; i < j; ++i) {
            obj = array.get(i);
            if (obj instanceof String) {
                try {
                    Object objValue;
                    Class<?> infoClass;
                    String infoName;
                    EntityObjectInfo eoi;
                    BOSObjectType bt;
                    JSONObject json;
                    if (obj.toString().startsWith("{")) {
                        json = JSONObject.parseObject((String)obj.toString());
                        if (json.containsKey((Object)BOSTYPE)) {
                            try {
                                bt = BOSObjectType.create((String)json.getString(BOSTYPE));
                                eoi = EJBAccessFactory.createLocalInstance((Context)ctx).getEntityInfo(bt);
                                infoName = eoi.getBusinessImplName() + "Info";
                                infoClass = Class.forName(infoName);
                                objValue = EIPJSONUtils.convertJsonToObject(ctx, json.toJSONString(), infoClass);
                                operParam[i + 1] = objValue;
                            }
                            catch (Exception e) {
                                operParam[i + 1] = json;
                            }
                            continue;
                        }
                        operParam[i + 1] = json;
                        continue;
                    }
                    if (obj.toString().startsWith("[")) {
                        json = JSONObject.parseArray((String)obj.toString());
                        if (json.size() > 0 && json.getJSONObject(0).containsKey((Object)BOSTYPE)) {
                            try {
                                bt = BOSObjectType.create((String)json.getJSONObject(0).getString(BOSTYPE));
                                eoi = EJBAccessFactory.createLocalInstance((Context)ctx).getEntityInfo(bt);
                                infoName = eoi.getBusinessImplName() + "Info";
                                infoClass = Class.forName(infoName);
                                objValue = EIPJSONUtils.convertJsonToObject(ctx, json.toJSONString(), infoClass);
                                operParam[i + 1] = objValue;
                            }
                            catch (Exception e) {
                                operParam[i + 1] = json;
                            }
                            continue;
                        }
                        operParam[i + 1] = json;
                        continue;
                    }
                    operParam[i + 1] = obj;
                }
                catch (Exception e) {
                    operParam[i + 1] = obj;
                }
                continue;
            }
            operParam[i + 1] = obj;
        }
        ServiceContext serviceContext = new ServiceContext(metaType, bosType, (IMetaDataPK)operationPK, operParam);
        return serviceContext;
    }
}

