/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.bizbill.metadata.info.FieldInfo;
import com.kingdee.eas.csinterface.bizbill.metadata.utils.MetadataTemplateCopyUtil;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataInfo;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeInfo;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.webservice.DataStructureTableModel;
import com.kingdee.eas.csinterface.webservice.IWSBillMapping;
import com.kingdee.eas.csinterface.webservice.Region;
import com.kingdee.eas.csinterface.webservice.WSBillMappingEntryCollection;
import com.kingdee.eas.csinterface.webservice.WSBillMappingEntryInfo;
import com.kingdee.eas.csinterface.webservice.WSBillMappingFactory;
import com.kingdee.eas.csinterface.webservice.WSBillMappingInfo;
import com.kingdee.eas.csinterface.webservice.app.AbstractWSBillMappingControllerBean;
import com.kingdee.eas.csinterface.webservice.app.model.WSDataModelUtil;
import com.kingdee.eas.csinterface.webservice.app.util.UserClassCheckUtil;
import com.kingdee.eas.csinterface.webservice.app.webservice.model.OneStructer;
import com.kingdee.eas.csinterface.webservice.app.webservice.model.SecondStructer;
import com.kingdee.eas.csinterface.webservice.app.webservice.model.StructerModel;
import com.kingdee.eas.csinterface.webservice.app.webservice.model.StructerUtil;
import com.kingdee.eas.csinterface.webservice.model.util.SourceTableUtil;
import com.kingdee.eas.csinterface.webservice.model.util.WSMetaDataCopyUitl;
import com.kingdee.eas.csinterface.webservice.model.util.WSModelUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class WSBillMappingControllerBean
extends AbstractWSBillMappingControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.csinterface.webservice.app.WSBillMappingControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        UserClassCheckUtil.checkUserClass(model);
        return super._save(ctx, model);
    }

    @Override
    protected void _publish(Context ctx, String id) throws BOSException, EASBizException {
        WSBillMappingInfo info = null;
        IWSBillMapping instance = WSBillMappingFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.baseDataType.*"));
        sic.add(new SelectorItemInfo("entrys.baseDataType.destBaseData.*"));
        info = instance.getWSBillMappingInfo(CommonUtil.convert2PK(id), sic);
        if (info.isNeedSrcTable()) {
            SourceTableUtil.addDbSourceColumns(ctx, info);
        }
        this.createMidBill(ctx, info, instance);
    }

    private void createMidBill(Context ctx, WSBillMappingInfo info, IWSBillMapping instance) throws BOSException, EASBizException {
        DataStructureTableModel tb = null;
        boolean newFlag = false;
        try {
            List<FieldInfo> toPublish_head;
            tb = WSDataModelUtil.deteminedTableModel(info);
            if (!info.isPublished()) {
                newFlag = true;
            }
            StructerModel structerModel = StructerUtil.buildStructer(info, true);
            Map<String, List<FieldInfo>> map = this.getRegionAndFieldInfo(tb, structerModel, info);
            if (DataStructureTableModel.H.equals((Object)tb)) {
                if (!info.isPublished()) {
                    WSMetaDataCopyUitl.copy(ctx, info.getNumber(), info.getName(), "com.kingdee.eas.csinterface.webservice.model.WSDynamicModel", "com.kingdee.eas.csinterface.webservice.model.app.WSDynamicBillTemplate");
                }
                List<FieldInfo> toPublish = this.getFieldToPublish(info, Region.head);
                WSModelUtil.addFields(ctx, info.getNumber(), toPublish);
            } else if (DataStructureTableModel.HD.equals((Object)tb)) {
                if (!info.isPublished()) {
                    WSMetaDataCopyUitl.copy(ctx, info.getNumber(), info.getName(), "com.kingdee.eas.csinterface.webservice.model.WSDynamicModel", "com.kingdee.eas.csinterface.webservice.model.app.WSDynamicBillTemplate");
                    toPublish_head = this.getFieldToPublish(info, Region.head);
                    WSModelUtil.addFields(ctx, info.getNumber(), toPublish_head);
                    SecondStructer second = (SecondStructer)structerModel;
                    int entityLength = second.getEntityLength();
                    List<OneStructer> oneList = second.getMappings();
                    for (int i = 0; i < oneList.size(); ++i) {
                        WSMetaDataCopyUitl.copy(ctx, info.getNumber() + (info.getNumber() + oneList.get(i).getDesEntry()).hashCode(), info.getName(), "com.kingdee.eas.csinterface.webservice.model.WSDynamicModelEx", "com.kingdee.eas.csinterface.webservice.model.app.WSDynamicBillTemplateEx");
                        WSModelUtil.addFieldsEx(ctx, info.getNumber() + oneList.get(i).getDesEntry() + i, map.get(oneList.get(i).getDesEntry()));
                        WSModelUtil.bindRelation(ctx, info.getNumber(), oneList.get(i).getDesEntry(), info.getNumber() + oneList.get(i).getDesEntry() + i);
                    }
                }
            } else if (DataStructureTableModel.HDD.equals((Object)tb)) {
                if (!info.isPublished()) {
                    WSMetaDataCopyUitl.copy(ctx, info.getNumber(), info.getName(), "com.kingdee.eas.csinterface.webservice.model.WSDynamicModel", "com.kingdee.eas.csinterface.webservice.model.app.WSDynamicBillTemplate");
                    WSMetaDataCopyUitl.copy(ctx, info.getNumber() + "Entry", info.getName(), "com.kingdee.eas.csinterface.webservice.model.WSDynamicModelEx", "com.kingdee.eas.csinterface.webservice.model.app.WSDynamicBillTemplateEx");
                    WSModelUtil.bindRelation(ctx, info.getNumber(), "Entry", info.getNumber() + "Entry");
                    WSMetaDataCopyUitl.copy(ctx, info.getNumber() + "SubEntry", info.getName(), "com.kingdee.eas.csinterface.webservice.model.WSDynamicModelEx", "com.kingdee.eas.csinterface.webservice.model.app.WSDynamicBillTemplateEx");
                    WSModelUtil.bindRelation(ctx, info.getNumber() + "Entry", info.getNumber() + "Entry", info.getNumber() + "SubEntry");
                }
                toPublish_head = this.getFieldToPublish(info, Region.head);
                WSModelUtil.addFields(ctx, info.getNumber(), toPublish_head);
                List<FieldInfo> toPublish_entry = this.getFieldToPublish(info, Region.entry);
                WSModelUtil.addFieldsEx(ctx, info.getNumber() + "Entry", toPublish_entry);
                List<FieldInfo> toPublish_subentry = this.getFieldToPublish(info, Region.subEntry);
                WSModelUtil.addFieldsEx(ctx, info.getNumber() + "Entry", toPublish_subentry);
            }
            info.setPublished(true);
            WSBillMappingEntryCollection coll = info.getEntrys();
            Iterator its = coll.iterator();
            while (its.hasNext()) {
                WSBillMappingEntryInfo entryInfo = (WSBillMappingEntryInfo)its.next();
                entryInfo.setPublished(true);
            }
            instance.save((CoreBaseInfo)info);
        }
        catch (Exception e) {
            if (newFlag) {
                try {
                    MetadataTemplateCopyUtil.delete(ctx, info.getNumber());
                    WSMetaDataCopyUitl.delete(ctx, info.getNumber());
                    if (DataStructureTableModel.HD.equals((Object)tb)) {
                        WSMetaDataCopyUitl.delete(ctx, info.getNumber() + "Entry");
                    }
                    if (DataStructureTableModel.HDD.equals((Object)tb)) {
                        WSMetaDataCopyUitl.delete(ctx, info.getNumber() + "Entry");
                        WSMetaDataCopyUitl.delete(ctx, info.getNumber() + "SubEntry");
                    }
                }
                catch (Exception e1) {
                    logger.error((Object)e);
                }
            }
            throw new BOSException((Throwable)e);
        }
    }

    public Map<String, List<FieldInfo>> getRegionAndFieldInfo(DataStructureTableModel tb, StructerModel structerModel, WSBillMappingInfo info) throws BOSException {
        HashMap<String, List<FieldInfo>> map = new HashMap<String, List<FieldInfo>>();
        if (DataStructureTableModel.HD.equals((Object)tb)) {
            SecondStructer second = (SecondStructer)structerModel;
            List<OneStructer> oneList = second.getMappings();
            for (int i = 0; i < oneList.size(); ++i) {
                List<FieldInfo> toPublish_entry = null;
                try {
                    toPublish_entry = this.getFieldToPublish(info, Region.entry, oneList.get(i).getDesEntry());
                }
                catch (BOSException e) {
                    logger.error((Object)"xxxxxx", (Throwable)e);
                    throw new BOSException("xxxxxx", (Throwable)e);
                }
                map.put(oneList.get(i).getDesEntry(), toPublish_entry);
            }
        }
        return map;
    }

    public List<FieldInfo> getFieldToPublish(WSBillMappingInfo info, Region region) throws BOSException {
        ArrayList<FieldInfo> result = new ArrayList<FieldInfo>();
        WSBillMappingEntryCollection coll = info.getEntrys();
        Iterator its = coll.iterator();
        while (its.hasNext()) {
            WSBillMappingEntryInfo entryInfo = (WSBillMappingEntryInfo)its.next();
            if (entryInfo.isDropped() || entryInfo.isPublished() || !region.equals((Object)entryInfo.getRegion())) continue;
            result.add(this.convertEntry2Field(entryInfo));
        }
        return result;
    }

    public List<FieldInfo> getFieldToPublish(WSBillMappingInfo info, Region region, String destEntry) throws BOSException {
        ArrayList<FieldInfo> result = new ArrayList<FieldInfo>();
        WSBillMappingEntryCollection coll = info.getEntrys();
        Iterator its = coll.iterator();
        while (its.hasNext()) {
            WSBillMappingEntryInfo entryInfo = (WSBillMappingEntryInfo)its.next();
            if (entryInfo.isDropped() || entryInfo.isPublished() || !region.equals((Object)entryInfo.getRegion()) || !entryInfo.getDestField().split("\\.")[0].equals(destEntry)) continue;
            result.add(this.convertEntry2Field(entryInfo));
        }
        return result;
    }

    public List<FieldInfo> getFieldToDelete(WSBillMappingInfo info, Region region) throws BOSException {
        ArrayList<FieldInfo> result = new ArrayList<FieldInfo>();
        WSBillMappingEntryCollection coll = info.getEntrys();
        Iterator its = coll.iterator();
        while (its.hasNext()) {
            WSBillMappingEntryInfo entryInfo = (WSBillMappingEntryInfo)its.next();
            if (!entryInfo.isDropped() || !region.equals((Object)entryInfo.getRegion())) continue;
            result.add(this.convertEntry2Field(entryInfo));
        }
        return result;
    }

    private FieldInfo convertEntry2Field(WSBillMappingEntryInfo entryInfo) throws BOSException {
        String alias = entryInfo.getDestAlias();
        int precision = entryInfo.getFieldPrecision();
        int length = entryInfo.getFieldLength();
        int scale = entryInfo.getFieldScale();
        String sqlTypeName = entryInfo.getFieldType().getName();
        SQLType sqlType = SQLType.getEnum((String)sqlTypeName);
        String name = entryInfo.getDestField();
        FieldInfo field = new FieldInfo(name, alias, sqlType, length, precision, scale);
        BaseDataTypeInfo info = entryInfo.getBaseDataType();
        if (null != info) {
            BaseDataInfo baseDataInfo = info.getDestBaseData();
            String baseDataDisplayName = info.getDestDisplay();
            String queryName = baseDataInfo.getQueryName();
            String entityName = CommonUtil.getEntityName(queryName);
            field.setBaseDataType(entityName);
            field.setBaseDataDisplayName(baseDataDisplayName);
        }
        field.setQueryDisplayName(alias);
        return field;
    }
}

