/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.agent.base.Encoding;
import com.kingdee.eas.csinterface.agent.servlet.PacketsEncoder;
import com.kingdee.eas.csinterface.util.Base64;
import com.kingdee.eas.csinterface.webservice.WSIdentificationCodeHisFactory;
import com.kingdee.eas.csinterface.webservice.WSIdentificationCodeHisInfo;
import com.kingdee.eas.csinterface.webservice.WSIdentificationCodeInfo;
import com.kingdee.eas.csinterface.webservice.app.AbstractWSIdentificationCodeControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import org.apache.log4j.Logger;

public class WSIdentificationCodeControllerBean
extends AbstractWSIdentificationCodeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.csinterface.webservice.app.WSIdentificationCodeControllerBean");

    @Override
    protected void _viewHisCode(Context ctx, IObjectValue model) throws BOSException {
        WSIdentificationCodeInfo wSIdentificationCodeInfo = (WSIdentificationCodeInfo)model;
        String id = wSIdentificationCodeInfo.getId().toString();
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        WSIdentificationCodeInfo newCodeInfo = (WSIdentificationCodeInfo)model;
        String newNumber = newCodeInfo.getNumber();
        String aix = ctx.getAIS();
        Integer hasLength = newNumber.length() + aix.length() + 2;
        if (hasLength > 30) {
            throw new BOSException("\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e" + (30 - aix.length() - 2) + "\u4f4d");
        }
        String caclcNumber = String.format("%1$0" + (30 - hasLength) + "d", 0) + "_" + newNumber + "_" + aix;
        byte[] bytes = PacketsEncoder.encodeOuputStream(caclcNumber.getBytes(), "EIP", Encoding.ENCRYPT);
        newCodeInfo.setApiKey(Base64.encodeBytes(bytes));
        IObjectPK pk = null;
        pk = super._addnew(ctx, (IObjectValue)newCodeInfo);
        return pk;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        WSIdentificationCodeInfo newCodeInfo = (WSIdentificationCodeInfo)model;
        String newNumber = newCodeInfo.getNumber();
        String aix = ctx.getAIS();
        Integer hasLength = newNumber.length() + aix.length() + 2;
        if (hasLength > 30) {
            throw new BOSException("\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e" + (30 - aix.length() - 2) + "\u4f4d");
        }
        String caclcNumber = String.format("%1$0" + (30 - hasLength) + "d", 0) + "_" + newNumber + "_" + aix;
        byte[] bytes = PacketsEncoder.encodeOuputStream(caclcNumber.getBytes(), "EIP", Encoding.ENCRYPT);
        newCodeInfo.setApiKey(Base64.encodeBytes(bytes));
        WSIdentificationCodeInfo oldCodeInfo = this.getWSIdentificationCodeInfo(ctx, pk);
        String oldNumber = oldCodeInfo.getNumber();
        if (!newNumber.trim().equals(oldNumber.trim())) {
            WSIdentificationCodeHisInfo hisCodeInfo = new WSIdentificationCodeHisInfo();
            hisCodeInfo.setIdentificationId(newCodeInfo);
            hisCodeInfo.setSrcCode(oldNumber);
            WSIdentificationCodeHisFactory.getLocalInstance(ctx).save((CoreBaseInfo)hisCodeInfo);
        }
        super._update(ctx, pk, model);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        WSIdentificationCodeInfo wsIdentificationCodeInfo = (WSIdentificationCodeInfo)model;
        wsIdentificationCodeInfo.setEnable(false);
        super._cancel(ctx, pk, model);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        WSIdentificationCodeInfo wsIdentificationCodeInfo = (WSIdentificationCodeInfo)model;
        wsIdentificationCodeInfo.setEnable(true);
        super._cancelCancel(ctx, pk, model);
    }
}

