/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.app.handler.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.webservice.WSBillMappingFactory;
import com.kingdee.eas.csinterface.webservice.WSBillMappingInfo;
import com.kingdee.eas.csinterface.webservice.WSFreeMarkerInfo;
import com.kingdee.eas.csinterface.webservice.WSInterfaceInfo;
import com.kingdee.eas.csinterface.webservice.app.handler.Handler;
import com.kingdee.eas.csinterface.webservice.app.log.WSCallRecordManager;
import com.kingdee.eas.csinterface.webservice.app.util.ResourceHolder;
import com.kingdee.eas.csinterface.webservice.app.webservice.engine.view.ViewResolver;
import com.kingdee.eas.csinterface.webservice.app.webservice.engine.view.impl.FreeMarkerViewResolver;
import com.kingdee.eas.csinterface.webservice.framework.exception.EIPBaseException;
import javax.annotation.Resource;

public abstract class AbstractHandler
implements Handler {
    @Resource
    protected ViewResolver viewResolver = new FreeMarkerViewResolver();

    @Override
    public Object doHandle(WSInterfaceInfo wsi, Object data) throws EIPBaseException, Exception {
        Object result = this.doReturnHandle(wsi, data);
        WSFreeMarkerInfo returnMarker = ResourceHolder.getTransferMarker();
        if (returnMarker == null || StringUtil.isEmpty((String)returnMarker.getContext())) {
            return result == null ? "" : result.toString();
        }
        Long beginTime = System.currentTimeMillis();
        Object returnData = this.viewResolver.resolveView(returnMarker.getContext(), result);
        WSCallRecordManager.enterProcessingTime(beginTime, System.currentTimeMillis());
        return returnData;
    }

    public Object doReturnHandle(WSInterfaceInfo wsi, Object data) throws EIPBaseException, Exception {
        String id = wsi.getWsbillMapping().getId().toString();
        WSBillMappingInfo wsbminfo = null;
        Context ctx = ResourceHolder.getContext();
        try {
            wsbminfo = WSBillMappingFactory.getLocalInstance(ctx).getWSBillMappingInfo(CommonUtil.convert2PK(id), this.getSelectors());
        }
        catch (Exception e) {
            throw new EIPBaseException(1240, "\u6570\u636e\u67e5\u8be2\u5f02\u5e38:" + e.getMessage());
        }
        if (wsbminfo == null) {
            throw new EIPBaseException(1240, "\u6570\u636e\u67e5\u8be2\u5f02\u5e38");
        }
        long beginTime = System.currentTimeMillis();
        Object result = this.innerHandler(wsbminfo, data);
        long endTime = System.currentTimeMillis();
        WSCallRecordManager.enterFetchTime(beginTime, endTime);
        if (result instanceof IObjectCollection) {
            WSCallRecordManager.enterHeadAndEntryDataSize(((IObjectCollection)result).size(), 0);
        } else {
            WSCallRecordManager.enterHeadAndEntryDataSize(0, 0);
        }
        return result;
    }

    public abstract Object innerHandler(WSBillMappingInfo var1, Object var2) throws EIPBaseException, Exception;

    protected SelectorItemCollection getSelectors() {
        throw new UnsupportedOperationException();
    }
}

