/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.app.handler.impl;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.csinterface.webservice.ImplType;
import com.kingdee.eas.csinterface.webservice.WSBillMappingEntryInfo;
import com.kingdee.eas.csinterface.webservice.WSBillMappingInfo;
import com.kingdee.eas.csinterface.webservice.WSFreeMarkerInfo;
import com.kingdee.eas.csinterface.webservice.app.handler.impl.AbstractHandler;
import com.kingdee.eas.csinterface.webservice.app.log.WSCallRecordManager;
import com.kingdee.eas.csinterface.webservice.app.util.ResourceHolder;
import com.kingdee.eas.csinterface.webservice.framework.exception.EIPBaseException;
import com.kingdee.eas.util.app.DbUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class QueryHandler
extends AbstractHandler {
    private static Logger logger = Logger.getLogger(QueryHandler.class);

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("freeMarker.*"));
        sic.add(new SelectorItemInfo("entrys.srcField"));
        sic.add(new SelectorItemInfo("entrys.destField"));
        return sic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object innerHandler(WSBillMappingInfo wsbminfo, Object data) throws EIPBaseException, Exception {
        String entityView;
        Context ctx = ResourceHolder.getContext();
        Object returnData = null;
        JSONObject dataMap = JSONObject.parseObject((String)data.toString());
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        WSFreeMarkerInfo queryMarker = ResourceHolder.getQueryMarker();
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        for (int i = 0; i < wsbminfo.getEntrys().size(); ++i) {
            WSBillMappingEntryInfo entry = wsbminfo.getEntrys().get(i);
            if (entry.isDropped()) continue;
            fieldMap.put(entry.getSrcField(), entry.getDestField());
        }
        if (fieldMap.size() == 0) {
            returnData = this.viewResolver.resolveView(queryMarker.getContext(), dataMap);
        } else {
            Set keys = dataMap.keySet();
            if (queryMarker == null) {
                for (Object key : keys) {
                    String entityField = (String)fieldMap.get(key);
                    if (entityField == null) {
                        throw new EIPBaseException(1230, "\u975e\u6cd5\u914d\u7f6e:\u5b57\u6bb5" + (String)key + "\u627e\u4e0d\u5230\u5176\u5bf9\u5e94\u7684\u6a21\u578b\u5c5e\u6027");
                    }
                    Object value = dataMap.get(key);
                    filter.getFilterItems().add(new FilterItemInfo(entityField, value, CompareType.EQUALS));
                }
            } else {
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (String key : keys) {
                    String entityField = (String)fieldMap.get(key);
                    if (entityField == null) {
                        throw new EIPBaseException(1230, "\u975e\u6cd5\u914d\u7f6e:\u5b57\u6bb5" + key + "\u627e\u4e0d\u5230\u5176\u5bf9\u5e94\u7684\u6a21\u578b\u5c5e\u6027");
                    }
                    Object value = dataMap.get((Object)key);
                    map.put(entityField, value);
                }
                returnData = this.viewResolver.resolveView(queryMarker.getContext(), map);
            }
        }
        Object result = null;
        if (ImplType.entity.equals((Object)wsbminfo.getImplType()) || ImplType.facade.equals((Object)wsbminfo.getImplType())) {
            if (returnData == null) {
                throw new NullPointerException();
            }
            entityView = returnData.toString().trim();
            if (!entityView.toLowerCase(Locale.ENGLISH).startsWith("where ")) {
                entityView = "where " + entityView;
            }
            ev = new EntityViewInfo(entityView);
            String clzName = wsbminfo.getImplClass() + "Factory";
            try {
                Class<?> clz = Class.forName(clzName);
                Method method = clz.getMethod("getLocalInstance", Context.class);
                Object object = method.invoke(clz, ctx);
                Class<?> facade = object.getClass();
                Method method2 = facade.getMethod(wsbminfo.getImplMethod(), EntityViewInfo.class);
                result = method2.invoke(object, ev);
            }
            finally {
                WSCallRecordManager.enterImplClassAndMethod(ctx, wsbminfo.getImplClass(), wsbminfo.getImplMethod());
            }
        } else if (ImplType.sql.equals((Object)wsbminfo.getImplType())) {
            if (returnData == null) {
                throw new NullPointerException();
            }
            result = DbUtil.executeQuery((Context)ctx, (String)returnData.toString());
        }
        if (ImplType.query.equals((Object)wsbminfo.getImplType())) {
            if (returnData == null) {
                throw new NullPointerException();
            }
            entityView = returnData.toString().trim();
            if (!entityView.toLowerCase(Locale.ENGLISH).startsWith("where ")) {
                entityView = "where " + entityView;
            }
            ev = new EntityViewInfo(entityView);
            String queryName = wsbminfo.getImplClass().toString();
            MetaDataPK queryPK = MetaDataPK.create((String)queryName);
            IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
            IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            QueryInfo queryInfo = loader.getQuery((IMetaDataPK)queryPK);
            IDynamicObject instance = DynamicObjectFactory.getLocalInstance((Context)ctx);
            SubObjectInfo mainObjectInfo = queryInfo.getMainObject();
            SubEntityInfo mainEntityInfo = null;
            if (mainObjectInfo instanceof SubEntityInfo) {
                mainEntityInfo = (SubEntityInfo)mainObjectInfo;
                mainEntityInfo.getEntityRef();
            }
            BOSObjectType type = null;
            if (mainEntityInfo != null && mainEntityInfo.getEntityRef() != null) {
                type = mainEntityInfo.getEntityRef().getType();
            }
            try {
                result = instance.getCollection(type, ev);
                if (result == null || result.equals("")) {
                    logger.info((Object)("\u627e\u4e0d\u5230query\u7c7b\u578b:" + queryName));
                }
            }
            catch (Exception e) {
                throw new Exception("query\u67e5\u627e\u5f02\u5e38:" + queryName, e);
            }
        }
        return result;
    }
}

