/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.app.handler.user;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.eas.csinterface.util.ClassUtil;
import com.kingdee.eas.csinterface.webservice.WSBillMappingInfo;
import com.kingdee.eas.csinterface.webservice.WSServiceInfo;
import com.kingdee.eas.csinterface.webservice.app.handler.IUserHandler;
import com.kingdee.eas.csinterface.webservice.app.handler.user.AbstractUserHandler;
import com.kingdee.eas.csinterface.webservice.app.model.WSDataModelUtil;
import com.kingdee.eas.csinterface.webservice.app.model.WSStructuredDataModel;
import com.kingdee.eas.csinterface.webservice.app.util.ResourceHolder;
import com.kingdee.eas.csinterface.webservice.app.webapi.util.HttpServiceHelper;
import com.kingdee.eas.csinterface.webservice.app.webservice.model.ReturnModel;
import com.kingdee.eas.csinterface.webservice.model.WSDynamicBillTemplateInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GuanYiUserHandler
extends AbstractUserHandler {
    @Override
    public Object handleSend(Context ctx, WSBillMappingInfo wsb, WSServiceInfo serviceInfo, Object[] sendData) throws BOSException {
        String postUrl = GuanYiUserHandler.getServiceURL(serviceInfo);
        String bodyData = sendData[1].toString();
        Map resultMap = (Map)HttpServiceHelper.doPost(postUrl, null, bodyData, Map.class);
        return resultMap;
    }

    @Override
    public List<ReturnModel> handleResult(Context ctx, WSBillMappingInfo wsb, Object data, String pkField) throws BOSException {
        super.handleResult(ctx, wsb, data, pkField);
        List<ReturnModel> result = new ArrayList<ReturnModel>(50);
        JSONObject jsonResult = JSONObject.parseObject((String)data.toString());
        if (Boolean.valueOf(jsonResult.get((Object)"result").toString()).booleanValue()) {
            WSStructuredDataModel model;
            try {
                model = WSDataModelUtil.convert(wsb);
            }
            catch (DIPException e) {
                throw new BOSException((Throwable)e);
            }
            IUserHandler userHandle = (IUserHandler)ClassUtil.getNewInstance(wsb.getImplClass());
            JSONObject msg = jsonResult.getJSONObject("message");
            Integer pageCount = msg.getInteger("PageCount");
            Integer pageNum = msg.getInteger("PageNum");
            Integer pageSize = msg.getInteger("PageSize");
            Integer recordCount = msg.getInteger("RecordCount");
            JSONArray dataArray = null;
            dataArray = msg.getJSONArray("Data");
            result = this.dealResultData(wsb, model, userHandle, dataArray);
        }
        return result;
    }

    private List<ReturnModel> dealResultData(WSBillMappingInfo wsb, WSStructuredDataModel model, IUserHandler userHandle, Object data) throws BOSException {
        List<ReturnModel> result = null;
        try {
            JSONArray dataArray = JSONObject.parseArray((String)data.toString());
            int len = dataArray.size();
            ArrayList<WSDynamicBillTemplateInfo> dataList = new ArrayList<WSDynamicBillTemplateInfo>(2 * len);
            for (int i = 0; i < len; ++i) {
                WSDynamicBillTemplateInfo transferData = (WSDynamicBillTemplateInfo)this.translater.doTranslate(model, dataArray.get(i));
                dataList.add(transferData);
            }
            result = userHandle.handleResult(ResourceHolder.getContext(), wsb, dataList, model.getPkField());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }
}

