/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.app.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.eas.csinterface.webservice.DataStructureTableModel;
import com.kingdee.eas.csinterface.webservice.Region;
import com.kingdee.eas.csinterface.webservice.WSBillMappingEntryCollection;
import com.kingdee.eas.csinterface.webservice.WSBillMappingEntryInfo;
import com.kingdee.eas.csinterface.webservice.WSBillMappingInfo;
import com.kingdee.eas.csinterface.webservice.app.model.WSColumnModel;
import com.kingdee.eas.csinterface.webservice.app.model.WSStructuredDataModel;
import com.kingdee.eas.csinterface.webservice.app.model.WSTableModel;
import com.kingdee.eas.csinterface.webservice.app.webservice.model.OneStructer;
import com.kingdee.eas.csinterface.webservice.app.webservice.model.SecondStructer;
import com.kingdee.eas.csinterface.webservice.app.webservice.model.StructerModel;
import com.kingdee.eas.csinterface.webservice.app.webservice.model.StructerUtil;
import com.kingdee.eas.csinterface.webservice.app.webservice.model.ThreeStructer;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class WSDataModelUtil {
    public static final WSStructuredDataModel convert(WSBillMappingInfo mapping) throws DIPException {
        WSTableModel t_header;
        if (mapping == null) {
            throw new NullPointerException("\u6a21\u578b\u4fe1\u606f\u4e3a\u7a7a!");
        }
        WSStructuredDataModel structuredDataModel = null;
        if (!mapping.isPublished()) {
            return structuredDataModel;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("number", mapping.getNumber());
        DataStructureTableModel model = WSDataModelUtil.deteminedTableModel(mapping);
        StructerModel structerModel = StructerUtil.buildStructer(mapping, false);
        WSTableModel[] tms = new WSTableModel[structerModel.getEntityLength()];
        WSBillMappingEntryCollection cols = mapping.getEntrys();
        ArrayList<WSColumnModel> head = new ArrayList<WSColumnModel>();
        ArrayList<WSColumnModel> entry = new ArrayList<WSColumnModel>();
        HashMap entryMap = new HashMap();
        HashMap subEntryMap = new HashMap();
        ArrayList<WSColumnModel> sub_entry = new ArrayList<WSColumnModel>();
        String pkField = null;
        String srcField = "";
        String srcAlias = "";
        Object entryName = null;
        Iterator itr = cols.iterator();
        while (itr.hasNext()) {
            WSBillMappingEntryInfo fieldMapping = (WSBillMappingEntryInfo)itr.next();
            if (fieldMapping.isDropped() || !fieldMapping.isPublished()) continue;
            String sqlTypeName = fieldMapping.getFieldType().getName();
            SQLType sqlType = SQLType.getEnum((String)sqlTypeName);
            srcField = fieldMapping.getSrcField() == null ? "srcField" : fieldMapping.getSrcField();
            srcAlias = fieldMapping.getSrcAlias() == null ? "srcAlias" : fieldMapping.getSrcAlias();
            WSColumnModel column = new WSColumnModel(srcField, srcAlias, fieldMapping.getDestField(), fieldMapping.getDestAlias(), sqlType, fieldMapping.isUnique(), fieldMapping.getBaseDataType(), fieldMapping.getBaseDataField(), fieldMapping.getDefaultValue(), fieldMapping.getFormater(), fieldMapping.getDefaulttype());
            if (Region.head.equals((Object)fieldMapping.getRegion())) {
                head.add(column);
            } else if (Region.entry.equals((Object)fieldMapping.getRegion())) {
                entry.add(column);
            } else if (Region.subEntry.equals((Object)fieldMapping.getRegion())) {
                sub_entry.add(column);
            }
            if (!fieldMapping.isUnique()) continue;
            pkField = fieldMapping.getDestField();
        }
        structuredDataModel = new WSStructuredDataModel(mapping.getNumber(), mapping.getName(), map, tms, pkField);
        if (DataStructureTableModel.H.equals((Object)model)) {
            tms[0] = t_header = new WSTableModel("header", head.toArray(new WSColumnModel[0]), "header", "header");
        } else if (DataStructureTableModel.HD.equals((Object)model)) {
            tms[0] = t_header = new WSTableModel("header", head.toArray(new WSColumnModel[0]), "header", "header");
            SecondStructer second = (SecondStructer)structerModel;
            List<OneStructer> oneList = second.getMappings();
            OneStructer one = null;
            int j = oneList.size();
            for (int i = 0; i < j; ++i) {
                WSTableModel t_entry;
                one = oneList.get(i);
                tms[i + 1] = t_entry = new WSTableModel(one.getSrcEntry(), entry.toArray(new WSColumnModel[0]), one.getSrcEntry(), one.getDesEntry());
                structuredDataModel.addTableRelation(t_header, t_entry, 1);
            }
        } else if (DataStructureTableModel.HDD.equals((Object)model)) {
            tms[0] = t_header = new WSTableModel("header", head.toArray(new WSColumnModel[0]), "header", "header");
            ThreeStructer three = (ThreeStructer)structerModel;
            List<SecondStructer> secondList = three.getMappings();
            SecondStructer second = null;
            OneStructer one = null;
            int index = 1;
            int j = secondList.size();
            for (int i = 0; i < j; ++i) {
                second = secondList.get(i);
                if (one == null) {
                    throw new NullPointerException();
                }
                WSTableModel t_entry = new WSTableModel(second.getDesEntry(), entry.toArray(new WSColumnModel[0]), one.getSrcEntry(), one.getDesEntry());
                tms[index++] = t_entry;
                structuredDataModel.addTableRelation(t_header, t_entry, 1);
                List<OneStructer> oneList = second.getMappings();
                int k = 0;
                int m = oneList.size();
                while (k < m) {
                    one = oneList.get(i);
                    WSTableModel t_sub_entry = new WSTableModel(one.getDesEntry(), entry.toArray(new WSColumnModel[0]), one.getSrcEntry(), one.getDesEntry());
                    tms[index++] = t_sub_entry;
                    structuredDataModel.addTableRelation(t_entry, t_sub_entry, 1);
                    ++i;
                }
            }
        }
        structuredDataModel.setCompleted();
        return structuredDataModel;
    }

    public static final String formatData(WSBillMappingInfo mapping, Object data, String formatStyle) throws BOSException, DIPException {
        Object result = null;
        WSStructuredDataModel dataModel = WSDataModelUtil.convert(mapping);
        WSTableModel[] tables = dataModel.getPriorityTables();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        if (data instanceof CoreBaseCollection) {
            CoreBaseCollection coll = (CoreBaseCollection)data;
            Iterator it = coll.iterator();
            CoreBaseInfo bill = null;
            while (it.hasNext()) {
                bill = (CoreBaseInfo)it.next();
                for (WSTableModel tableModel : tables) {
                    WSColumnModel[] columns = tableModel.getColumns();
                    if ("header".equals(tableModel.srcEntity)) {
                        for (WSColumnModel columnModel : columns) {
                            int k;
                            String fieldName = columnModel.name;
                            String value = "";
                            if (!StringUtils.isEmpty((CharSequence)columnModel.defaultValue)) {
                                value = columnModel.defaultValue;
                                dataMap.put(fieldName, value);
                                continue;
                            }
                            Object obj = bill.get(columns[k].name);
                            value = WSDataModelUtil.formatValue(columnModel, obj);
                            dataMap.put(fieldName, value);
                        }
                        continue;
                    }
                    if (!"Entry".equals(tableModel.srcEntity)) continue;
                    Object tempObj = bill.get(tableModel.srcEntity);
                    ArrayList mapList = new ArrayList();
                    dataMap.put(tableModel.getDesEntiry(), mapList);
                    if (!(data instanceof CoreBaseCollection)) continue;
                    CoreBaseCollection tempColl = (CoreBaseCollection)tempObj;
                    Iterator tempIt = tempColl.iterator();
                    CoreBaseInfo tempBill = null;
                    while (it.hasNext()) {
                        tempBill = (CoreBaseInfo)tempIt.next();
                        HashMap<String, String> tempMap = new HashMap<String, String>();
                        for (WSColumnModel columnModel : columns) {
                            int k;
                            String fieldName = columnModel.name;
                            String value = "";
                            if (!StringUtils.isEmpty((CharSequence)columnModel.defaultValue)) {
                                value = columnModel.defaultValue;
                                tempMap.put(fieldName, value);
                                continue;
                            }
                            Object obj = tempBill.get(columns[k].name);
                            value = WSDataModelUtil.formatValue(columnModel, obj);
                            tempMap.put(fieldName, value);
                        }
                        mapList.add(tempMap);
                    }
                }
            }
        }
        return ((Object)dataMap).toString();
    }

    private static String formatValue(WSColumnModel columnModel, Object sourceValue) {
        Object value = "";
        String formater = columnModel.formater;
        if (sourceValue == null) {
            return "";
        }
        String baseDataField = columnModel.baseDataField;
        if (sourceValue instanceof CoreBaseInfo) {
            value = ((CoreBaseInfo)sourceValue).get(baseDataField);
        }
        if (StringUtils.isEmpty((CharSequence)formater)) {
            return value.toString();
        }
        if (sourceValue instanceof Date) {
            SimpleDateFormat dateFormater = new SimpleDateFormat(formater);
            value = dateFormater.format(sourceValue);
        } else if (sourceValue instanceof Boolean) {
            String[] formatValue = formater.split(",");
            String trueValue = formatValue[0].split(":")[1];
            String falseValue = formatValue[1].split(":")[1];
            value = Boolean.valueOf(sourceValue.toString()) != false ? trueValue : falseValue;
        }
        return value.toString();
    }

    public static DataStructureTableModel deteminedTableModel(WSBillMappingInfo info) {
        DataStructureTableModel model = DataStructureTableModel.H;
        WSBillMappingEntryInfo entry = null;
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            entry = info.getEntrys().get(i);
            if (entry.isDropped()) continue;
            if (Region.entry.equals((Object)info.getEntrys().get(i).getRegion())) {
                model = DataStructureTableModel.HD;
            }
            if (!Region.subEntry.equals((Object)info.getEntrys().get(i).getRegion())) continue;
            return DataStructureTableModel.HDD;
        }
        return model;
    }
}

