/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.app.util;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.eas.csinterface.app.base.EIPLicenseCheckUtil;
import com.kingdee.eas.csinterface.common.DIPException;
import com.kingdee.eas.csinterface.util.ClassUtil;
import com.kingdee.eas.csinterface.webservice.ImplType;
import com.kingdee.eas.csinterface.webservice.Launch;
import com.kingdee.eas.csinterface.webservice.ServiceType;
import com.kingdee.eas.csinterface.webservice.SynchModel;
import com.kingdee.eas.csinterface.webservice.WSCallRecordInfo;
import com.kingdee.eas.csinterface.webservice.WSErrorParamLogInfo;
import com.kingdee.eas.csinterface.webservice.WSIdentificationCodeFactory;
import com.kingdee.eas.csinterface.webservice.WSIdentificationCodeInfo;
import com.kingdee.eas.csinterface.webservice.WSInterfaceFactory;
import com.kingdee.eas.csinterface.webservice.WSInterfaceInfo;
import com.kingdee.eas.csinterface.webservice.WSTransferLogInfo;
import com.kingdee.eas.csinterface.webservice.app.handler.IUserHandler;
import com.kingdee.eas.csinterface.webservice.app.log.WSCallRecordManager;
import com.kingdee.eas.csinterface.webservice.app.log.WSErrorParamLogManager;
import com.kingdee.eas.csinterface.webservice.app.model.WSDataModelUtil;
import com.kingdee.eas.csinterface.webservice.app.model.WSStructuredDataModel;
import com.kingdee.eas.csinterface.webservice.app.util.ResourceHolder;
import com.kingdee.eas.csinterface.webservice.app.util.ReturnDataService;
import com.kingdee.eas.csinterface.webservice.app.webservice.engine.translate.impl.XMLToJSONTranslater;
import com.kingdee.eas.csinterface.webservice.framework.exception.EIPBaseException;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class WebServiceParamCheckUtils
implements Serializable {
    private static final long serialVersionUID = -1049289207812507050L;
    private static Logger logger = Logger.getLogger(WebServiceParamCheckUtils.class);

    public static void checkService(Context ctx, String config, Object data, WSTransferLogInfo wstransferLogInfo) throws BOSException {
        EIPLicenseCheckUtil.checkLicenseEnough(ctx);
        if (wstransferLogInfo == null) {
            WebServiceParamCheckUtils.checkService(ctx, config, data);
        } else {
            WebServiceParamCheckUtils.checkService(ctx, wstransferLogInfo);
        }
    }

    private static void checkService(Context ctx, String config, Object data) throws BOSException {
        ResourceHolder.put(ctx);
        try {
            WebServiceParamCheckUtils.checkParams(ctx, config, data);
        }
        catch (EIPBaseException e) {
            try {
                WSErrorParamLogInfo errorParamLogInfo = new WSErrorParamLogInfo();
                errorParamLogInfo = WSErrorParamLogManager.error(ctx, e, errorParamLogInfo, config, data);
                WSErrorParamLogManager.exit(ctx, errorParamLogInfo);
            }
            catch (Exception e1) {
                StringBuffer errorMsg = new StringBuffer();
                errorMsg.append("record error param log error,").append("config:").append(config).append(";").append("data:").append(data.toString());
                logger.error((Object)errorMsg.toString(), (Throwable)e1);
            }
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private static void checkService(Context ctx, WSTransferLogInfo wstransferLogInfo) throws BOSException {
        ResourceHolder.put(ctx);
        String config = "\u4efb\u52a1\u6c60id:" + wstransferLogInfo.getId().toString() + "\n\u63a5\u53e3\u8c03\u7528\u65e5\u5fd7\u7f16\u7801id:" + wstransferLogInfo.getCallRecordID().getId().toString();
        try {
            WebServiceParamCheckUtils.checkParams(ctx, wstransferLogInfo);
        }
        catch (EIPBaseException e) {
            try {
                WSErrorParamLogInfo errorParamLogInfo = new WSErrorParamLogInfo();
                errorParamLogInfo = WSErrorParamLogManager.error(ctx, e, errorParamLogInfo, config, "");
                WSErrorParamLogManager.exit(ctx, errorParamLogInfo);
            }
            catch (Exception e1) {
                StringBuffer errorMsg = new StringBuffer();
                errorMsg.append("record error param log error,").append("config:").append(config).append(";");
                logger.error((Object)errorMsg.toString(), (Throwable)e1);
            }
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private static void checkParams(Context ctx, WSTransferLogInfo wstransferLogInfo) throws EIPBaseException {
        try {
            if (wstransferLogInfo == null || wstransferLogInfo.getCallRecordID() == null) {
                throw ReturnDataService.formatError(1280, "\u975e\u6cd5\u914d\u7f6e\u53c2\u6570\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01");
            }
            WSCallRecordInfo wscallRecordInfo = wstransferLogInfo.getCallRecordID();
            WSInterfaceInfo wsinterfaceInfo = null;
            WSIdentificationCodeInfo wsidentificationCodeInfo = null;
            String oql = "select *,wsbillMapping.*,wsbillMapping.entrys.*,webservice.*,webservice.tree.*,webservice.entrys.*,webservice.entrys.freeMarker.*,webservice.entrys.loginService.* where id='" + wscallRecordInfo.getInterfaceID().getId().toString() + "'";
            wsinterfaceInfo = WSInterfaceFactory.getLocalInstance(ctx).getWSInterfaceInfo(oql);
            wsidentificationCodeInfo = WSIdentificationCodeFactory.getLocalInstance(ctx).getWSIdentificationCodeInfo("select * where id = '" + wscallRecordInfo.getIndenfiticationCode().getId().toString() + "'");
            ResourceHolder.put(wsinterfaceInfo);
            ResourceHolder.put(wsinterfaceInfo.getWebservice());
            ResourceHolder.put(wsinterfaceInfo.getWsbillMapping());
            if (wsinterfaceInfo == null || wsinterfaceInfo.getWsbillMapping() == null || wsidentificationCodeInfo == null) {
                throw ReturnDataService.formatError(1280, "\u975e\u6cd5\u914d\u7f6e\u53c2\u6570\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01");
            }
            if (!wsidentificationCodeInfo.isEnable() || !wsinterfaceInfo.isEnabled() || wsinterfaceInfo.getWebservice() != null && !wsinterfaceInfo.getWebservice().isEnabled()) {
                throw ReturnDataService.formatError(1280, "\u975e\u6cd5\u914d\u7f6e\u53c2\u6570\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01");
            }
        }
        catch (Exception e) {
            throw ReturnDataService.formatError(1240, e.getMessage());
        }
    }

    private static void checkParams(Context ctx, String config, Object data) throws EIPBaseException {
        XMLToJSONTranslater xmlToJSONTranslater = new XMLToJSONTranslater();
        if (StringUtils.isEmpty((String)config) || data == null || StringUtils.isEmpty((String)data.toString())) {
            throw ReturnDataService.formatError(1020, "\u5fc5\u586b\u53c2\u6570\u4e3a\u7a7a");
        }
        String newConfig = XMLToJSONTranslater.converXML2JSON(config, xmlToJSONTranslater).toString();
        JSONObject configMap = null;
        try {
            configMap = (JSONObject)JSONObject.parse((String)newConfig);
        }
        catch (Exception e) {
            throw ReturnDataService.formatError(1230, "\u975e\u6cd5\u53c2\u6570");
        }
        String interfaceID = configMap.getString("interfaceId");
        String license = configMap.getString("license");
        String synch = configMap.getString("synchronized");
        String execid = "";
        if ("2".equals(synch)) {
            execid = synch;
            ResourceHolder.putSynchModel(SynchModel.asynch);
        } else {
            ResourceHolder.putSynchModel(SynchModel.synch);
        }
        if (StringUtil.isEmpty((String)interfaceID) || StringUtil.isEmpty((String)license)) {
            throw ReturnDataService.formatError(1020, "\u5fc5\u586b\u53c2\u6570\u4e3a\u7a7a");
        }
        WSInterfaceInfo wsi = null;
        WSIdentificationCodeInfo identificationCode = null;
        try {
            String oql = "select *,queryFreeMarker.*,returnMapping.*,returnMapping.entrys.*,wsbillMapping.*,wsbillMapping.entrys.*,freeMarker.*,webservice.*,webservice.tree.*,webservice.entrys.*,webservice.entrys.freeMarker.*,webservice.entrys.loginService.* where number='" + interfaceID + "'";
            wsi = WSInterfaceFactory.getLocalInstance(ctx).getWSInterfaceInfo(oql);
            identificationCode = WSIdentificationCodeFactory.getLocalInstance(ctx).getWSIdentificationCodeInfo("select * where number='" + license + "'");
            if (wsi == null || wsi.getWsbillMapping() == null || identificationCode == null) {
                throw ReturnDataService.formatError(1280, "\u975e\u6cd5\u914d\u7f6e\u53c2\u6570\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01");
            }
            if (!identificationCode.isEnable() || !wsi.isEnabled() || wsi.getWebservice() != null && !wsi.getWebservice().isEnabled()) {
                throw ReturnDataService.formatError(1280, "\u975e\u6cd5\u914d\u7f6e\u53c2\u6570\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01");
            }
            ResourceHolder.put(wsi);
            ResourceHolder.putQueryMarker(wsi.getQueryFreeMarker());
            ResourceHolder.putTransferMarker(wsi.getFreeMarker());
            ResourceHolder.put(wsi.getWebservice());
            ResourceHolder.put(wsi.getWsbillMapping());
            ResourceHolder.put(identificationCode);
        }
        catch (Exception e) {
            throw ReturnDataService.formatError(1240, e.getMessage());
        }
        String servicetype = wsi.getServiceType() == null ? "" : wsi.getServiceType().toString();
        try {
            WSStructuredDataModel model = WSDataModelUtil.convert(wsi.getWsbillMapping());
            ResourceHolder.put(model);
        }
        catch (DIPException e1) {
            throw ReturnDataService.formatError(1280, e1.getMessage());
        }
        Launch launchType = ServiceType.outPut == wsi.getServiceType() ? Launch.EAS : Launch.outSystem;
        WSCallRecordManager.enter(ctx, wsi, identificationCode, launchType, data, config, execid, servicetype);
        WSCallRecordManager.enterImplClassAndMethod(ctx, wsi.getWsbillMapping().getImplClass(), wsi.getWsbillMapping().getImplMethod());
        boolean flag = ImplType.userClass.equals((Object)wsi.getWsbillMapping().getImplType());
        if (flag) {
            try {
                IUserHandler userHandle = (IUserHandler)ClassUtil.getNewInstance(wsi.getWsbillMapping().getImplClass());
                ResourceHolder.put(userHandle);
            }
            catch (Exception e) {
                throw ReturnDataService.formatError(8000, e.getMessage());
            }
        }
    }
}

