/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.app.webapi.handle.impl;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.csinterface.util.ClassUtil;
import com.kingdee.eas.csinterface.util.CommonUtil;
import com.kingdee.eas.csinterface.webservice.IWSTransferLog;
import com.kingdee.eas.csinterface.webservice.LogStatus;
import com.kingdee.eas.csinterface.webservice.WSIdentificationCodeFactory;
import com.kingdee.eas.csinterface.webservice.WSIdentificationCodeInfo;
import com.kingdee.eas.csinterface.webservice.WSInterfaceFactory;
import com.kingdee.eas.csinterface.webservice.WSInterfaceInfo;
import com.kingdee.eas.csinterface.webservice.WSTransferLogFactory;
import com.kingdee.eas.csinterface.webservice.WSTransferLogInfo;
import com.kingdee.eas.csinterface.webservice.app.handler.IUserHandler;
import com.kingdee.eas.csinterface.webservice.app.log.WSCallRecordManager;
import com.kingdee.eas.csinterface.webservice.app.util.ResourceHolder;
import com.kingdee.eas.csinterface.webservice.app.util.ReturnDataService;
import com.kingdee.eas.csinterface.webservice.app.webservice.model.ReturnModel;
import java.util.List;

public class AsyncInterfeceServiceImpl {
    public static String buildBodyData(Context ctx, String preSendData) throws Exception {
        JSONObject data = new JSONObject();
        data.put("data", (Object)preSendData);
        String interfaceId = ResourceHolder.getWSInterfaceInfo().getNumber();
        data.put("interfaceId", (Object)interfaceId);
        String logId = WSCallRecordManager.getCurrent().getId().toString();
        data.put("logid", (Object)logId);
        return data.toString();
    }

    public static List<ReturnModel> feedback(Context ctx, String config, String bodyData) throws Exception {
        List<ReturnModel> resultList = null;
        String solutionNum = null;
        String license = null;
        String data = null;
        JSONObject bodyObj = null;
        try {
            JSONObject configObj = JSONObject.parseObject((String)config);
            solutionNum = configObj.getString("interfaceId");
            license = configObj.getString("license");
            bodyObj = JSONObject.parseObject((String)bodyData);
            data = bodyObj.getString("data");
        }
        catch (Exception e) {
            throw new Exception("\u8bf7\u6c42\u6570\u636e\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5");
        }
        AsyncInterfeceServiceImpl.checkLicense(ctx, license);
        AsyncInterfeceServiceImpl.updateMonitorlog(ctx, bodyObj);
        IUserHandler userHandle = AsyncInterfeceServiceImpl.getUserHandle(ctx, solutionNum);
        if (userHandle != null) {
            resultList = userHandle.handleResult(ctx, null, data, null);
        }
        return resultList;
    }

    private static void checkLicense(Context ctx, String license) throws Exception {
        WSIdentificationCodeInfo identificationCode = WSIdentificationCodeFactory.getLocalInstance(ctx).getWSIdentificationCodeInfo("select * where number='" + license + "'");
        if (identificationCode == null || !identificationCode.isEnable()) {
            throw ReturnDataService.formatError(1280, "\u975e\u6cd5\u914d\u7f6e\u53c2\u6570\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01");
        }
    }

    private static void updateMonitorlog(Context ctx, JSONObject bodyObj) throws Exception {
        String logId = bodyObj.getString("logid");
        String status = bodyObj.getString("status");
        String errorMsg = bodyObj.getString("errormsg");
        String data = bodyObj.getString("data");
        IWSTransferLog instance = WSTransferLogFactory.getLocalInstance(ctx);
        WSTransferLogInfo logInfo = null;
        try {
            IObjectPK logPK = CommonUtil.convert2PK(logId);
            logInfo = instance.getWSTransferLogInfo(logPK);
        }
        catch (Exception e) {
            throw new Exception("\u4f20\u5165\u7684LogID\u65e0\u6548\uff0c\u8bf7\u68c0\u67e5\u3002\u65e5\u5fd7ID:" + logId);
        }
        LogStatus logStatus = LogStatus.getEnum(status);
        if (logStatus == null) {
            throw new Exception("\u4f20\u5165\u7684\u72b6\u6001\u503c\u5f02\u5e38\uff0c1:\u6210\u529f;2:\u5931\u8d25\u3002");
        }
        logInfo.setStatus(logStatus);
        logInfo.setErrorMsg(errorMsg);
        logInfo.setReturnData(data);
        instance.updateLog(logInfo);
    }

    private static IUserHandler getUserHandle(Context ctx, String interfaceId) throws Exception {
        IUserHandler userHandle = null;
        WSInterfaceInfo wsi = null;
        try {
            String oql = "select wsbillMapping.implClass";
            wsi = WSInterfaceFactory.getLocalInstance(ctx).getWSInterfaceInfo(oql);
            String implClass = wsi.getWsbillMapping().getImplClass();
            if (implClass != null) {
                userHandle = (IUserHandler)ClassUtil.getNewInstance(wsi.getWsbillMapping().getImplClass());
            }
        }
        catch (Exception e) {
            throw new Exception("\u4f20\u5165\u7684\u65b9\u6848\u6709\u8bef\uff0c\u65e0\u6cd5\u6b63\u786e\u83b7\u53d6\u5bf9\u5e94\u7684\u4e1a\u52a1\u5b9e\u73b0\u7c7b");
        }
        return userHandle;
    }
}

