/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.app.webservice.engine.translate.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.csinterface.data.process.impl.BaseDataMappingHelper;
import com.kingdee.eas.csinterface.syncdatabase.BaseDataTypeInfo;
import com.kingdee.eas.csinterface.syncdatabase.app.util.BaseDataParse;
import com.kingdee.eas.csinterface.webservice.app.model.WSColumnModel;
import com.kingdee.eas.csinterface.webservice.app.model.WSStructuredDataModel;
import com.kingdee.eas.csinterface.webservice.app.model.WSTableModel;
import com.kingdee.eas.csinterface.webservice.app.util.ResourceHolder;
import com.kingdee.eas.csinterface.webservice.app.webservice.engine.translate.Translater;
import com.kingdee.eas.csinterface.webservice.framework.exception.EIPBaseException;
import com.kingdee.eas.csinterface.webservice.model.IWSDynamicBillTemplate;
import com.kingdee.eas.csinterface.webservice.model.WSDynamicBillTemplateExCollection;
import com.kingdee.eas.csinterface.webservice.model.WSDynamicBillTemplateExInfo;
import com.kingdee.eas.csinterface.webservice.model.WSDynamicBillTemplateInfo;
import com.kingdee.eas.csinterface.webservice.model.metadata.WsMetadata;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="jsonTranslater")
public class JSONTranslater
implements Translater {
    @Override
    public Object doTranslate(WSStructuredDataModel model, Object object) throws EIPBaseException, Exception {
        Context ctx = ResourceHolder.getContext();
        JSONObject jsondata = JSONObject.parseObject((String)object.toString());
        WSTableModel[] tables = model.getPriorityTables();
        List list = model.getPriorityTablesRelation();
        int root = 0;
        List<Integer> dependencys = this.getDependency(list, root);
        HashMap<Object, Map<String, CoreBaseInfo>> coreMap = new HashMap<Object, Map<String, CoreBaseInfo>>();
        try {
            HashMap<Object, Set<String>> map = new HashMap<Object, Set<String>>();
            this.processBaseDataMapping(root, tables, list, jsondata, dependencys, map);
            for (BaseDataTypeInfo type : map.keySet()) {
                Set set = (Set)map.get(type);
                Map<String, CoreBaseInfo> result = BaseDataParse.getData(set, ctx, type.getId().toString(), BaseDataMappingHelper.getCoreBaseInstance(ctx, type), null);
                coreMap.put(type, result);
            }
        }
        catch (EIPBaseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EIPBaseException(1250, "\u521d\u59cb\u5316\u503c\u6620\u5c04\u5931\u8d25:" + e.getMessage());
        }
        WSDynamicBillTemplateInfo info = new WSDynamicBillTemplateInfo();
        this.processDepencies(root, tables, list, jsondata, coreMap, dependencys, (CoreBaseInfo)info);
        WsMetadata dm = new WsMetadata((String)model.getProperty("number"));
        MetaDataPK pk = MetaDataPK.create((String)dm.getEntityPK());
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity((IMetaDataPK)pk);
        if (null == entity.getType()) {
            throw new Exception("can not find bostype when metadatapk=" + pk.toString());
        }
        info.setBOSType(entity.getType());
        Object entryInfo = info.get("entrys");
        if (entryInfo != null) {
            WSDynamicBillTemplateExCollection coll = (WSDynamicBillTemplateExCollection)((Object)entryInfo);
            for (int i = 0; i < coll.size(); ++i) {
                if (coll.get(i).getId() != null && !coll.get(i).getId().equals((Object)"")) continue;
                coll.get(i).setId(BOSUuid.create((BOSObjectType)new BOSObjectType("76B6D642")));
            }
            ((IWSDynamicBillTemplate)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)entity.getType())).save((CoreBaseInfo)info);
        }
        return info;
    }

    private List<Integer> getDependency(List list, int root) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < list.size(); ++i) {
            int[] relation = (int[])list.get(i);
            int pre = relation[0];
            if (pre != root) continue;
            result.add(relation[1]);
        }
        return result;
    }

    public void processDepencies(int current, WSTableModel[] tables, List list, JSONObject jsondata, Map<Object, Map<String, CoreBaseInfo>> coreMap, List<Integer> dependencies, CoreBaseInfo info) throws EIPBaseException {
        WSTableModel self = tables[current];
        String defaultValue = "";
        for (WSColumnModel column : self.columns) {
            defaultValue = column.defaultValue;
            if (column.baseDataType != null) {
                Map<String, CoreBaseInfo> map = coreMap.get(column.baseDataType);
                String srcValue = jsondata.getString(column.name);
                if (!StringUtil.isEmpty((String)defaultValue)) {
                    info.put(column.destName, (Object)map.get(defaultValue));
                    continue;
                }
                CoreBaseInfo destInfo = map.get(srcValue);
                if (destInfo == null) {
                    throw new EIPBaseException(1260, "\u627e\u4e0d\u5230\u5bf9\u5e94\u503c\u6620\u5c04:" + srcValue);
                }
                info.put(column.destName, (Object)destInfo);
                continue;
            }
            if (!StringUtils.isEmpty((CharSequence)defaultValue)) {
                info.put(column.destName, (Object)defaultValue);
            }
            info.put(column.destName, jsondata.get((Object)column.name));
        }
        if (dependencies.isEmpty()) {
            return;
        }
        for (Integer dependency : dependencies) {
            WSTableModel table = tables[dependency];
            String srcPath = table.getSrcEntity();
            String destPath = table.getDesEntiry();
            JSONArray array = jsondata.getJSONArray(srcPath);
            if (array == null) {
                throw new EIPBaseException(1270, "\u5c5e\u6027\u503c\u4e3anull:" + srcPath);
            }
            WSDynamicBillTemplateExCollection excoll = new WSDynamicBillTemplateExCollection();
            for (Object o : array) {
                WSDynamicBillTemplateExInfo ex = new WSDynamicBillTemplateExInfo();
                JSONObject jo = (JSONObject)o;
                if (this.getDependency(list, dependency).size() != 0) {
                    this.processDepencies(dependency, tables, list, jo, coreMap, this.getDependency(list, dependency), (CoreBaseInfo)ex);
                    excoll.add(ex);
                    continue;
                }
                for (WSColumnModel column : table.columns) {
                    defaultValue = column.defaultValue;
                    if (column.baseDataType != null) {
                        Map<String, CoreBaseInfo> map = coreMap.get(column.baseDataType);
                        String srcValue = jo.getString(column.name.substring(column.name.indexOf(".") + 1));
                        if (!StringUtils.isEmpty((CharSequence)defaultValue)) {
                            ex.put(column.destName.substring(column.destName.indexOf(".") + 1), map.get(defaultValue));
                            continue;
                        }
                        CoreBaseInfo destInfo = map.get(srcValue);
                        if (destInfo == null) {
                            throw new EIPBaseException(1260, "\u627e\u4e0d\u5230\u5bf9\u5e94\u503c\u6620\u5c04:" + srcValue);
                        }
                        ex.put(column.destName.substring(column.destName.indexOf(".") + 1), destInfo);
                        continue;
                    }
                    if (!StringUtils.isEmpty((CharSequence)defaultValue)) {
                        ex.put(column.destName.substring(column.destName.indexOf(".") + 1), defaultValue);
                        continue;
                    }
                    String srcValue = jo.getString(column.name.substring(column.name.indexOf(".") + 1));
                    ex.put(column.destName.substring(column.destName.indexOf(".") + 1), srcValue);
                }
                excoll.add(ex);
            }
            info.put(destPath, (Object)excoll);
        }
    }

    public void processBaseDataMapping(int current, WSTableModel[] tables, List list, JSONObject jsondata, List<Integer> dependencies, Map<Object, Set<String>> map) throws EIPBaseException {
        WSTableModel self = tables[current];
        String defaultValue = null;
        for (WSColumnModel column : self.columns) {
            if (column.baseDataType == null) continue;
            Set<String> set = map.get(column.baseDataType);
            if (set == null) {
                set = new HashSet<String>();
                map.put(column.baseDataType, set);
            }
            if (!StringUtils.isEmpty((CharSequence)(defaultValue = column.defaultValue))) {
                set.add(column.defaultValue);
                continue;
            }
            if (jsondata.getString(column.name) == null) continue;
            set.add(jsondata.getString(column.name));
        }
        if (dependencies.isEmpty()) {
            return;
        }
        for (Integer dependency : dependencies) {
            WSTableModel table = tables[dependency];
            String path = table.getSrcEntity();
            JSONArray array = jsondata.getJSONArray(path);
            if (array == null) {
                throw new EIPBaseException(1270, "\u5c5e\u6027\u503c\u4e3anull:" + path);
            }
            for (Object o : array) {
                JSONObject jo = (JSONObject)o;
                for (WSColumnModel column : table.columns) {
                    if (column.baseDataType == null) continue;
                    Set<String> set = map.get(column.baseDataType);
                    if (set == null) {
                        set = new HashSet<String>();
                        map.put(column.baseDataType, set);
                    }
                    if (!StringUtils.isEmpty((CharSequence)(defaultValue = column.defaultValue))) {
                        set.add(column.defaultValue);
                        continue;
                    }
                    if (jo.getString(column.name.substring(column.name.indexOf(".") + 1)) == null) continue;
                    set.add(jo.getString(column.name.substring(column.name.indexOf(".") + 1)));
                }
                this.processBaseDataMapping(dependency, tables, list, jo, this.getDependency(list, dependency), map);
            }
        }
    }
}

