/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.csinterface.webservice.app.webservice.engine.translate.impl;

import com.alibaba.fastjson.JSON;
import com.kingdee.eas.csinterface.webservice.app.model.WSStructuredDataModel;
import com.kingdee.eas.csinterface.webservice.app.util.ResourceHolder;
import com.kingdee.eas.csinterface.webservice.app.util.ReturnDataService;
import com.kingdee.eas.csinterface.webservice.app.webservice.engine.translate.Translater;
import com.kingdee.eas.csinterface.webservice.framework.exception.EIPBaseException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.stereotype.Component;

@Component(value="xmlToJSONTranslater")
public class XMLToJSONTranslater
implements Translater {
    private String rootName;

    public static Object converXML2JSON(Object xmlString, XMLToJSONTranslater xmlToJSONTranslater) throws EIPBaseException {
        if (xmlString.toString().trim().startsWith("<")) {
            try {
                xmlString = xmlToJSONTranslater.doTranslate(null, xmlString);
                ResourceHolder.putXMLRootName(xmlToJSONTranslater.getRootName());
            }
            catch (Exception e) {
                ReturnDataService.formatError(1230, e.getMessage());
            }
        }
        return xmlString;
    }

    @Override
    public Object doTranslate(WSStructuredDataModel model, Object xmlObject) throws Exception {
        if (xmlObject == null || xmlObject.equals("")) {
            return xmlObject;
        }
        try {
            SAXReader saxReader = new SAXReader();
            Document document = saxReader.read((Reader)new StringReader(xmlObject.toString()));
            Element root = document.getRootElement();
            this.rootName = root.getName();
            Object obj = XMLToJSONTranslater.parse(root);
            return JSON.toJSONString((Object)obj);
        }
        catch (Exception e) {
            throw new Exception("xml\u8f6c\u6362\u5f02\u5e38\uff01", e);
        }
    }

    public static Object parse(Element root) {
        Element elem;
        Cloneable data;
        List elements = root.elements();
        if (elements.size() == 0) {
            return root.getTextTrim();
        }
        String prev = null;
        boolean guess = true;
        if (elements.size() == 1) {
            guess = false;
        }
        for (Element elem2 : elements) {
            String name = elem2.getName();
            if (prev == null) {
                prev = name;
                continue;
            }
            guess = name.equals(prev);
            break;
        }
        Iterator iterator = elements.iterator();
        if (guess) {
            data = new ArrayList();
            while (iterator.hasNext()) {
                elem = (Element)iterator.next();
                data.add(XMLToJSONTranslater.parse(elem));
            }
            return data;
        }
        data = new HashMap();
        while (iterator.hasNext()) {
            elem = (Element)iterator.next();
            data.put(elem.getName(), XMLToJSONTranslater.parse(elem));
        }
        return data;
    }

    public String getRootName() {
        return this.rootName;
    }
}

