/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.GeniusBOSFactory;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.metadata.configure.Project;
import com.kingdee.bos.metadata.configure.ProjectProvider;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.ep.CustomizedSchemeCollection;
import com.kingdee.eas.ep.CustomizedSchemeFactory;
import com.kingdee.eas.ep.CustomizedSchemeInfo;
import com.kingdee.eas.ep.ICustomizedScheme;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class EPProjectProvider
implements ProjectProvider {
    private static final Logger logger = Logger.getLogger((String)EPProjectProvider.class.getName());

    public Project[] getProjects(String ais) {
        try {
            ICustomizedScheme ics = null;
            String rpcURL = this.getRpcURL();
            if (rpcURL != null) {
                ics = (ICustomizedScheme)GeniusBOSFactory.createRemoteBOSObject((BOSObjectType)BOSObjectType.create((String)"2C98D651"), ICustomizedScheme.class);
                return this.getProjects(ics);
            }
            if (ConfigMDUtil.isClient()) {
                ics = CustomizedSchemeFactory.getRemoteInstance();
                return this.getProjects(ics);
            }
            String sql = "SELECT \"T0\".\"FID\" \"ID\" FROM \"T_EP_CUSTOMIZEDSCHEME\" \"t0\" where \"T0\".\"FSTART\" = 1";
            IRowSet rs = DbUtil.executeQuery((Context)ConfigMDUtil.getContext(), (String)sql);
            ArrayList<Project> ps = new ArrayList<Project>();
            while (rs.next()) {
                ps.add(new Project(rs.getString("ID")));
            }
            Project[] p = new Project[ps.size()];
            p = ps.toArray(p);
            return p;
        }
        catch (Throwable e) {
            logger.error((Object)"EPProjectProvider Get Customized Scheme Error:", e);
            throw new RuntimeException(e);
        }
    }

    private Project[] getProjects(ICustomizedScheme ics) throws BOSException {
        CustomizedSchemeCollection col = ics.getCustomizedSchemeCollection();
        ArrayList<Project> ps = new ArrayList<Project>();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            CustomizedSchemeInfo csInfo = col.get(i);
            if (!csInfo.isStart()) continue;
            ps.add(new Project(csInfo.getId().toString()));
        }
        Project[] p = new Project[ps.size()];
        p = ps.toArray(p);
        return p;
    }

    private ICustomizedScheme getCustomizedSchemeInstance() throws BOSException {
        ICustomizedScheme ics = null;
        String rpcURL = this.getRpcURL();
        ics = rpcURL != null ? (ICustomizedScheme)GeniusBOSFactory.createRemoteBOSObject((BOSObjectType)BOSObjectType.create((String)"2C98D651"), ICustomizedScheme.class) : (ConfigMDUtil.isClient() ? CustomizedSchemeFactory.getRemoteInstance() : CustomizedSchemeFactory.getLocalInstance(ConfigMDUtil.getContext()));
        return ics;
    }

    private String getRpcURL() {
        String rpcURL;
        Map rpcEnv = GeniusBOSFactory.getCurrentServiceEnv();
        if (rpcEnv != null && !StringUtils.isEmpty((String)(rpcURL = (String)rpcEnv.get("URL"))) && !"[LOCAL]".equals(rpcURL)) {
            return rpcURL;
        }
        return null;
    }

    static {
        ConfigMDUtil.addNotNeedLoadConfigPK((String)"com.kingdee.eas.ep.app.CustomizedScheme");
        ConfigMDUtil.addNotNeedLoadConfigPK((String)"com.kingdee.eas.ep.app.T_EP_CustomizedScheme");
    }
}

