/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.updater;

import com.kingdee.eas.ep.updater.BizExpressionType4Update;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class BizSettingExpression4Update {
    private String key;
    private Object value;
    private BizExpressionType4Update expressionType;
    public static final String UNKOWN = "unkown";
    public static final String ENABLED = "enabled";
    public static final String VISIBLE = "visible";
    public static final String LABEL = "label";
    public static final String INDEX = "index";
    public static final String SUMFIELDS = "sumFields";
    public static final String REQUIRED = "required";
    public static final String DEFAULTVALUE = "defaultValue";
    private static final Logger logger = Logger.getLogger(BizSettingExpression4Update.class);

    public BizSettingExpression4Update(String key, Object value, BizExpressionType4Update expressionType) {
        this.key = key;
        this.value = value;
        this.expressionType = expressionType;
    }

    public static BizSettingExpression4Update create(String source) {
        if (StringUtils.isEmpty((String)source)) {
            return null;
        }
        int index = source.indexOf("=");
        if (index > 0) {
            String key = null;
            Object objValue = null;
            BizExpressionType4Update expressionType = null;
            String keyWithProperty = source.substring(0, index).trim();
            String value = source.substring(index + 1).trim();
            int lastIndexOfDot = keyWithProperty.lastIndexOf(".");
            if (lastIndexOfDot > 0) {
                key = keyWithProperty.substring(0, lastIndexOfDot).trim();
                String propertyName = keyWithProperty.substring(lastIndexOfDot + 1).trim();
                if (ENABLED.equalsIgnoreCase(propertyName)) {
                    objValue = Boolean.valueOf(value);
                    expressionType = BizExpressionType4Update.SETUIENABLED;
                } else if (VISIBLE.equalsIgnoreCase(propertyName)) {
                    objValue = Boolean.valueOf(value);
                    expressionType = BizExpressionType4Update.SETUIVISIBLE;
                } else if (INDEX.equalsIgnoreCase(propertyName)) {
                    ArrayList<String> list = new ArrayList<String>();
                    if (!StringUtils.isEmpty((String)value)) {
                        String[] items = StringUtils.split((String)value, (String)",");
                        int n = items.length;
                        for (int i = 0; i < n; ++i) {
                            list.add(items[i]);
                        }
                    }
                    objValue = list;
                    expressionType = BizExpressionType4Update.SETUIINDEX;
                } else if (SUMFIELDS.equalsIgnoreCase(propertyName)) {
                    ArrayList<String> list = new ArrayList<String>();
                    if (!StringUtils.isEmpty((String)value)) {
                        String[] items = StringUtils.split((String)value, (String)",");
                        int n = items.length;
                        for (int i = 0; i < n; ++i) {
                            list.add(items[i]);
                        }
                    }
                    objValue = list;
                    expressionType = BizExpressionType4Update.SETSUM;
                } else if (LABEL.equalsIgnoreCase(propertyName)) {
                    objValue = value;
                    expressionType = BizExpressionType4Update.SETUILABEL;
                } else if (REQUIRED.equalsIgnoreCase(propertyName)) {
                    objValue = Boolean.valueOf(value);
                    expressionType = BizExpressionType4Update.SETREQUIRED;
                } else if (DEFAULTVALUE.equalsIgnoreCase(propertyName)) {
                    objValue = value;
                    expressionType = BizExpressionType4Update.SETDEFAULTVALUE;
                }
                return new BizSettingExpression4Update(key, objValue, expressionType);
            }
        }
        return null;
    }

    public BizExpressionType4Update getExpressionType() {
        return this.expressionType;
    }

    public String getKey() {
        return this.key;
    }

    public Object getValue() {
        if (this.value == null) {
            return "";
        }
        return this.value;
    }

    public String toString() {
        String objValue;
        String propertyName;
        block4: {
            block9: {
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block3: {
                                    propertyName = UNKOWN;
                                    objValue = "";
                                    if (this.value != null) {
                                        objValue = this.value.toString();
                                    }
                                    if (!BizExpressionType4Update.SETUIENABLED.equals((Object)this.expressionType)) break block3;
                                    propertyName = ENABLED;
                                    break block4;
                                }
                                if (!BizExpressionType4Update.SETUIVISIBLE.equals((Object)this.expressionType)) break block5;
                                propertyName = VISIBLE;
                                break block4;
                            }
                            if (!BizExpressionType4Update.SETUILABEL.equals((Object)this.expressionType)) break block6;
                            propertyName = LABEL;
                            break block4;
                        }
                        if (!BizExpressionType4Update.SETDEFAULTVALUE.equals((Object)this.expressionType)) break block7;
                        propertyName = DEFAULTVALUE;
                        break block4;
                    }
                    if (!BizExpressionType4Update.SETUIINDEX.equals((Object)this.expressionType)) break block8;
                    propertyName = INDEX;
                    objValue = "";
                    List list = (List)this.value;
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        objValue = i == 0 ? list.get(i).toString() : objValue + "," + list.get(i).toString();
                    }
                    break block4;
                }
                if (!BizExpressionType4Update.SETREQUIRED.equals((Object)this.expressionType)) break block9;
                propertyName = REQUIRED;
                break block4;
            }
            if (!BizExpressionType4Update.SETSUM.equals((Object)this.expressionType)) break block4;
            propertyName = SUMFIELDS;
            objValue = "";
            List list = (List)this.value;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                objValue = i == 0 ? list.get(i).toString() : objValue + "," + list.get(i).toString();
            }
        }
        return this.key + "." + propertyName + " = " + objValue;
    }

    public static void main(String[] args) {
        String source = "abc.enabled=true";
        BizSettingExpression4Update exp = BizSettingExpression4Update.create(source);
        logger.info((Object)("source:" + exp.getKey()));
        logger.info((Object)("key:" + exp.getKey()));
        logger.info((Object)("expression type:" + (Object)((Object)exp.getExpressionType())));
        logger.info((Object)("value:" + exp.getValue()));
        logger.error((Object)exp);
    }
}

