/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.webclient.editor.webui.designer;

import com.kingdee.eas.ep.client.editor.editui.designer.AbstractEditPartViewer;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.Request;
import com.kingdee.eas.ep.client.editor.editui.designer.request.ChangeContainerRequest;
import com.kingdee.eas.ep.client.editor.editui.designer.request.ResizeRequest;
import com.kingdee.eas.ep.webclient.editor.webui.designer.AbstractWebEditPartViewer;
import com.kingdee.eas.ep.webclient.editor.webui.designer.ContainerEditPart;
import com.kingdee.eas.ep.webclient.editor.webui.designer.WebContext;
import com.kingdee.eas.ep.webclient.editor.webui.designer.layout.ToolbarLayout;
import com.kingdee.eas.ep.webclient.editor.webui.designer.request.WebToolbarLayoutDirectEditRequest;
import com.kingdee.eas.ep.webclient.editor.webui.designer.util.WebEditorHelper;
import com.kingdee.eas.ep.webclient.model.WebTreeNode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class ToolbarLayoutWebEditPartViewer
extends AbstractWebEditPartViewer {
    public ToolbarLayoutWebEditPartViewer(WebTreeNode node, Dimension size, WebContext context) {
        super(node, size, context, new ToolbarLayout());
    }

    public void mouseReleased(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && this.launchMouseEvent) {
            EditPart source = this.partManager.getSource();
            EditPart target = this.partManager.getTarget();
            if (source != null) {
                if (!this.isResizing) {
                    if (!this.imageList.isEmpty()) {
                        if (this == ((WebContext)this.context).getMouseInViewer()) {
                            if (source != null && target != null) {
                                source.sendRequest((Request)new WebToolbarLayoutDirectEditRequest(source, target, this));
                            }
                        } else {
                            boolean isParent = false;
                            if (source instanceof ContainerEditPart) {
                                isParent = WebEditorHelper.isParent((Component)((WebContext)this.context).getMouseInViewer(), source.getComponent());
                            }
                            if (!isParent) {
                                source.sendRequest((Request)new ChangeContainerRequest(source, (AbstractEditPartViewer)this, ((WebContext)this.context).getMouseInViewer()));
                            }
                        }
                    }
                } else {
                    if (this.border == 8 || this.border == 9) {
                        source.sendRequest((Request)new ResizeRequest(source, (AbstractEditPartViewer)this, this.border, this.y));
                    } else {
                        source.sendRequest((Request)new ResizeRequest(source, (AbstractEditPartViewer)this, this.border, this.x));
                    }
                    this.isResizing = false;
                }
                if (source instanceof ContainerEditPart) {
                    source.getComponent().setVisible(true);
                }
            } else {
                WebEditorHelper.dispatchEvent2ParentViewer((JComponent)((Object)this), e);
            }
            this.releasSelectedParam();
            this.setAllViewerEditPartMoveOut();
            this.repaint();
        }
        this.launchMouseEvent = false;
    }

    public void mouseDragged(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.x = e.getX();
            this.y = e.getY();
            if (this.partManager.getSelection() == null) {
                WebEditorHelper.dispatchEvent2ParentViewer((JComponent)((Object)this), e);
                return;
            }
            if (!this.isResizing) {
                EditPart moveInPart = WebEditorHelper.getEditPartByPoint(this.x, this.y, this.partManager);
                this.setAllEditPartMoveOut();
                if (moveInPart != null) {
                    this.partManager.target(moveInPart);
                    moveInPart.performRequest((Request)this.moveInRequest);
                }
            }
            this.repaint();
        }
    }
}

