/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.webclient.editor.webui.designer;

import com.kingdee.eas.ep.client.editor.editui.designer.EditPart;
import com.kingdee.eas.ep.client.editor.editui.designer.EditPartFactory;
import com.kingdee.eas.ep.webclient.editor.webui.designer.AbstractWebEditPartViewer;
import com.kingdee.eas.ep.webclient.editor.webui.designer.CommonEditPart;
import com.kingdee.eas.ep.webclient.editor.webui.designer.SmartLayoutEditPart;
import com.kingdee.eas.ep.webclient.editor.webui.designer.ToolbarLayoutEditPart;
import com.kingdee.eas.ep.webclient.editor.webui.designer.WebCompositeEditPart;
import com.kingdee.eas.ep.webclient.editor.webui.designer.WebItemInfoAdapter;
import com.kingdee.eas.ep.webclient.editor.webui.designer.WebLayoutEditPart;
import com.kingdee.eas.ep.webclient.editor.webui.designer.WebTabbedPaneEditPart;
import com.kingdee.eas.ep.webclient.model.WebItemInfo;
import com.kingdee.eas.ep.webclient.model.WebTreeNode;
import java.util.HashMap;
import java.util.Map;

public class WebEditPartFactory
implements EditPartFactory {
    private WebTreeNode node;
    private Map childMap = new HashMap();
    private AbstractWebEditPartViewer viewer;

    public WebEditPartFactory(WebTreeNode node, AbstractWebEditPartViewer viewer) {
        this.node = node;
        this.viewer = viewer;
    }

    public EditPart createEditPart(Object model) {
        Object obj;
        this.childMap.clear();
        int n = this.node.getChildCount();
        for (int i = 0; i < n; ++i) {
            WebTreeNode child = (WebTreeNode)((Object)this.node.getChildAt(i));
            this.childMap.put(child.getName(), child);
        }
        WebItemInfo item = (WebItemInfo)((WebItemInfoAdapter)((Object)model)).getItem();
        CommonEditPart part = null;
        if (item.getComponent() != null && (obj = this.childMap.get(item.getComponent().getName())) != null && obj instanceof WebTreeNode) {
            if ("com.kingdee.bos.ctrl.web.TabbedPane".equals(item.getComponent().getClassType())) {
                part = new WebTabbedPaneEditPart((WebTreeNode)((Object)obj), item, this.viewer);
            } else if ("com.kingdee.bos.ctrl.web.RootPane".equals(item.getComponent().getClassType()) || "com.kingdee.bos.ctrl.web.Panel".equals(item.getComponent().getClassType())) {
                part = new WebLayoutEditPart((WebTreeNode)((Object)obj), item, this.viewer);
            } else if ("com.kingdee.bos.ctrl.web.Container".equals(item.getComponent().getClassType()) || "com.kingdee.bos.ctrl.web.Composite".equals(item.getComponent().getClassType())) {
                part = new WebCompositeEditPart((WebTreeNode)((Object)obj), item, this.viewer);
            } else if ("com.kingdee.bos.ctrl.web.Form".equals(item.getComponent().getClassType()) || "com.kingdee.bos.ctrl.web.FreePanel".equals(item.getComponent().getClassType())) {
                part = new SmartLayoutEditPart((WebTreeNode)((Object)obj), item, this.viewer);
            } else if ("com.kingdee.bos.ctrl.web.ToolBar".equals(item.getComponent().getClassType())) {
                part = new ToolbarLayoutEditPart((WebTreeNode)((Object)obj), item, this.viewer);
            }
        }
        if (part == null) {
            part = new CommonEditPart(item, this.viewer);
        }
        part.setModel(model);
        part.activate();
        part.addNotify();
        return part;
    }
}

