/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.webclient.editor.webui.designer.layout;

import com.kingdee.bos.ui.dtp.weblayout.WebLayoutData;
import com.kingdee.eas.ep.client.editor.editui.designer.MaskPanel;
import com.kingdee.eas.ep.webclient.editor.webui.designer.layout.LayoutManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class WebLayout
extends LayoutManager {
    public static final int H_ALIGN_LEFT = 0;
    public static final int H_ALIGN_CENTER = 1;
    public static final int H_ALIGN_RIGHT = 2;
    public static final int V_ALIGN_TOP = 0;
    public static final int V_ALIGN_MIDDLE = 1;
    public static final int V_ALIGN_BOTTOM = 2;
    private int horizontalAlign = 0;
    private int verticalAlign = 1;
    private int vSpacing = 2;
    private int hSpacing = 2;
    private boolean allowVerticalAlign = false;
    protected List orders = new ArrayList();

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        super.addLayoutComponent(comp, constraints);
        if (!(comp instanceof MaskPanel) && !this.orders.contains(comp)) {
            this.orders.add(comp);
        }
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        super.removeLayoutComponent(comp);
        this.orders.remove(comp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Dimension parentSize = new Dimension(parent.getSize());
            int startX = 0;
            int startY = 0;
            int maxWidth = parentSize.width;
            int maxHeight = 0;
            LinkedList<Object[]> list = new LinkedList<Object[]>();
            LinkedList<Object[]> lines = new LinkedList<Object[]>();
            boolean preNewLine = false;
            int size = this.orders.size();
            for (int i = 0; i < size; ++i) {
                Component comp = (Component)this.orders.get(i);
                Object constraint = this.getConstraint(comp);
                if (!(constraint instanceof WebLayoutData)) continue;
                boolean newLine = false;
                WebLayoutData layoutData = (WebLayoutData)constraint;
                newLine = layoutData.newLine;
                Dimension childSize = layoutData.width.isPercentage ? new Dimension((int)((float)parentSize.width * layoutData.width.number), layoutData.height) : new Dimension((int)layoutData.width.number, layoutData.height);
                if (newLine || preNewLine || startX + childSize.width > parentSize.height) {
                    int rowWidth = startX - this.hSpacing;
                    lines.addLast(new Object[]{new Integer(rowWidth), new Integer(maxHeight), list});
                    startX = 0;
                    startY += maxHeight + this.vSpacing;
                    maxHeight = 0;
                    list = new LinkedList();
                }
                maxHeight = Math.max(maxHeight, childSize.height);
                Rectangle rect = new Rectangle(startX, startY, childSize.width, childSize.height);
                list.addLast(new Object[]{comp, rect});
                startX += childSize.width + this.hSpacing;
                preNewLine = newLine;
            }
            if (!list.isEmpty()) {
                int rowWidth = startX - this.hSpacing;
                lines.addLast(new Object[]{new Integer(rowWidth), new Integer(maxHeight), list});
                startY += maxHeight + this.vSpacing;
            }
            int totalHeight = startY - this.vSpacing;
            int y = 0;
            if (this.allowVerticalAlign) {
                if (this.verticalAlign == 1) {
                    y = (parentSize.height - totalHeight) / 2;
                } else if (this.verticalAlign == 2) {
                    y = parentSize.height - totalHeight;
                }
            }
            for (Object[] objects : lines) {
                int rowWidth = (Integer)objects[0];
                int rowHeight = (Integer)objects[1];
                LinkedList row = (LinkedList)objects[2];
                int x = 0;
                if (this.horizontalAlign == 2) {
                    x = parentSize.width - rowWidth;
                } else if (this.horizontalAlign == 1) {
                    x = (parentSize.width - rowWidth) / 2;
                }
                for (Object[] objs : row) {
                    Component f = (Component)objs[0];
                    Rectangle bounds = (Rectangle)objs[1];
                    bounds.y = y + rowHeight - bounds.height;
                    bounds.x = x;
                    x += bounds.width + this.hSpacing;
                    f.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
                }
                y += rowHeight + this.vSpacing;
            }
        }
    }
}

