/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ep.webclient.editor.webui.designer.util;

import com.kingdee.bos.metadata.bizunit.proxy.ConvertUtils;
import com.kingdee.bos.metadata.ui.AbstractUIObjectInfo;
import com.kingdee.bos.metadata.ui.ActionInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.LayoutInfo;
import com.kingdee.bos.metadata.ui.PropertyCollection;
import com.kingdee.bos.metadata.ui.PropertyInfo;
import com.kingdee.bos.metadata.webui.WebUIObjectInfo;
import com.kingdee.bos.ui.dtp.ActionServicePropertyHelper;
import com.kingdee.bos.ui.dtp.ServiceItem;
import com.kingdee.bos.ui.dtp.StringConverter;
import com.kingdee.bos.ui.dtp.WebControlConstant;
import com.kingdee.bos.ui.dtp.model.layout.LabelContainerLayout;
import com.kingdee.bos.ui.dtp.model.layout.Layout;
import com.kingdee.bos.ui.dtp.model.layout.LayoutConverter;
import com.kingdee.bos.ui.dtp.model.layout.SmartLayout;
import com.kingdee.bos.ui.dtp.model.layout.TabbedPaneLayout;
import com.kingdee.bos.ui.dtp.model.layout.WebAccordionPaneLayout;
import com.kingdee.bos.ui.dtp.model.layout.WebLayout;
import com.kingdee.bos.ui.dtp.model.layout.WebSplitLayout;
import com.kingdee.bos.ui.dtp.model.layout.WebToolBarLayout;
import com.kingdee.bos.ui.dtp.weblayout.WebLayoutData;
import com.kingdee.eas.ep.client.depend.mutiLan.MutiLanUtil;
import com.kingdee.eas.ep.client.editor.action.ConfigManager;
import com.kingdee.eas.ep.client.model.dtc.ControlStaticInfo;
import com.kingdee.eas.ep.client.model.dtc.DTControlHelper;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;

public class WebComponentHelper {
    private static double MaxFloat = 3.4028234663852886E38;
    private static double MinFloat = -3.4028234663852886E38;

    public static ComponentInfo createCheckBox(WebUIObjectInfo uiModel, String name, String labelText) {
        ComponentInfo checkBox = new ComponentInfo("com.kingdee.bos.ctrl.web.CheckBox");
        checkBox.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        String useName = uiModel.getNameManager().getNameByName(WebComponentHelper.getPrefix("com.kingdee.bos.ctrl.web.CheckBox") + name);
        checkBox.setName(useName);
        PropertyCollection props = checkBox.getProperties();
        props.add(WebComponentHelper.createLabelTextProperty(labelText));
        return checkBox;
    }

    public static ComponentInfo createCheckBoxColumn(WebUIObjectInfo uiModel, String name, String labelText) {
        ComponentInfo column = WebComponentHelper.createEditableColumn(name, labelText, uiModel);
        if (column == null) {
            return null;
        }
        ComponentInfo checkBox = new ComponentInfo("com.kingdee.bos.ctrl.web.CheckBox");
        checkBox.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        String useName = uiModel.getNameManager().getNameByName(WebComponentHelper.getPrefix("com.kingdee.bos.ctrl.web.CheckBox") + name);
        checkBox.setName(useName);
        PropertyCollection props = checkBox.getProperties();
        props.add(WebComponentHelper.createLabelTextProperty(labelText));
        checkBox.setConstraint((Object)new WebLayoutData(WebLayoutData.Unit.absolute((int)100), 19, false), false);
        column.addChild((AbstractUIObjectInfo)uiModel, checkBox);
        return column;
    }

    public static ComponentInfo createTextField(WebUIObjectInfo uiModel, String name, String labelText, boolean isMultiLanguage) {
        ComponentInfo labelContainer = WebComponentHelper.createLabelContainer(name, labelText, uiModel);
        if (labelContainer == null) {
            return null;
        }
        WebComponentHelper.createTextFieldForLabelContainer(uiModel, labelContainer, name, null, isMultiLanguage);
        return labelContainer;
    }

    public static ComponentInfo createTextFieldColumn(WebUIObjectInfo uiModel, String name, String labelText, Integer maxLength, boolean isMultiLanguage) {
        ComponentInfo column = WebComponentHelper.createEditableColumn(name, labelText, uiModel);
        if (column == null) {
            return null;
        }
        ComponentInfo child = WebComponentHelper.createTextFieldForLabelContainer(uiModel, column, name, maxLength, isMultiLanguage);
        child.setConstraint((Object)new WebLayoutData(WebLayoutData.Unit.absolute((int)100), 19, false), false);
        return column;
    }

    public static ComponentInfo createTextArea(WebUIObjectInfo uiModel, String name, String labelText) {
        ComponentInfo labelContainer = WebComponentHelper.createLabelContainer(name, labelText, uiModel);
        if (labelContainer == null) {
            return null;
        }
        WebComponentHelper.createTextAreaForLabelContainer(uiModel, labelContainer, name);
        return labelContainer;
    }

    public static ComponentInfo createFormattedTextField(WebUIObjectInfo uiModel, String name, String labelText) {
        ComponentInfo labelContainer = WebComponentHelper.createLabelContainer(name, labelText, uiModel);
        if (labelContainer == null) {
            return null;
        }
        WebComponentHelper.createFormattedTextFieldForLabelContainer(uiModel, labelContainer, name, null);
        return labelContainer;
    }

    public static ComponentInfo createFormattedTextFieldColumn(WebUIObjectInfo uiModel, String name, String labelText, Integer maxLength) {
        ComponentInfo column = WebComponentHelper.createEditableColumn(name, labelText, uiModel);
        if (column == null) {
            return null;
        }
        ComponentInfo child = WebComponentHelper.createFormattedTextFieldForLabelContainer(uiModel, column, name, maxLength);
        child.setConstraint((Object)new WebLayoutData(WebLayoutData.Unit.absolute((int)100), 19, false), false);
        return column;
    }

    public static ComponentInfo createDatePicker(WebUIObjectInfo uiModel, String name, String labelText) {
        ComponentInfo labelContainer = WebComponentHelper.createLabelContainer(name, labelText, uiModel);
        if (labelContainer == null) {
            return null;
        }
        WebComponentHelper.createDatePickerForLabelContainer(uiModel, labelContainer, name);
        return labelContainer;
    }

    public static ComponentInfo createDatePickerColumn(WebUIObjectInfo uiModel, String name, String labelText) {
        ComponentInfo column = WebComponentHelper.createEditableColumn(name, labelText, uiModel);
        if (column == null) {
            return null;
        }
        ComponentInfo child = WebComponentHelper.createDatePickerForLabelContainer(uiModel, column, name);
        child.setConstraint((Object)new WebLayoutData(WebLayoutData.Unit.absolute((int)100), 19, false), false);
        return column;
    }

    public static ComponentInfo createTimePicker(WebUIObjectInfo uiModel, String name, String labelText) {
        ComponentInfo labelContainer = WebComponentHelper.createLabelContainer(name, labelText, uiModel);
        if (labelContainer == null) {
            return null;
        }
        ComponentInfo child = WebComponentHelper.createTimePickerForLabelContainer(uiModel, labelContainer, name);
        child.setConstraint((Object)new WebLayoutData(WebLayoutData.Unit.absolute((int)100), 19, false), false);
        return labelContainer;
    }

    public static ComponentInfo createTimePickerColumn(WebUIObjectInfo uiModel, String name, String labelText) {
        ComponentInfo column = WebComponentHelper.createEditableColumn(name, labelText, uiModel);
        if (column == null) {
            return null;
        }
        ComponentInfo child = WebComponentHelper.createTimePickerForLabelContainer(uiModel, column, name);
        child.setConstraint((Object)new WebLayoutData(WebLayoutData.Unit.absolute((int)100), 19, false), false);
        return column;
    }

    public static ComponentInfo createComboBox(WebUIObjectInfo uiModel, String name, String labelText) {
        ComponentInfo labelContainer = WebComponentHelper.createLabelContainer(name, labelText, uiModel);
        if (labelContainer == null) {
            return null;
        }
        WebComponentHelper.createComboBoxForLabelContainer(uiModel, labelContainer, name);
        return labelContainer;
    }

    public static ComponentInfo createComboBoxColumn(WebUIObjectInfo uiModel, String name, String labelText) {
        ComponentInfo column = WebComponentHelper.createEditableColumn(name, labelText, uiModel);
        if (column == null) {
            return null;
        }
        ComponentInfo child = WebComponentHelper.createComboBoxForLabelContainer(uiModel, column, name);
        child.setConstraint((Object)new WebLayoutData(WebLayoutData.Unit.absolute((int)100), 19, false), false);
        return column;
    }

    public static ComponentInfo createBizPromptBox(WebUIObjectInfo uiModel, String name, String labelText) {
        ComponentInfo labelContainer = WebComponentHelper.createLabelContainer(name, labelText, uiModel);
        if (labelContainer == null) {
            return null;
        }
        WebComponentHelper.createBizPromptBoxForLabelContainer(uiModel, labelContainer, name);
        return labelContainer;
    }

    public static ComponentInfo createBizPromptBoxColumn(WebUIObjectInfo uiModel, String name, String labelText) {
        ComponentInfo column = WebComponentHelper.createEditableColumn(name, labelText, uiModel);
        if (column == null) {
            return null;
        }
        ComponentInfo child = WebComponentHelper.createBizPromptBoxForLabelContainer(uiModel, column, name);
        child.setConstraint((Object)new WebLayoutData(WebLayoutData.Unit.absolute((int)100), 19, false), false);
        return column;
    }

    public static ComponentInfo createLabelContainer(String name, String labelText, WebUIObjectInfo uiModel) {
        ComponentInfo labelContainer = new ComponentInfo("com.kingdee.bos.ctrl.web.LabelContainer");
        String useName = uiModel.getNameManager().getNameByName(WebComponentHelper.getPrefix("com.kingdee.bos.ctrl.web.LabelContainer") + name);
        labelContainer.setName(useName);
        labelContainer.setContainer(true);
        labelContainer.setLayoutInfo(LayoutConverter.convertToInfo((Layout)new LabelContainerLayout()));
        PropertyCollection props = labelContainer.getProperties();
        props.add(WebComponentHelper.createBoundLabelTextProperty(labelText));
        props.add(WebComponentHelper.createBoundLabelLengthProperty());
        return labelContainer;
    }

    public static ComponentInfo createColumn(String name, String labelText, WebUIObjectInfo uiModel) {
        ComponentInfo column = new ComponentInfo("com.kingdee.bos.ctrl.web.Column");
        column.setContainer(false);
        column.setName(uiModel.getNameManager().getNameByName(name + "Column"));
        column.setConstraint((Object)"width=170;height=19;newLine=false");
        PropertyInfo pheader = new PropertyInfo();
        pheader.setName("header");
        pheader.setType("java.lang.String");
        pheader.setValue(labelText);
        pheader.setMultiLanguage(true);
        PropertyInfo pwidth = new PropertyInfo();
        pwidth.setName("width");
        pwidth.setType("int");
        pwidth.setValue("100");
        PropertyCollection pcs = column.getProperties();
        pcs.add(pheader);
        pcs.add(pwidth);
        return column;
    }

    public static ComponentInfo createEditableColumn(String name, String labelText, WebUIObjectInfo uiModel) {
        ComponentInfo column = new ComponentInfo("com.kingdee.bos.ctrl.web.EditableColumn");
        column.setContainer(true);
        column.setName(uiModel.getNameManager().getNameByName(name + "Column"));
        column.setConstraint((Object)"width=170;height=19;newLine=false");
        LayoutInfo layout = new LayoutInfo();
        layout.setType("WebLayout");
        layout.setName(uiModel.getNameManager().getNameByName(name + "WebLayout"));
        layout.setValue("0,1,false");
        column.setLayoutInfo(layout);
        PropertyInfo pheader = new PropertyInfo();
        pheader.setName("header");
        pheader.setType("java.lang.String");
        pheader.setValue(labelText);
        pheader.setMultiLanguage(true);
        PropertyInfo pwidth = new PropertyInfo();
        pwidth.setName("width");
        pwidth.setType("int");
        pwidth.setValue("100");
        PropertyCollection pcs = column.getProperties();
        pcs.add(pheader);
        pcs.add(pwidth);
        return column;
    }

    public static ComponentInfo createComponent(WebUIObjectInfo uiModel, String classType, String name, String text) {
        ComponentInfo component = new ComponentInfo(classType);
        String useName = uiModel.getNameManager().getNameByName(name);
        component.setName(useName);
        String propertyName = WebComponentHelper.getLabelPropertyName(component);
        if (!StringUtils.isEmpty((String)propertyName)) {
            WebComponentHelper.setPropertyValue(component, propertyName, text);
        }
        boolean isContainer = DTControlHelper.isContainer((String)classType);
        component.setContainer(isContainer);
        if ("com.kingdee.bos.ctrl.web.EditDataGrid".equals(classType)) {
            component.setExtendedProperty("createbutton4editdatagrid", "true");
        }
        if (isContainer) {
            WebSplitLayout layout = null;
            if ("com.kingdee.bos.ctrl.web.Splitcontainer".equals(classType)) {
                layout = new WebSplitLayout();
                layout.setName(uiModel.getNameManager().getNameByName(layout.getClass().getName()));
                WebComponentHelper.setLayout(component, (Layout)layout);
            } else if ("com.kingdee.bos.ctrl.web.TabbedPane".equals(classType)) {
                layout = new TabbedPaneLayout();
                layout.setName(uiModel.getNameManager().getNameByName(layout.getClass().getName()));
            } else if ("com.kingdee.bos.ctrl.web.AccordionPane".equals(classType)) {
                layout = new WebAccordionPaneLayout();
                layout.setName(uiModel.getNameManager().getNameByName(layout.getClass().getName()));
            } else if ("com.kingdee.bos.ctrl.web.ToolBar".equals(classType)) {
                layout = new WebToolBarLayout();
                layout.setName(uiModel.getNameManager().getNameByName(layout.getClass().getName()));
            } else if ("com.kingdee.bos.ctrl.web.FreePanel".equals(classType) || "com.kingdee.bos.ctrl.web.Form".equals(classType) || "com.kingdee.bos.ctrl.web.Composite".equals(classType) || "com.kingdee.bos.ctrl.web.Container".equals(classType)) {
                layout = new SmartLayout();
                layout.setName(uiModel.getNameManager().getNameByName(layout.getClass().getName()));
            } else if ("com.kingdee.bos.ctrl.web.Panel".equals(classType)) {
                layout = new WebLayout();
                layout.setName(uiModel.getNameManager().getNameByName(layout.getClass().getName()));
            }
            if (layout != null) {
                WebComponentHelper.setLayout(component, (Layout)layout);
            }
        }
        return component;
    }

    public static void setLayout(ComponentInfo cInfo, Layout layout) {
        if (cInfo != null && layout != null) {
            cInfo.setLayoutInfo(LayoutConverter.convertToInfo((Layout)layout));
            if (cInfo.isHerited()) {
                cInfo.getLayoutInfo().setOverride(true);
            }
        }
    }

    public static ActionInfo createAction(WebUIObjectInfo uiModel, String className, String name) {
        ActionInfo action = new ActionInfo();
        action.setName(name, false);
        action.setClassName(className, false);
        action.setServices(WebComponentHelper.getDefaultService());
        action.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        return action;
    }

    private static String getDefaultService() {
        ServiceItem[] items = ConfigManager.getInstance().getServiceItems();
        ArrayList<ServiceItem> list = new ArrayList<ServiceItem>();
        int j = items.length;
        for (int i = 0; i < j; ++i) {
            if (!items[i].isCompulsory()) continue;
            list.add(items[i]);
        }
        return ActionServicePropertyHelper.toXmlString(list);
    }

    public static ComponentInfo createTextFieldForLabelContainer(WebUIObjectInfo uiModel, ComponentInfo container, String name, Integer maxLength, boolean isMultiLanguage) {
        ComponentInfo text = null;
        String useName = null;
        if (isMultiLanguage) {
            text = new ComponentInfo("com.kingdee.bos.ctrl.web.Multilanguage");
            useName = uiModel.getNameManager().getNameByName(WebComponentHelper.getPrefix("com.kingdee.bos.ctrl.web.Multilanguage") + name);
        } else {
            text = new ComponentInfo("com.kingdee.bos.ctrl.web.TextField");
            if (maxLength != null) {
                WebComponentHelper.setPropertyValue(text, "maxLength", maxLength);
            }
            useName = uiModel.getNameManager().getNameByName(WebComponentHelper.getPrefix("com.kingdee.bos.ctrl.web.TextField") + name);
        }
        text.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        text.setName(useName);
        text.setConstraint((Object)String.valueOf(3));
        container.addChild((AbstractUIObjectInfo)uiModel, text);
        return text;
    }

    public static ComponentInfo createTextAreaForLabelContainer(WebUIObjectInfo uiModel, ComponentInfo container, String name) {
        ComponentInfo text = new ComponentInfo("com.kingdee.bos.ctrl.web.TextArea");
        String useName = uiModel.getNameManager().getNameByName(WebComponentHelper.getPrefix("com.kingdee.bos.ctrl.web.TextArea") + name);
        text.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        text.setName(useName);
        text.setConstraint((Object)"0,0,1,1");
        container.addChild((AbstractUIObjectInfo)uiModel, text);
        return text;
    }

    public static ComponentInfo createFormattedTextFieldForLabelContainer(WebUIObjectInfo uiModel, ComponentInfo container, String name, Integer maxLength) {
        ComponentInfo text = new ComponentInfo("com.kingdee.bos.ctrl.web.NumberField");
        text.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        String useName = uiModel.getNameManager().getNameByName(WebComponentHelper.getPrefix("com.kingdee.bos.ctrl.web.NumberField") + name);
        if (maxLength != null) {
            WebComponentHelper.setPropertyValue(text, "maxLength", maxLength);
        }
        text.setName(useName);
        text.setConstraint((Object)String.valueOf(7));
        container.addChild((AbstractUIObjectInfo)uiModel, text);
        return text;
    }

    public static ComponentInfo createDatePickerForLabelContainer(WebUIObjectInfo uiModel, ComponentInfo container, String name) {
        ComponentInfo picker = new ComponentInfo("com.kingdee.bos.ctrl.web.DateField");
        picker.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        String useName = uiModel.getNameManager().getNameByName(WebComponentHelper.getPrefix("com.kingdee.bos.ctrl.web.DateField") + name);
        picker.setName(useName);
        picker.setConstraint((Object)String.valueOf(7));
        container.addChild((AbstractUIObjectInfo)uiModel, picker);
        return picker;
    }

    public static ComponentInfo createTimePickerForLabelContainer(WebUIObjectInfo uiModel, ComponentInfo container, String name) {
        ComponentInfo picker = new ComponentInfo("com.kingdee.bos.ctrl.web.DateTimeField");
        picker.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        String useName = uiModel.getNameManager().getNameByName(WebComponentHelper.getPrefix("com.kingdee.bos.ctrl.web.DateTimeField") + name);
        picker.setName(useName);
        picker.setConstraint((Object)String.valueOf(7));
        container.addChild((AbstractUIObjectInfo)uiModel, picker);
        return picker;
    }

    public static ComponentInfo createComboBoxForLabelContainer(WebUIObjectInfo uiModel, ComponentInfo container, String name) {
        ComponentInfo combo = new ComponentInfo("com.kingdee.bos.ctrl.web.EnumCombo");
        combo.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        String useName = uiModel.getNameManager().getNameByName(WebComponentHelper.getPrefix("com.kingdee.bos.ctrl.web.EnumCombo") + name);
        combo.setName(useName);
        combo.setConstraint((Object)String.valueOf(7));
        container.addChild((AbstractUIObjectInfo)uiModel, combo);
        return combo;
    }

    public static ComponentInfo createBizPromptBoxForLabelContainer(WebUIObjectInfo uiModel, ComponentInfo container, String name) {
        ComponentInfo f7 = new ComponentInfo("com.kingdee.bos.ctrl.web.PromptBox");
        f7.setUserDefined(ConvertUtils.getUserDefinedBooleanVaule());
        String useName = uiModel.getNameManager().getNameByName(WebComponentHelper.getPrefix("com.kingdee.bos.ctrl.web.PromptBox") + name);
        f7.setName(useName);
        f7.setConstraint((Object)String.valueOf(7));
        container.addChild((AbstractUIObjectInfo)uiModel, f7);
        PropertyCollection props = f7.getProperties();
        props.add(WebComponentHelper.createEditableProperty(true));
        props.add(WebComponentHelper.createDisplayFormatProperty());
        props.add(WebComponentHelper.createEditFormatProperty());
        props.add(WebComponentHelper.createCommitFormatProperty());
        return f7;
    }

    public static PropertyInfo createLabelTextProperty(String text) {
        if (StringUtils.isEmpty((String)text)) {
            return null;
        }
        PropertyInfo prop = new PropertyInfo();
        prop.setName("text");
        prop.setType(String.class.getName());
        prop.setMultiLanguage(true);
        prop.setValue(text);
        prop.setOverride(true);
        return prop;
    }

    public static PropertyInfo createBoundLabelTextProperty(String text) {
        if (StringUtils.isEmpty((String)text)) {
            return null;
        }
        PropertyInfo prop = new PropertyInfo();
        prop.setName("caption");
        prop.setType(String.class.getName());
        prop.setMultiLanguage(true);
        prop.setValue(text);
        prop.setOverride(true);
        return prop;
    }

    public static PropertyInfo createBoundLabelLengthProperty() {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("lineWidth");
        prop.setType("int");
        prop.setValue(String.valueOf(100));
        prop.setOverride(true);
        return prop;
    }

    public static PropertyInfo createRequiredProperty(boolean isRequired) {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("required");
        prop.setType("boolean");
        prop.setValue(String.valueOf(isRequired));
        prop.setOverride(true);
        return prop;
    }

    public static PropertyInfo createEditableProperty(boolean editable) {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("disabled");
        prop.setType("boolean");
        prop.setValue(String.valueOf(!editable));
        prop.setOverride(true);
        return prop;
    }

    public static PropertyInfo createDisplayFormatProperty() {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("diaplayFormat");
        prop.setType(String.class.getName());
        prop.setValue("$name$");
        prop.setOverride(true);
        return prop;
    }

    public static PropertyInfo createEditFormatProperty() {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("editFormat");
        prop.setType(String.class.getName());
        prop.setValue("$number$");
        prop.setOverride(true);
        return prop;
    }

    public static PropertyInfo createCommitFormatProperty() {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("commitFormat");
        prop.setType(String.class.getName());
        prop.setValue("$number$");
        prop.setOverride(true);
        return prop;
    }

    public static String getPrefix(String classType) {
        if (StringUtils.isEmpty((String)classType)) {
            return "";
        }
        String value = WebControlConstant.getControlNamePrefix((String)classType);
        if (value == null) {
            return "";
        }
        return value;
    }

    public static void setPropertyValue(ComponentInfo cInfo, String propName, Object value) {
        PropertyInfo prop = cInfo.getPropertyByName(propName);
        ControlStaticInfo.PropertyStaticInfo sinfo = DTControlHelper.getControlStaticInfo((String)cInfo.getClassType()).getPropStaticInfo(propName);
        if (sinfo != null && !sinfo.isEmpty()) {
            if (prop == null) {
                prop = new PropertyInfo();
                prop.setName(propName);
                prop.setType(sinfo.getType());
                prop.setMultiLanguage(sinfo.isMultiLan());
                cInfo.getProperties().add(prop);
            }
        } else {
            return;
        }
        String stringValue = null;
        stringValue = WebComponentHelper.object2String(prop.getType(), value);
        if (prop.isMultiLanguage()) {
            MutiLanUtil.setAllMutiLanValue((Object)prop, (String)stringValue);
        } else {
            prop.setValue(stringValue);
        }
        if (cInfo.isHerited()) {
            prop.setOverride(true);
        }
    }

    public static Object getPropertyValue(ComponentInfo cInfo, String propName) {
        PropertyInfo pInfo = cInfo.getProperties().get(propName);
        String stringValue = null;
        String type = null;
        if (pInfo != null) {
            stringValue = pInfo.getValue();
            type = pInfo.getType();
        }
        if (stringValue == null) {
            ControlStaticInfo.PropertyStaticInfo propStaticInfo = DTControlHelper.getControlStaticInfo((String)cInfo.getClassType()).getPropStaticInfo(propName);
            stringValue = propStaticInfo.getDefaultValue();
            type = propStaticInfo.getType();
        }
        return WebComponentHelper.string2Object(type, stringValue);
    }

    public static String object2String(String type, Object obj) {
        String wrapperType = null;
        wrapperType = "int".equals(type) ? "java.lang.Integer" : ("boolean".equals(type) ? "java.lang.Boolean" : ("long".equals(type) ? "java.lang.Long" : ("short".equals(type) ? "java.lang.Short" : ("byte".equals(type) ? "java.lang.Byte" : ("float".equals(type) ? "java.lang.Float" : ("double".equals(type) ? "java.lang.Double" : ("char".equals(type) ? "java.lang.Character" : type)))))));
        return StringConverter.convertToString((String)wrapperType, (Object)obj);
    }

    public static Object string2Object(String type, String strValue) {
        String wrapperType = null;
        wrapperType = "int".equals(type) ? "java.lang.Integer" : ("boolean".equals(type) ? "java.lang.Boolean" : ("long".equals(type) ? "java.lang.Long" : ("short".equals(type) ? "java.lang.Short" : ("byte".equals(type) ? "java.lang.Byte" : ("float".equals(type) ? "java.lang.Float" : ("double".equals(type) ? "java.lang.Double" : ("char".equals(type) ? "java.lang.Character" : type)))))));
        return StringConverter.convertToObject((String)wrapperType, (String)strValue);
    }

    public static PropertyInfo createMinimumValueProperty(int length, int scale) {
        if (length <= scale) {
            return null;
        }
        String format = WebComponentHelper.getMininumValue(length, scale);
        format = "\"" + format + "\"";
        PropertyInfo prop = new PropertyInfo();
        prop.setName("minimumValue");
        prop.setType(BigDecimal.class.getName());
        prop.setValue(format);
        prop.setOverride(true);
        return prop;
    }

    public static PropertyInfo createMaximumValueProperty(int length, int scale) {
        if (length <= scale) {
            return null;
        }
        String format = WebComponentHelper.getMaximumValue(length, scale);
        format = "\"" + format + "\"";
        PropertyInfo prop = new PropertyInfo();
        prop.setName("maximumValue");
        prop.setType(BigDecimal.class.getName());
        prop.setValue(format);
        prop.setOverride(true);
        return prop;
    }

    public static String getMininumValue(int length, int scale) {
        int i;
        if (length <= scale) {
            return null;
        }
        int realLength = length - scale;
        String format = "-";
        double minValue = MinFloat;
        for (i = 0; i < realLength; ++i) {
            format = format + "9";
        }
        if (scale > 0) {
            format = format + ".";
            for (i = 0; i < scale; ++i) {
                format = format + "9";
            }
        }
        try {
            if (Double.parseDouble(format) > minValue) {
                minValue = Double.parseDouble(format);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return String.valueOf(minValue);
    }

    public static String getMaximumValue(int length, int scale) {
        int i;
        if (length <= scale) {
            return null;
        }
        int realLength = length - scale;
        String format = "";
        double maxValue = MaxFloat;
        for (i = 0; i < realLength; ++i) {
            format = format + "9";
        }
        if (scale > 0) {
            format = format + ".";
            for (i = 0; i < scale; ++i) {
                format = format + "9";
            }
        }
        try {
            if (Double.parseDouble(format) < maxValue) {
                maxValue = Double.parseDouble(format);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return String.valueOf(maxValue);
    }

    public static PropertyInfo createPrecisionProperty(int precision) {
        PropertyInfo prop = new PropertyInfo();
        prop.setName("precision");
        prop.setType("int");
        prop.setValue(String.valueOf(precision));
        prop.setOverride(true);
        return prop;
    }

    public static String getLabelPropertyName(ComponentInfo component) {
        if (component == null) {
            return "";
        }
        if ("com.kingdee.bos.ctrl.web.Label".equals(component.getClassType())) {
            return "value";
        }
        if ("com.kingdee.bos.ctrl.web.Button".equals(component.getClassType())) {
            return "label";
        }
        if ("com.kingdee.bos.ctrl.web.RadioButton".equals(component.getClassType())) {
            return "value";
        }
        if ("com.kingdee.bos.ctrl.web.CheckBox".equals(component.getClassType())) {
            return "boxLabel";
        }
        if ("com.kingdee.bos.ctrl.web.LabelContainer".equals(component.getClassType())) {
            return "caption";
        }
        if ("com.kingdee.bos.ctrl.web.Container".equals(component.getClassType())) {
            return "caption";
        }
        if ("com.kingdee.bos.ctrl.web.Composite".equals(component.getClassType())) {
            return "title";
        }
        if ("com.kingdee.bos.ctrl.web.Column".equals(component.getClassType()) || "com.kingdee.bos.ctrl.web.EditableColumn".equals(component.getClassType())) {
            return "header";
        }
        return "";
    }
}

