/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.analysis;

import java.io.IOException;
import org.apache.lucene.ep.analysis.TokenFilter;
import org.apache.lucene.ep.analysis.TokenStream;
import org.apache.lucene.ep.analysis.tokenattributes.TermAttribute;

public final class LengthFilter
extends TokenFilter {
    final int min;
    final int max;
    private TermAttribute termAtt;

    public LengthFilter(TokenStream in, int min, int max) {
        super(in);
        this.min = min;
        this.max = max;
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
    }

    @Override
    public final boolean incrementToken() throws IOException {
        while (this.input.incrementToken()) {
            int len = this.termAtt.termLength();
            if (len < this.min || len > this.max) continue;
            return true;
        }
        return false;
    }
}

