/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.ep.analysis.Analyzer;
import org.apache.lucene.ep.analysis.TokenStream;
import org.apache.lucene.ep.analysis.Tokenizer;
import org.apache.lucene.ep.analysis.WhitespaceTokenizer;

public final class WhitespaceAnalyzer
extends Analyzer {
    @Override
    public TokenStream tokenStream(String fieldName, Reader reader) {
        return new WhitespaceTokenizer(reader);
    }

    @Override
    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        Tokenizer tokenizer = (Tokenizer)this.getPreviousTokenStream();
        if (tokenizer == null) {
            tokenizer = new WhitespaceTokenizer(reader);
            this.setPreviousTokenStream(tokenizer);
        } else {
            tokenizer.reset(reader);
        }
        return tokenizer;
    }
}

