/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.document;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.ep.document.FieldSelector;
import org.apache.lucene.ep.document.FieldSelectorResult;

public class MapFieldSelector
implements FieldSelector {
    Map fieldSelections;

    public MapFieldSelector(Map fieldSelections) {
        this.fieldSelections = fieldSelections;
    }

    public MapFieldSelector(List fields) {
        this.fieldSelections = new HashMap(fields.size() * 5 / 3);
        for (int i = 0; i < fields.size(); ++i) {
            this.fieldSelections.put(fields.get(i), FieldSelectorResult.LOAD);
        }
    }

    public MapFieldSelector(String[] fields) {
        this.fieldSelections = new HashMap(fields.length * 5 / 3);
        for (int i = 0; i < fields.length; ++i) {
            this.fieldSelections.put(fields[i], FieldSelectorResult.LOAD);
        }
    }

    @Override
    public FieldSelectorResult accept(String field) {
        FieldSelectorResult selection = (FieldSelectorResult)this.fieldSelections.get(field);
        return selection != null ? selection : FieldSelectorResult.NO_LOAD;
    }
}

