/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.index;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.lucene.ep.index.IndexCommitPoint;
import org.apache.lucene.ep.store.Directory;

public abstract class IndexCommit
implements IndexCommitPoint {
    @Override
    public abstract String getSegmentsFileName();

    @Override
    public abstract Collection getFileNames() throws IOException;

    public abstract Directory getDirectory();

    @Override
    public abstract void delete();

    public abstract boolean isDeleted();

    public abstract boolean isOptimized();

    public boolean equals(Object other) {
        if (other instanceof IndexCommit) {
            IndexCommit otherCommit = (IndexCommit)other;
            return otherCommit.getDirectory().equals(this.getDirectory()) && otherCommit.getVersion() == this.getVersion();
        }
        return false;
    }

    public int hashCode() {
        return (int)((long)this.getDirectory().hashCode() + this.getVersion());
    }

    public abstract long getVersion();

    public abstract long getGeneration();

    public long getTimestamp() throws IOException {
        return this.getDirectory().fileModified(this.getSegmentsFileName());
    }

    public abstract Map getUserData() throws IOException;
}

