/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.index;

final class IndexFileNames {
    static final String SEGMENTS = "segments";
    static final String SEGMENTS_GEN = "segments.gen";
    static final String DELETABLE = "deletable";
    static final String NORMS_EXTENSION = "nrm";
    static final String FREQ_EXTENSION = "frq";
    static final String PROX_EXTENSION = "prx";
    static final String TERMS_EXTENSION = "tis";
    static final String TERMS_INDEX_EXTENSION = "tii";
    static final String FIELDS_INDEX_EXTENSION = "fdx";
    static final String FIELDS_EXTENSION = "fdt";
    static final String VECTORS_FIELDS_EXTENSION = "tvf";
    static final String VECTORS_DOCUMENTS_EXTENSION = "tvd";
    static final String VECTORS_INDEX_EXTENSION = "tvx";
    static final String COMPOUND_FILE_EXTENSION = "cfs";
    static final String COMPOUND_FILE_STORE_EXTENSION = "cfx";
    static final String DELETES_EXTENSION = "del";
    static final String FIELD_INFOS_EXTENSION = "fnm";
    static final String PLAIN_NORMS_EXTENSION = "f";
    static final String SEPARATE_NORMS_EXTENSION = "s";
    static final String GEN_EXTENSION = "gen";
    static final String[] INDEX_EXTENSIONS = new String[]{"cfs", "fnm", "fdx", "fdt", "tii", "tis", "frq", "prx", "del", "tvx", "tvd", "tvf", "gen", "nrm", "cfx"};
    static final String[] INDEX_EXTENSIONS_IN_COMPOUND_FILE = new String[]{"fnm", "fdx", "fdt", "tii", "tis", "frq", "prx", "tvx", "tvd", "tvf", "nrm"};
    static final String[] STORE_INDEX_EXTENSIONS = new String[]{"tvx", "tvf", "tvd", "fdx", "fdt"};
    static final String[] NON_STORE_INDEX_EXTENSIONS = new String[]{"fnm", "frq", "prx", "tis", "tii", "nrm"};
    static final String[] COMPOUND_EXTENSIONS = new String[]{"fnm", "frq", "prx", "fdx", "fdt", "tii", "tis"};
    static final String[] VECTOR_EXTENSIONS = new String[]{"tvx", "tvd", "tvf"};

    IndexFileNames() {
    }

    static final String fileNameFromGeneration(String base, String extension, long gen) {
        if (gen == -1L) {
            return null;
        }
        if (gen == 0L) {
            return base + extension;
        }
        return base + "_" + Long.toString(gen, 36) + extension;
    }

    static final boolean isDocStoreFile(String fileName) {
        if (fileName.endsWith(COMPOUND_FILE_STORE_EXTENSION)) {
            return true;
        }
        for (int i = 0; i < STORE_INDEX_EXTENSIONS.length; ++i) {
            if (!fileName.endsWith(STORE_INDEX_EXTENSIONS[i])) continue;
            return true;
        }
        return false;
    }

    static String segmentFileName(String segmentName, String ext) {
        return segmentName + "." + ext;
    }
}

