/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.apache.lucene.ep.search.Explanation;
import org.apache.lucene.ep.search.Scorer;
import org.apache.lucene.ep.search.Similarity;

class ConjunctionScorer
extends Scorer {
    private final Scorer[] scorers;
    private final float coord;
    private int lastDoc = -1;

    public ConjunctionScorer(Similarity similarity, Collection scorers) throws IOException {
        this(similarity, scorers.toArray(new Scorer[scorers.size()]));
    }

    public ConjunctionScorer(Similarity similarity, Scorer[] scorers) throws IOException {
        super(similarity);
        this.scorers = scorers;
        this.coord = similarity.coord(scorers.length, scorers.length);
        for (int i = 0; i < scorers.length; ++i) {
            if (scorers[i].nextDoc() != Integer.MAX_VALUE) continue;
            this.lastDoc = Integer.MAX_VALUE;
            return;
        }
        Arrays.sort(scorers, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Scorer)o1).docID() - ((Scorer)o2).docID();
            }
        });
        if (this.doNext() == Integer.MAX_VALUE) {
            this.lastDoc = Integer.MAX_VALUE;
            return;
        }
        int end = scorers.length - 1;
        int max = end >> 1;
        for (int i = 0; i < max; ++i) {
            Scorer tmp = scorers[i];
            int idx = end - i - 1;
            scorers[i] = scorers[idx];
            scorers[idx] = tmp;
        }
    }

    private int doNext() throws IOException {
        Scorer firstScorer;
        int first = 0;
        int doc = this.scorers[this.scorers.length - 1].docID();
        while ((firstScorer = this.scorers[first]).docID() < doc) {
            doc = firstScorer.advance(doc);
            first = first == this.scorers.length - 1 ? 0 : first + 1;
        }
        return doc;
    }

    @Override
    public int advance(int target) throws IOException {
        if (this.lastDoc == Integer.MAX_VALUE) {
            return this.lastDoc;
        }
        if (this.scorers[this.scorers.length - 1].docID() < target) {
            this.scorers[this.scorers.length - 1].advance(target);
        }
        this.lastDoc = this.doNext();
        return this.lastDoc;
    }

    @Override
    public int doc() {
        return this.lastDoc;
    }

    @Override
    public int docID() {
        return this.lastDoc;
    }

    @Override
    public Explanation explain(int doc) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean next() throws IOException {
        return this.nextDoc() != Integer.MAX_VALUE;
    }

    @Override
    public int nextDoc() throws IOException {
        if (this.lastDoc == Integer.MAX_VALUE) {
            return this.lastDoc;
        }
        if (this.lastDoc == -1) {
            this.lastDoc = this.scorers[this.scorers.length - 1].docID();
            return this.lastDoc;
        }
        this.scorers[this.scorers.length - 1].nextDoc();
        this.lastDoc = this.doNext();
        return this.lastDoc;
    }

    @Override
    public float score() throws IOException {
        float sum = 0.0f;
        for (int i = 0; i < this.scorers.length; ++i) {
            sum += this.scorers[i].score();
        }
        return sum * this.coord;
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        return this.advance(target) != Integer.MAX_VALUE;
    }
}

