/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.search;

import org.apache.lucene.ep.search.ScoreDoc;
import org.apache.lucene.ep.util.PriorityQueue;

final class HitQueue
extends PriorityQueue {
    private boolean prePopulate;

    HitQueue(int size, boolean prePopulate) {
        this.prePopulate = prePopulate;
        this.initialize(size);
    }

    @Override
    protected Object getSentinelObject() {
        return !this.prePopulate ? null : new ScoreDoc(Integer.MAX_VALUE, Float.NEGATIVE_INFINITY);
    }

    @Override
    protected final boolean lessThan(Object a, Object b) {
        ScoreDoc hitA = (ScoreDoc)a;
        ScoreDoc hitB = (ScoreDoc)b;
        if (hitA.score == hitB.score) {
            return hitA.doc > hitB.doc;
        }
        return hitA.score < hitB.score;
    }
}

