/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.search;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.lucene.ep.index.IndexReader;
import org.apache.lucene.ep.index.Term;
import org.apache.lucene.ep.search.BooleanClause;
import org.apache.lucene.ep.search.BooleanQuery;
import org.apache.lucene.ep.search.ConstantScoreQuery;
import org.apache.lucene.ep.search.FilteredTermEnum;
import org.apache.lucene.ep.search.MultiTermQueryWrapperFilter;
import org.apache.lucene.ep.search.Query;
import org.apache.lucene.ep.search.QueryWrapperFilter;
import org.apache.lucene.ep.search.TermQuery;
import org.apache.lucene.ep.util.ToStringUtils;

public abstract class MultiTermQuery
extends Query {
    protected Term term;
    protected RewriteMethod rewriteMethod = CONSTANT_SCORE_AUTO_REWRITE_DEFAULT;
    transient int numberOfTerms = 0;
    public static final RewriteMethod CONSTANT_SCORE_FILTER_REWRITE = new ConstantScoreFilterRewrite();
    public static final RewriteMethod SCORING_BOOLEAN_QUERY_REWRITE = new ScoringBooleanQueryRewrite();
    public static final RewriteMethod CONSTANT_SCORE_BOOLEAN_QUERY_REWRITE = new ConstantScoreBooleanQueryRewrite();
    public static final RewriteMethod CONSTANT_SCORE_AUTO_REWRITE_DEFAULT = new ConstantScoreAutoRewrite(){

        @Override
        public void setTermCountCutoff(int count) {
            throw new UnsupportedOperationException("Please create a private instance");
        }

        @Override
        public void setDocCountPercent(double percent) {
            throw new UnsupportedOperationException("Please create a private instance");
        }

        protected Object readResolve() {
            return CONSTANT_SCORE_AUTO_REWRITE_DEFAULT;
        }
    };

    public MultiTermQuery(Term term) {
        this.term = term;
    }

    public MultiTermQuery() {
    }

    public Term getTerm() {
        return this.term;
    }

    protected abstract FilteredTermEnum getEnum(IndexReader var1) throws IOException;

    public int getTotalNumberOfTerms() {
        return this.numberOfTerms;
    }

    public void clearTotalNumberOfTerms() {
        this.numberOfTerms = 0;
    }

    protected void incTotalNumberOfTerms(int inc) {
        this.numberOfTerms += inc;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        return this.rewriteMethod.rewrite(reader, this);
    }

    @Override
    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        if (this.term != null) {
            if (!this.term.field().equals(field)) {
                buffer.append(this.term.field());
                buffer.append(":");
            }
            buffer.append(this.term.text());
        } else {
            buffer.append("termPattern:unknown");
        }
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    public RewriteMethod getRewriteMethod() {
        return this.rewriteMethod;
    }

    public void setRewriteMethod(RewriteMethod method) {
        this.rewriteMethod = method;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.getBoost());
        result = 31 * result;
        return result += this.rewriteMethod.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiTermQuery other = (MultiTermQuery)obj;
        if (Float.floatToIntBits(this.getBoost()) != Float.floatToIntBits(other.getBoost())) {
            return false;
        }
        return this.rewriteMethod.equals(other.rewriteMethod);
    }

    public static class ConstantScoreAutoRewrite
    extends RewriteMethod
    implements Serializable {
        public static final int DEFAULT_TERM_COUNT_CUTOFF = 350;
        public static final double DEFAULT_DOC_COUNT_PERCENT = 0.1;
        private int termCountCutoff = 350;
        private double docCountPercent = 0.1;

        public void setTermCountCutoff(int count) {
            this.termCountCutoff = count;
        }

        public int getTermCountCutoff() {
            return this.termCountCutoff;
        }

        public void setDocCountPercent(double percent) {
            this.docCountPercent = percent;
        }

        public double getDocCountPercent() {
            return this.docCountPercent;
        }

        @Override
        public Query rewrite(IndexReader reader, MultiTermQuery query) throws IOException {
            ArrayList<Term> pendingTerms = new ArrayList<Term>();
            int docCountCutoff = (int)(this.docCountPercent / 100.0 * (double)reader.maxDoc());
            int termCountLimit = Math.min(BooleanQuery.getMaxClauseCount(), this.termCountCutoff);
            int docVisitCount = 0;
            try (FilteredTermEnum enumerator = query.getEnum(reader);){
                while (true) {
                    Term t;
                    if ((t = enumerator.term()) != null) {
                        pendingTerms.add(t);
                        docVisitCount += reader.docFreq(t);
                    }
                    if (pendingTerms.size() >= termCountLimit || docVisitCount >= docCountCutoff) {
                        ConstantScoreQuery result = new ConstantScoreQuery(new MultiTermQueryWrapperFilter(query));
                        result.setBoost(query.getBoost());
                        ConstantScoreQuery constantScoreQuery = result;
                        return constantScoreQuery;
                    }
                    if (enumerator.next()) continue;
                    Iterator it = pendingTerms.iterator();
                    BooleanQuery bq = new BooleanQuery(true);
                    while (it.hasNext()) {
                        TermQuery tq = new TermQuery((Term)it.next());
                        bq.add(tq, BooleanClause.Occur.SHOULD);
                    }
                    ConstantScoreQuery result = new ConstantScoreQuery(new QueryWrapperFilter(bq));
                    result.setBoost(query.getBoost());
                    query.incTotalNumberOfTerms(pendingTerms.size());
                    ConstantScoreQuery constantScoreQuery = result;
                    return constantScoreQuery;
                }
            }
        }

        public int hashCode() {
            int prime = 1279;
            return (int)((long)(1279 * this.termCountCutoff) + Double.doubleToLongBits(this.docCountPercent));
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConstantScoreAutoRewrite other = (ConstantScoreAutoRewrite)obj;
            if (other.termCountCutoff != this.termCountCutoff) {
                return false;
            }
            return Double.doubleToLongBits(other.docCountPercent) == Double.doubleToLongBits(this.docCountPercent);
        }
    }

    private static class ConstantScoreBooleanQueryRewrite
    extends ScoringBooleanQueryRewrite
    implements Serializable {
        private ConstantScoreBooleanQueryRewrite() {
        }

        @Override
        public Query rewrite(IndexReader reader, MultiTermQuery query) throws IOException {
            ConstantScoreQuery result = new ConstantScoreQuery(new QueryWrapperFilter(super.rewrite(reader, query)));
            result.setBoost(query.getBoost());
            return result;
        }

        @Override
        protected Object readResolve() {
            return CONSTANT_SCORE_BOOLEAN_QUERY_REWRITE;
        }
    }

    private static class ScoringBooleanQueryRewrite
    extends RewriteMethod
    implements Serializable {
        private ScoringBooleanQueryRewrite() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Query rewrite(IndexReader reader, MultiTermQuery query) throws IOException {
            FilteredTermEnum enumerator = query.getEnum(reader);
            BooleanQuery result = new BooleanQuery(true);
            int count = 0;
            try {
                do {
                    Term t;
                    if ((t = enumerator.term()) == null) continue;
                    TermQuery tq = new TermQuery(t);
                    tq.setBoost(query.getBoost() * enumerator.difference());
                    result.add(tq, BooleanClause.Occur.SHOULD);
                    ++count;
                } while (enumerator.next());
            }
            finally {
                enumerator.close();
            }
            query.incTotalNumberOfTerms(count);
            return result;
        }

        protected Object readResolve() {
            return SCORING_BOOLEAN_QUERY_REWRITE;
        }
    }

    private static final class ConstantScoreFilterRewrite
    extends RewriteMethod
    implements Serializable {
        private ConstantScoreFilterRewrite() {
        }

        @Override
        public Query rewrite(IndexReader reader, MultiTermQuery query) {
            ConstantScoreQuery result = new ConstantScoreQuery(new MultiTermQueryWrapperFilter(query));
            result.setBoost(query.getBoost());
            return result;
        }

        protected Object readResolve() {
            return CONSTANT_SCORE_FILTER_REWRITE;
        }
    }

    public static abstract class RewriteMethod
    implements Serializable {
        public abstract Query rewrite(IndexReader var1, MultiTermQuery var2) throws IOException;
    }
}

