/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.search;

import java.io.IOException;
import org.apache.lucene.ep.index.IndexReader;
import org.apache.lucene.ep.index.Term;
import org.apache.lucene.ep.search.FilteredTermEnum;

public class PrefixTermEnum
extends FilteredTermEnum {
    private final Term prefix;
    private boolean endEnum = false;

    public PrefixTermEnum(IndexReader reader, Term prefix) throws IOException {
        this.prefix = prefix;
        this.setEnum(reader.terms(new Term(prefix.field(), prefix.text())));
    }

    @Override
    public float difference() {
        return 1.0f;
    }

    @Override
    protected boolean endEnum() {
        return this.endEnum;
    }

    protected Term getPrefixTerm() {
        return this.prefix;
    }

    @Override
    protected boolean termCompare(Term term) {
        if (term.field() == this.prefix.field() && term.text().startsWith(this.prefix.text())) {
            return true;
        }
        this.endEnum = true;
        return false;
    }
}

