/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.search;

import java.io.IOException;
import org.apache.lucene.ep.search.DocIdSetIterator;
import org.apache.lucene.ep.search.Explanation;
import org.apache.lucene.ep.search.Scorer;

class ReqExclScorer
extends Scorer {
    private Scorer reqScorer;
    private DocIdSetIterator exclDisi;
    private int doc = -1;

    public ReqExclScorer(Scorer reqScorer, DocIdSetIterator exclDisi) {
        super(null);
        this.reqScorer = reqScorer;
        this.exclDisi = exclDisi;
    }

    @Override
    public boolean next() throws IOException {
        return this.nextDoc() != Integer.MAX_VALUE;
    }

    @Override
    public int nextDoc() throws IOException {
        if (this.reqScorer == null) {
            return this.doc;
        }
        this.doc = this.reqScorer.nextDoc();
        if (this.doc == Integer.MAX_VALUE) {
            this.reqScorer = null;
            return this.doc;
        }
        if (this.exclDisi == null) {
            return this.doc;
        }
        this.doc = this.toNonExcluded();
        return this.doc;
    }

    private int toNonExcluded() throws IOException {
        int exclDoc = this.exclDisi.docID();
        int reqDoc = this.reqScorer.docID();
        do {
            if (reqDoc < exclDoc) {
                return reqDoc;
            }
            if (reqDoc <= exclDoc) continue;
            exclDoc = this.exclDisi.advance(reqDoc);
            if (exclDoc == Integer.MAX_VALUE) {
                this.exclDisi = null;
                return reqDoc;
            }
            if (exclDoc <= reqDoc) continue;
            return reqDoc;
        } while ((reqDoc = this.reqScorer.nextDoc()) != Integer.MAX_VALUE);
        this.reqScorer = null;
        return Integer.MAX_VALUE;
    }

    @Override
    public int doc() {
        return this.reqScorer.doc();
    }

    @Override
    public int docID() {
        return this.doc;
    }

    @Override
    public float score() throws IOException {
        return this.reqScorer.score();
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        return this.advance(target) != Integer.MAX_VALUE;
    }

    @Override
    public int advance(int target) throws IOException {
        if (this.reqScorer == null) {
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        if (this.exclDisi == null) {
            this.doc = this.reqScorer.advance(target);
            return this.doc;
        }
        if (this.reqScorer.advance(target) == Integer.MAX_VALUE) {
            this.reqScorer = null;
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        this.doc = this.toNonExcluded();
        return this.doc;
    }

    @Override
    public Explanation explain(int doc) throws IOException {
        Explanation res = new Explanation();
        if (this.exclDisi.advance(doc) == doc) {
            res.setDescription("excluded");
        } else {
            res.setDescription("not excluded");
            res.addDetail(this.reqScorer.explain(doc));
        }
        return res;
    }
}

