/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ep.search.spans;

import java.io.IOException;
import org.apache.lucene.ep.search.Explanation;
import org.apache.lucene.ep.search.Scorer;
import org.apache.lucene.ep.search.Similarity;
import org.apache.lucene.ep.search.Weight;
import org.apache.lucene.ep.search.spans.Spans;

public class SpanScorer
extends Scorer {
    protected Spans spans;
    protected Weight weight;
    protected byte[] norms;
    protected float value;
    protected boolean firstTime = true;
    protected boolean more = true;
    protected int doc;
    protected float freq;

    protected SpanScorer(Spans spans, Weight weight, Similarity similarity, byte[] norms) throws IOException {
        super(similarity);
        this.spans = spans;
        this.norms = norms;
        this.weight = weight;
        this.value = weight.getValue();
        if (this.spans.next()) {
            this.doc = -1;
        } else {
            this.doc = Integer.MAX_VALUE;
            this.more = false;
        }
    }

    @Override
    public boolean next() throws IOException {
        return this.nextDoc() != Integer.MAX_VALUE;
    }

    @Override
    public int nextDoc() throws IOException {
        if (!this.setFreqCurrentDoc()) {
            this.doc = Integer.MAX_VALUE;
        }
        return this.doc;
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        return this.advance(target) != Integer.MAX_VALUE;
    }

    @Override
    public int advance(int target) throws IOException {
        if (!this.more) {
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }
        if (this.spans.doc() < target) {
            this.more = this.spans.skipTo(target);
        }
        if (!this.setFreqCurrentDoc()) {
            this.doc = Integer.MAX_VALUE;
        }
        return this.doc;
    }

    protected boolean setFreqCurrentDoc() throws IOException {
        if (!this.more) {
            return false;
        }
        this.doc = this.spans.doc();
        this.freq = 0.0f;
        do {
            int matchLength = this.spans.end() - this.spans.start();
            this.freq += this.getSimilarity().sloppyFreq(matchLength);
            this.more = this.spans.next();
        } while (this.more && this.doc == this.spans.doc());
        return true;
    }

    @Override
    public int doc() {
        return this.doc;
    }

    @Override
    public int docID() {
        return this.doc;
    }

    @Override
    public float score() throws IOException {
        float raw = this.getSimilarity().tf(this.freq) * this.value;
        return this.norms == null ? raw : raw * Similarity.decodeNorm(this.norms[this.doc]);
    }

    @Override
    public Explanation explain(int doc) throws IOException {
        Explanation tfExplanation = new Explanation();
        int expDoc = this.advance(doc);
        float phraseFreq = expDoc == doc ? this.freq : 0.0f;
        tfExplanation.setValue(this.getSimilarity().tf(phraseFreq));
        tfExplanation.setDescription("tf(phraseFreq=" + phraseFreq + ")");
        return tfExplanation;
    }
}

