/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ep.ui.autocomplete;

import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;
import org.fife.ep.ui.autocomplete.AutoCompletePopupWindow;
import org.fife.ep.ui.autocomplete.Completion;
import org.fife.ep.ui.autocomplete.CompletionProvider;
import org.fife.ep.ui.autocomplete.ExternalURLHandler;
import org.fife.ep.ui.autocomplete.ParameterizedCompletion;
import org.fife.ep.ui.autocomplete.ParameterizedCompletionDescriptionToolTip;

public class AutoCompletion
implements HierarchyListener {
    private static final Logger logger = Logger.getLogger(AutoCompletion.class);
    private JTextComponent textComponent;
    private Window parentWindow;
    private AutoCompletePopupWindow popupWindow;
    private Dimension preferredDescWindowSize;
    private ParameterizedCompletionDescriptionToolTip descToolTip;
    private CompletionProvider[] providers;
    private ListCellRenderer renderer;
    private ExternalURLHandler externalURLHandler;
    private boolean showDescWindow;
    private boolean autoCompleteEnabled;
    private boolean autoCompleteSingleChoices;
    private boolean parameterAssistanceEnabled;
    private KeyStroke trigger;
    private Object oldTriggerKey;
    private Action oldTriggerAction;
    private Object oldParenKey;
    private Action oldParenAction;
    private Listener parentWindowListener;
    private static final String PARAM_TRIGGER_KEY = "AutoComplete";
    private static final String PARAM_COMPLETE_KEY = "AutoCompletion.FunctionStart";
    private static final boolean DEBUG = AutoCompletion.initDebug();

    public AutoCompletion(CompletionProvider[] providers) {
        this.setCompletionProviders(providers);
        this.setTriggerKey(AutoCompletion.getDefaultTriggerKey());
        this.setAutoCompleteEnabled(true);
        this.setAutoCompleteSingleChoices(true);
        this.setShowDescWindow(false);
        this.parentWindowListener = new Listener();
    }

    private void displayDescriptionToolTip(ParameterizedCompletion pc, boolean addParamListStart) {
        this.hideToolTipWindow();
        if (pc.getParamCount() == 0) {
            CompletionProvider p = pc.getProvider();
            String text = Character.toString(p.getParameterListEnd());
            if (addParamListStart) {
                text = p.getParameterListStart() + text;
            }
            this.textComponent.replaceSelection(text);
            return;
        }
        this.descToolTip = new ParameterizedCompletionDescriptionToolTip(this.parentWindow, this, pc);
        try {
            int dot = this.textComponent.getCaretPosition();
            Rectangle r = this.textComponent.modelToView(dot);
            Point p = new Point(r.x, r.y);
            SwingUtilities.convertPointToScreen(p, this.textComponent);
            r.x = p.x;
            r.y = p.y;
            this.descToolTip.setLocationRelativeTo(r);
            this.descToolTip.setVisible(true, addParamListStart);
        }
        catch (BadLocationException ble) {
            UIManager.getLookAndFeel().provideErrorFeedback(this.textComponent);
            logger.error((Object)"AutoCompletion.displayDescriptionToolTip", (Throwable)ble);
        }
    }

    public void doCompletion() {
        this.refreshPopupWindow();
    }

    public boolean getAutoCompleteSingleChoices() {
        return this.autoCompleteSingleChoices;
    }

    public CompletionProvider[] getCompletionProviders() {
        return this.providers;
    }

    static boolean getDebug() {
        return DEBUG;
    }

    public static KeyStroke getDefaultTriggerKey() {
        int mask = 2;
        return KeyStroke.getKeyStroke(77, mask);
    }

    public ExternalURLHandler getExternalURLHandler() {
        return this.externalURLHandler;
    }

    int getLineOfCaret() {
        Document doc = this.textComponent.getDocument();
        Element root = doc.getDefaultRootElement();
        return root.getElementIndex(this.textComponent.getCaretPosition());
    }

    public ListCellRenderer getListCellRenderer() {
        return this.renderer;
    }

    protected String getReplacementText(Completion c, Document doc, int start, int len) {
        return c.getReplacementText();
    }

    public boolean getShowDescWindow() {
        return this.showDescWindow;
    }

    public JTextComponent getTextComponent() {
        return this.textComponent;
    }

    ComponentOrientation getTextComponentOrientation() {
        return this.textComponent == null ? null : this.textComponent.getComponentOrientation();
    }

    public KeyStroke getTriggerKey() {
        return this.trigger;
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        Window oldParentWindow = this.parentWindow;
        this.parentWindow = SwingUtilities.getWindowAncestor(this.textComponent);
        if (this.parentWindow != oldParentWindow) {
            if (oldParentWindow != null) {
                this.parentWindowListener.removeFrom(oldParentWindow);
            }
            if (this.parentWindow != null) {
                this.parentWindowListener.addTo(this.parentWindow);
            }
        }
    }

    public boolean hideChildWindows() {
        boolean res = this.hidePopupWindow();
        return res |= this.hideToolTipWindow();
    }

    private boolean hidePopupWindow() {
        if (this.popupWindow != null && this.popupWindow.isVisible()) {
            this.popupWindow.setVisible(false);
            return true;
        }
        return false;
    }

    private boolean hideToolTipWindow() {
        if (this.descToolTip != null) {
            this.descToolTip.setVisible(false, false);
            this.descToolTip = null;
            return true;
        }
        return false;
    }

    private static final boolean initDebug() {
        boolean debug = false;
        try {
            debug = Boolean.parseBoolean("AutoCompletion.debug");
        }
        catch (SecurityException se) {
            debug = false;
        }
        return debug;
    }

    void insertCompletion(Completion c) {
        JTextComponent textComp = this.getTextComponent();
        String alreadyEntered = c.getAlreadyEntered(textComp);
        this.hidePopupWindow();
        Caret caret = textComp.getCaret();
        int dot = caret.getDot();
        int len = alreadyEntered.length();
        int start = dot - len;
        String replacement = this.getReplacementText(c, textComp.getDocument(), start, len);
        caret.setDot(start);
        caret.moveDot(dot);
        textComp.replaceSelection(replacement);
        if (this.isParameterAssistanceEnabled() && c instanceof ParameterizedCompletion) {
            ParameterizedCompletion pc = (ParameterizedCompletion)c;
            this.displayDescriptionToolTip(pc, true);
        }
    }

    public void install(JTextComponent c) {
        if (this.textComponent != null) {
            this.uninstall();
        }
        this.textComponent = c;
        this.installTriggerKey(this.getTriggerKey());
        for (int i = 0; i < this.providers.length; ++i) {
            char start = this.providers[i].getParameterListStart();
            if (start == '\u0000') continue;
            InputMap im = c.getInputMap();
            ActionMap am = c.getActionMap();
            KeyStroke ks = KeyStroke.getKeyStroke(start);
            this.oldParenKey = im.get(ks);
            im.put(ks, PARAM_COMPLETE_KEY);
            this.oldParenAction = am.get(PARAM_COMPLETE_KEY);
            am.put(PARAM_COMPLETE_KEY, new ParameterizedCompletionStartAction(start));
            break;
        }
        this.textComponent.addHierarchyListener(this);
        this.hierarchyChanged(null);
    }

    private void installTriggerKey(KeyStroke ks) {
        InputMap im = this.textComponent.getInputMap();
        this.oldTriggerKey = im.get(ks);
        im.put(ks, PARAM_TRIGGER_KEY);
        ActionMap am = this.textComponent.getActionMap();
        this.oldTriggerAction = am.get(PARAM_TRIGGER_KEY);
        am.put(PARAM_TRIGGER_KEY, new AutoCompleteAction());
    }

    public boolean isAutoCompleteEnabled() {
        return this.autoCompleteEnabled;
    }

    public boolean isParameterAssistanceEnabled() {
        return this.parameterAssistanceEnabled;
    }

    private boolean isPopupVisible() {
        return this.popupWindow != null && this.popupWindow.isVisible();
    }

    protected int refreshPopupWindow() {
        List coms = null;
        for (int i = 0; i < this.providers.length; ++i) {
            List cs = this.providers[i].getCompletions(this.textComponent);
            if (cs == null) continue;
            if (coms == null) {
                coms = cs;
                continue;
            }
            coms.addAll(cs);
        }
        final List completions = coms;
        int count = completions.size();
        if (count > 1 || count == 1 && this.isPopupVisible() || count == 1 && !this.getAutoCompleteSingleChoices()) {
            if (this.popupWindow == null) {
                this.popupWindow = new AutoCompletePopupWindow(this.parentWindow, this);
                this.popupWindow.applyComponentOrientation(this.getTextComponentOrientation());
                if (this.renderer != null) {
                    this.popupWindow.setListCellRenderer(this.renderer);
                }
                if (this.preferredDescWindowSize != null) {
                    this.popupWindow.setDescriptionWindowSize(this.preferredDescWindowSize);
                }
            }
            this.popupWindow.setCompletions(completions);
            if (!this.popupWindow.isVisible()) {
                Rectangle r = null;
                try {
                    r = this.textComponent.modelToView(this.textComponent.getCaretPosition());
                }
                catch (BadLocationException ble) {
                    logger.error((Object)"AutoCompletion.refreshPopupWindow", (Throwable)ble);
                    return -1;
                }
                Point p = new Point(r.x, r.y);
                SwingUtilities.convertPointToScreen(p, this.textComponent);
                r.x = p.x;
                r.y = p.y;
                this.popupWindow.setLocationRelativeTo(r);
                this.popupWindow.setVisible(true);
            }
        } else if (count == 1) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AutoCompletion.this.insertCompletion((Completion)completions.get(0));
                }
            });
        } else {
            this.hidePopupWindow();
        }
        return this.getLineOfCaret();
    }

    public void setAutoCompleteEnabled(boolean enabled) {
        if (enabled != this.autoCompleteEnabled) {
            this.autoCompleteEnabled = enabled;
            this.hidePopupWindow();
        }
    }

    public void setAutoCompleteSingleChoices(boolean autoComplete) {
        this.autoCompleteSingleChoices = autoComplete;
    }

    public void setCompletionProviders(CompletionProvider[] providers) {
        if (providers == null) {
            throw new IllegalArgumentException("provider cannot be null");
        }
        this.providers = providers;
        this.hidePopupWindow();
    }

    public void setDescriptionWindowSize(int w, int h) {
        this.preferredDescWindowSize = new Dimension(w, h);
        if (this.popupWindow != null) {
            this.popupWindow.setDescriptionWindowSize(this.preferredDescWindowSize);
        }
    }

    public void setExternalURLHandler(ExternalURLHandler handler) {
        this.externalURLHandler = handler;
    }

    public void setListCellRenderer(ListCellRenderer renderer) {
        this.renderer = renderer;
        if (this.popupWindow != null) {
            this.popupWindow.setListCellRenderer(renderer);
            this.hidePopupWindow();
        }
    }

    public void setParameterAssistanceEnabled(boolean enabled) {
        this.parameterAssistanceEnabled = enabled;
    }

    public void setShowDescWindow(boolean show) {
        this.hidePopupWindow();
        this.showDescWindow = show;
    }

    public void setTriggerKey(KeyStroke ks) {
        if (ks == null) {
            throw new IllegalArgumentException("trigger key cannot be null");
        }
        if (!ks.equals(this.trigger)) {
            if (this.textComponent != null) {
                this.uninstallTriggerKey();
                this.installTriggerKey(ks);
            }
            this.trigger = ks;
        }
    }

    public void uninstall() {
        if (this.textComponent != null) {
            this.hidePopupWindow();
            this.uninstallTriggerKey();
            for (int i = 0; i < this.providers.length; ++i) {
                char start = this.providers[i].getParameterListStart();
                if (start == '\u0000') continue;
                KeyStroke ks = KeyStroke.getKeyStroke(start);
                InputMap im = this.textComponent.getInputMap();
                im.put(ks, this.oldParenKey);
                ActionMap am = this.textComponent.getActionMap();
                am.put(PARAM_COMPLETE_KEY, this.oldParenAction);
                break;
            }
            this.textComponent.removeHierarchyListener(this);
            if (this.parentWindow != null) {
                this.parentWindowListener.removeFrom(this.parentWindow);
            }
            this.textComponent = null;
            this.popupWindow = null;
        }
    }

    private void uninstallTriggerKey() {
        InputMap im = this.textComponent.getInputMap();
        im.put(this.trigger, this.oldTriggerKey);
        ActionMap am = this.textComponent.getActionMap();
        am.put(PARAM_TRIGGER_KEY, this.oldTriggerAction);
    }

    public void updateUI() {
        if (this.popupWindow != null) {
            this.popupWindow.updateUI();
        }
        if (this.descToolTip != null) {
            this.descToolTip.updateUI();
        }
    }

    private class ParameterizedCompletionStartAction
    extends AbstractAction {
        private String start;

        public ParameterizedCompletionStartAction(char ch) {
            this.start = Character.toString(ch);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AutoCompletion.this.hidePopupWindow();
            AutoCompletion.this.textComponent.replaceSelection(this.start);
            if (!AutoCompletion.this.isParameterAssistanceEnabled()) {
                return;
            }
            List completions = null;
            for (int i = 0; i < AutoCompletion.this.providers.length; ++i) {
                List cs = AutoCompletion.this.providers[i].getParameterizedCompletions(AutoCompletion.this.textComponent);
                if (cs == null) continue;
                if (completions == null) {
                    completions = cs;
                    continue;
                }
                completions.addAll(cs);
            }
            if (completions != null && completions.size() > 0) {
                ParameterizedCompletion pc = (ParameterizedCompletion)completions.get(0);
                AutoCompletion.this.displayDescriptionToolTip(pc, false);
            }
        }
    }

    private class Listener
    extends ComponentAdapter
    implements WindowFocusListener {
        private Listener() {
        }

        public void addTo(Window w) {
            w.addComponentListener(this);
            w.addWindowFocusListener(this);
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            AutoCompletion.this.hideChildWindows();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            AutoCompletion.this.hideChildWindows();
        }

        @Override
        public void componentResized(ComponentEvent e) {
            AutoCompletion.this.hideChildWindows();
        }

        public void removeFrom(Window w) {
            w.removeComponentListener(this);
            w.removeWindowFocusListener(this);
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
        }

        @Override
        public void windowLostFocus(WindowEvent e) {
            AutoCompletion.this.hideChildWindows();
        }
    }

    class AutoCompleteAction
    extends AbstractAction {
        AutoCompleteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AutoCompletion.this.isAutoCompleteEnabled()) {
                AutoCompletion.this.refreshPopupWindow();
            } else if (AutoCompletion.this.oldTriggerAction != null) {
                AutoCompletion.this.oldTriggerAction.actionPerformed(e);
            }
        }
    }
}

