/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectReferedException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.BaseTreeModel;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseException;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.app.AbstractTreeBaseControllerBean;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.framework.util.StringUtility;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.log4j.Logger;

public class TreeBaseControllerBean
extends AbstractTreeBaseControllerBean {
    private final int startlevel = 1;
    public static final Locale locale_L1 = LocaleUtils.locale_L1;
    public static final Locale locale_L2 = LocaleUtils.locale_L2;
    public static final Locale locale_L3 = LocaleUtils.locale_L3;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.framework.app.TreeBaseControllerBean");
    private BaseTreeModel treeModel;

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        boolean notExistLongNumber = false;
        SelectorItemInfo info = null;
        for (int i = 0; i < selector.size(); ++i) {
            info = selector.get(i);
            if (!info.getPropertyName().equals("longNumber")) continue;
            notExistLongNumber = true;
        }
        if (notExistLongNumber) {
            info = new SelectorItemInfo("longNumber");
            selector.add(info);
        }
        return super._getValue(ctx, pk, selector);
    }

    @Override
    protected void _checkParentDataExist(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException, TreeBaseException {
        TreeBaseInfo treeBaseInfo = (TreeBaseInfo)model;
        treeBaseInfo = this.lazyLoad(ctx, (IObjectValue)treeBaseInfo);
        boolean deleted = false;
        String longNumber = treeBaseInfo.getLongNumber();
        if (longNumber.indexOf("!") < 0) {
            return;
        }
        TreeBaseInfo parent = this.getFullParent(ctx, (IObjectValue)treeBaseInfo);
        if (parent == null) {
            throw new TreeBaseException(TreeBaseException.CHECKPARENTNOTNULL);
        }
        if (this._isExistPropertyName(ctx, parent, "deletedStatus") && treeBaseInfo.getBoolean("deletedStatus")) {
            deleted = true;
        }
        if (deleted) {
            throw new TreeBaseException(TreeBaseException.CHECKPARENTDELETED, new Object[0]);
        }
    }

    @Override
    protected void _checkParentValid(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException, TreeBaseException {
        TreeBaseInfo treeBaseInfo = (TreeBaseInfo)model;
        treeBaseInfo = this.lazyLoad(ctx, (IObjectValue)treeBaseInfo);
        this._checkParentDataExist(ctx, pk, (IObjectValue)treeBaseInfo);
        TreeBaseInfo parent = this.getFullParent(ctx, (IObjectValue)treeBaseInfo);
        if (this._isExistPropertyName(ctx, parent, "effectedStatus") && !parent.getBoolean("effectedStatus")) {
            throw new TreeBaseException(TreeBaseException.CHECKPARENTINVALIDED, new Object[0]);
        }
    }

    @Override
    protected void _checkParentBeUsed(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException, TreeBaseException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            this._isReferenced(ctx, pk, cn);
        }
        catch (ObjectReferedException ore) {
            throw new TreeBaseException(TreeBaseException.CHECKPARENTBEUSED, new Object[0]);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    @Override
    protected IObjectValue _getRoot(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TreeBaseInfo treeBaseInfo = (TreeBaseInfo)model;
        treeBaseInfo = this.lazyLoad(ctx, (IObjectValue)treeBaseInfo);
        String longNumber = treeBaseInfo.getLongNumber();
        String[] numbers = longNumber.split("!");
        String root = numbers[0];
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("longNumber", (Object)treeBaseInfo.getLongNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        TreeBaseCollection results = this.getTreeBaseCollection(ctx, ev);
        if (results != null && results.size() > 0) {
            return results.get(0);
        }
        return null;
    }

    @Override
    protected void _deleteWithChildren(Context ctx, IObjectValue model) throws BOSException, EASBizException, TreeBaseException {
        TreeBaseInfo treeBaseInfo = (TreeBaseInfo)model;
        if (treeBaseInfo == null) {
            throw new TreeBaseException(TreeBaseException.CHECKISNULL);
        }
        treeBaseInfo = this.lazyLoad(ctx, (IObjectValue)treeBaseInfo);
        TreeBaseCollection childrenCol = this.getAllChildren(ctx, treeBaseInfo);
        for (int i = 0; i < childrenCol.size(); ++i) {
            super._delete(ctx, (IObjectPK)new ObjectUuidPK(childrenCol.get(i).getId()));
        }
        super._delete(ctx, (IObjectPK)new ObjectUuidPK(treeBaseInfo.getId()));
        TreeBaseInfo parent = this.getFullParent(ctx, (IObjectValue)treeBaseInfo);
        if (parent != null) {
            this.resetLeafAndUpdateByChildRemoved(ctx, (IObjectValue)parent);
        }
    }

    @Override
    protected IObjectCollection _getChildren(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TreeBaseInfo treeBaseInfo = (TreeBaseInfo)model;
        if (treeBaseInfo == null) {
            throw new TreeBaseException(TreeBaseException.CHECKISNULL);
        }
        FilterInfo filter = new FilterInfo();
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("parent", (Object)treeBaseInfo.getId().toString(), CompareType.EQUALS));
        TreeBaseCollection col = this.getTreeBaseCollection(ctx, ev);
        for (int i = 0; i < col.size(); ++i) {
            col.get(i).innerSetParent(treeBaseInfo);
        }
        return col;
    }

    @Override
    protected BaseTreeModel _getTreeModel(Context ctx, IObjectValue node) throws BOSException, EASBizException {
        TreeBaseInfo rootObject = (TreeBaseInfo)node;
        if (rootObject == null) {
            throw new TreeBaseException(TreeBaseException.CHECKNODEISNULL);
        }
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        this.treeModel = new BaseTreeModel(rootNode);
        rootNode.setUserObject(rootObject);
        this.buildChildrenTreeModel(ctx, rootObject, rootNode);
        return this.treeModel;
    }

    private void buildChildrenTreeModel(Context ctx, TreeBaseInfo parentObject, DefaultMutableTreeNode parentNode) throws BOSException, EASBizException {
        TreeBaseCollection childrenObject = this.getChildren(ctx, parentObject);
        for (int i = 0; i < childrenObject.size(); ++i) {
            TreeBaseInfo childInfo = childrenObject.get(i);
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode();
            childNode.setUserObject(childInfo);
            this.treeModel.insertNodeInto(childNode, parentNode, i);
            this.buildChildrenTreeModel(ctx, childInfo, childNode);
        }
    }

    @Override
    protected IObjectValue _getValueWithParent(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            throw new TreeBaseException(TreeBaseException.CHECKISNULL);
        }
        TreeBaseInfo info = (TreeBaseInfo)super.getValue(ctx, pk);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("parent"));
        TreeBaseInfo infoWithParent = (TreeBaseInfo)super.getValue(ctx, pk);
        info.innerSetParent(infoWithParent.innerGetParent());
        return info;
    }

    @Override
    protected IObjectCollection _getAllChildren(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TreeBaseInfo treeBaseInfo = (TreeBaseInfo)model;
        if (treeBaseInfo == null) {
            EntityViewInfo ev = new EntityViewInfo();
            ev.setFilter(new FilterInfo());
            ev.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", (Object)"%", CompareType.LIKE));
            FilterInfo filterCU = this.getFilterForDefaultCU(ctx, (IObjectValue)treeBaseInfo);
            if (FilterUtility.hasFilterItem(filterCU)) {
                ev.getFilter().mergeFilter(filterCU, "AND");
            }
            TreeBaseCollection col = this.getTreeBaseCollection(ctx, ev);
            return col;
        }
        treeBaseInfo = this.lazyLoad(ctx, (IObjectValue)treeBaseInfo);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(new FilterInfo());
        ev.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", (Object)(treeBaseInfo.getLongNumber() + "!" + "%"), CompareType.LIKE));
        FilterInfo filterCU = this.getFilterForDefaultCU(ctx, (IObjectValue)treeBaseInfo);
        if (FilterUtility.hasFilterItem(filterCU)) {
            ev.getFilter().mergeFilter(filterCU, "AND");
        }
        TreeBaseCollection col = this.getTreeBaseCollection(ctx, ev);
        return col;
    }

    @Override
    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TreeBaseInfo treeModel = (TreeBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = null;
        if (treeModel.innerGetParent() == null) {
            filterItem = new FilterItemInfo("number", (Object)treeModel.getNumber(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
            filter.getFilterItems().add(new FilterItemInfo("parent", null, CompareType.EQUALS));
            filter.setMaskString("#0 and #1");
            if (treeModel.getId() != null) {
                filterItem = new FilterItemInfo("id", (Object)treeModel.getId().toString(), CompareType.NOTEQUALS);
                filter.getFilterItems().add(filterItem);
                filter.setMaskString("#0 and #1 and #2");
            }
        } else {
            filterItem = new FilterItemInfo("number", (Object)treeModel.getNumber(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
            if (treeModel.innerGetParent().getId() != null) {
                filterItem = new FilterItemInfo("parent", (Object)treeModel.innerGetParent().getId().toString(), CompareType.EQUALS);
                filter.getFilterItems().add(filterItem);
                filter.setMaskString("#0 and #1");
            }
            if (treeModel.getId() != null) {
                filterItem = new FilterItemInfo("id", (Object)treeModel.getId().toString(), CompareType.NOTEQUALS);
                filter.getFilterItems().add(filterItem);
                if (treeModel.innerGetParent().getId() != null) {
                    filter.setMaskString("#0 and #1 and #2");
                } else {
                    filter.setMaskString("#0 and #1");
                }
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterCU = this.getFilterForDefaultCU(ctx, (IObjectValue)treeModel);
        if (FilterUtility.hasFilterItem(filterCU)) {
            if (FilterUtility.hasFilterItem(filter)) {
                filter.mergeFilter(filterCU, "AND");
            } else {
                filter = filterCU;
            }
        }
        view.setFilter(filter);
        TreeBaseCollection results = this.getTreeBaseCollection(ctx, view);
        if (results != null && results.size() > 0) {
            throw new TreeBaseException(TreeBaseException.CHECKNUMBERDUPLICATED, new Object[]{treeModel.getNumber()});
        }
    }

    protected int getLongNumberLen(Context ctx, TreeBaseInfo info) throws EASBizException, BOSException {
        int maxLen = 0;
        String longNumberParam = null;
        longNumberParam = ParamManager.getParamValue((Context)ctx, null, (String)"TreeLongNumberlen");
        if (longNumberParam != null) {
            maxLen = Integer.parseInt(longNumberParam);
        }
        return maxLen;
    }

    private void checkLongNumberLen(Context ctx, TreeBaseInfo info) throws EASBizException, BOSException {
        String propertyAlias = null;
        int maxLen = 0;
        propertyAlias = this.getPropertyAlias(ctx, info, "longNumber", ctx.getOriginLocale());
        int len = null == info.getLongNumber() ? -1 : info.getLongNumber().length();
        if (len > (maxLen = this.getLongNumberLen(ctx, info))) {
            throw new TreeBaseException(TreeBaseException.CHECKLONGNUMBERLEN, new Object[]{propertyAlias, String.valueOf(maxLen)});
        }
    }

    private void checkLongNumberLen(Context ctx, TreeBaseInfo info, String longNumber) throws EASBizException, BOSException {
        String propertyAlias = null;
        int maxLen = 0;
        propertyAlias = this.getPropertyAlias(ctx, info, "longNumber", ctx.getOriginLocale());
        int len = null == longNumber ? -1 : longNumber.length();
        if (len > (maxLen = this.getLongNumberLen(ctx, info))) {
            throw new TreeBaseException(TreeBaseException.CHECKLONGNUMBERLEN, new Object[]{propertyAlias, String.valueOf(maxLen)});
        }
    }

    private PropertyInfo getProperty(Context ctx, CoreBaseInfo info, String propertyName) {
        EntityObjectInfo entity = this.getBOSEntity(ctx, info);
        PropertyInfo property = null;
        property = entity.getPropertyByNameRuntime(propertyName);
        return property;
    }

    private String getPropertyAlias(Context ctx, CoreBaseInfo info, String propertyName, Locale locale) {
        String alias = null;
        PropertyInfo property = this.getProperty(ctx, info, propertyName);
        if (property != null) {
            alias = property.getAlias(locale);
        }
        return alias;
    }

    private void LinkDisplayName(TreeBaseInfo parent, TreeBaseInfo info, Locale locale) {
        String disPlayName = null;
        String parentDisplayName = parent.getDisplayName(locale);
        disPlayName = parentDisplayName != null ? parentDisplayName + "_" + info.getName(locale) : info.getName(locale);
        info.setDisplayName(disPlayName, locale);
    }

    @Override
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        TreeBaseInfo treeBaseInfo = (TreeBaseInfo)model;
        if (treeBaseInfo == null) {
            throw new TreeBaseException(TreeBaseException.CHECKISNULL);
        }
        this._checkNumberDup(ctx, (IObjectValue)treeBaseInfo);
        treeBaseInfo.setIsLeaf(true);
        TreeBaseInfo parent = this.getFullParent(ctx, (IObjectValue)treeBaseInfo);
        if (parent == null || parent.getId().equals((Object)treeBaseInfo.getId())) {
            treeBaseInfo.setLevel(1);
            treeBaseInfo.setLongNumber(treeBaseInfo.getNumber());
            this.checkLongNumberLen(ctx, treeBaseInfo);
            treeBaseInfo.setDisplayName(treeBaseInfo.getName());
            treeBaseInfo.setDisplayName(treeBaseInfo.getName(locale_L1), locale_L1);
            this.limitDisplayNameLength(treeBaseInfo, locale_L1);
            treeBaseInfo.setDisplayName(treeBaseInfo.getName(locale_L2), locale_L2);
            this.limitDisplayNameLength(treeBaseInfo, locale_L2);
            treeBaseInfo.setDisplayName(treeBaseInfo.getName(locale_L3), locale_L3);
            this.limitDisplayNameLength(treeBaseInfo, locale_L3);
        } else {
            treeBaseInfo.setLevel(parent.getLevel() + 1);
            treeBaseInfo.setLongNumber(parent.getLongNumber() + "!" + treeBaseInfo.getNumber());
            this.checkLongNumberLen(ctx, treeBaseInfo);
            treeBaseInfo.setDisplayName(parent.getDisplayName() + "_" + treeBaseInfo.getName());
            this.LinkDisplayName(parent, treeBaseInfo, locale_L1);
            this.limitDisplayNameLength(treeBaseInfo, locale_L1);
            this.LinkDisplayName(parent, treeBaseInfo, locale_L2);
            this.limitDisplayNameLength(treeBaseInfo, locale_L2);
            this.LinkDisplayName(parent, treeBaseInfo, locale_L3);
            this.limitDisplayNameLength(treeBaseInfo, locale_L3);
            if (parent.isIsLeaf()) {
                parent.setIsLeaf(false);
                super._update(ctx, (IObjectPK)new ObjectUuidPK(parent.getId()), (IObjectValue)parent);
            }
        }
        super._addnew(ctx, pk, (IObjectValue)treeBaseInfo);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TreeBaseInfo treeBaseInfo = (TreeBaseInfo)model;
        if (treeBaseInfo == null) {
            throw new TreeBaseException(TreeBaseException.CHECKISNULL);
        }
        this._checkNumberDup(ctx, (IObjectValue)treeBaseInfo);
        TreeBaseInfo parent = this.getFullParent(ctx, (IObjectValue)treeBaseInfo);
        treeBaseInfo.setIsLeaf(true);
        if (parent == null || parent.getId().equals((Object)treeBaseInfo.getId())) {
            treeBaseInfo.setLevel(1);
            treeBaseInfo.setLongNumber(treeBaseInfo.getNumber());
            this.checkLongNumberLen(ctx, treeBaseInfo);
            treeBaseInfo.setDisplayName(treeBaseInfo.getName());
            treeBaseInfo.setDisplayName(treeBaseInfo.getName(locale_L1), locale_L1);
            this.limitDisplayNameLength(treeBaseInfo, locale_L1);
            treeBaseInfo.setDisplayName(treeBaseInfo.getName(locale_L2), locale_L2);
            this.limitDisplayNameLength(treeBaseInfo, locale_L2);
            treeBaseInfo.setDisplayName(treeBaseInfo.getName(locale_L3), locale_L3);
            this.limitDisplayNameLength(treeBaseInfo, locale_L3);
        } else {
            treeBaseInfo.setLevel(parent.getLevel() + 1);
            treeBaseInfo.setLongNumber(parent.getLongNumber() + "!" + treeBaseInfo.getNumber());
            this.checkLongNumberLen(ctx, treeBaseInfo);
            this.LinkDisplayName(parent, treeBaseInfo, null);
            this.limitDisplayNameLength(treeBaseInfo);
            this.LinkDisplayName(parent, treeBaseInfo, locale_L1);
            this.limitDisplayNameLength(treeBaseInfo, locale_L1);
            this.LinkDisplayName(parent, treeBaseInfo, locale_L2);
            this.limitDisplayNameLength(treeBaseInfo, locale_L2);
            this.LinkDisplayName(parent, treeBaseInfo, locale_L3);
            this.limitDisplayNameLength(treeBaseInfo, locale_L3);
            if (parent.isIsLeaf()) {
                parent.setIsLeaf(false);
                super._update(ctx, (IObjectPK)new ObjectUuidPK(parent.getId()), (IObjectValue)parent);
            }
        }
        IObjectPK pk = super._addnew(ctx, (IObjectValue)treeBaseInfo);
        return pk;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        TreeBaseInfo info = null;
        info = this.getValueWithParent(ctx, pk);
        if (info == null) {
            throw new TreeBaseException(TreeBaseException.CHECKISNULL);
        }
        if (!info.isIsLeaf()) {
            throw new TreeBaseException(TreeBaseException.CHECKHAVECHILDREN, new Object[]{info.getName()});
        }
        super._delete(ctx, pk);
        TreeBaseInfo parent = this.getFullParent(ctx, (IObjectValue)info);
        if (parent != null) {
            this.resetLeafAndUpdateByChildRemoved(ctx, (IObjectValue)parent);
        }
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        logger.error((Object)"TreeBaseControllerBean _UpdateBegin!");
        Long t1 = System.currentTimeMillis();
        TreeBaseInfo treeBaseInfo = (TreeBaseInfo)model;
        if (treeBaseInfo == null) {
            throw new TreeBaseException(TreeBaseException.CHECKISNULL);
        }
        TreeBaseInfo oldInfo = (TreeBaseInfo)this._getValue(ctx, pk);
        Long t2 = System.currentTimeMillis();
        logger.error((Object)("get old value ended and cost time\uff1a" + (t2 - t1)));
        String oldDisplayName = oldInfo.getDisplayName();
        String oldDisplayName_L1 = oldInfo.getDisplayName(locale_L1);
        String oldDisplayName_L2 = oldInfo.getDisplayName(locale_L2);
        String oldDisplayName_L3 = oldInfo.getDisplayName(locale_L3);
        String oldLongNumber = oldInfo.getLongNumber();
        if (treeBaseInfo.getDisplayName() == null) {
            treeBaseInfo.setDisplayName(oldDisplayName);
            treeBaseInfo.setDisplayName(oldDisplayName_L1, locale_L1);
            treeBaseInfo.setDisplayName(oldDisplayName_L2, locale_L2);
            treeBaseInfo.setDisplayName(oldDisplayName_L3, locale_L3);
        }
        if (treeBaseInfo.getLongNumber() == null) {
            treeBaseInfo.setLongNumber(oldLongNumber);
            this.checkLongNumberLen(ctx, treeBaseInfo);
        }
        if (oldLongNumber == null) {
            throw new TreeBaseException(TreeBaseException.CHECKISNULL);
        }
        if (treeBaseInfo.containsKey("number") && oldLongNumber != null) {
            String longNumber = "";
            String number = "";
            longNumber = oldLongNumber;
            number = treeBaseInfo.getNumber();
            TreeBaseInfo parent = this.getFullParent(ctx, (IObjectValue)treeBaseInfo);
            if (parent == null || parent.getId().equals((Object)treeBaseInfo.getId())) {
                treeBaseInfo.setLongNumber(treeBaseInfo.getNumber());
                this.checkLongNumberLen(ctx, treeBaseInfo);
                treeBaseInfo.setDisplayName(treeBaseInfo.getName());
                treeBaseInfo.setDisplayName(treeBaseInfo.getName(locale_L1), locale_L1);
                treeBaseInfo.setDisplayName(treeBaseInfo.getName(locale_L2), locale_L2);
                treeBaseInfo.setDisplayName(treeBaseInfo.getName(locale_L3), locale_L3);
            } else {
                treeBaseInfo.setLongNumber(parent.getLongNumber() + "!" + treeBaseInfo.getNumber());
                this.checkLongNumberLen(ctx, treeBaseInfo);
                this.LinkDisplayName(parent, treeBaseInfo, null);
                this.LinkDisplayName(parent, treeBaseInfo, locale_L1);
                this.LinkDisplayName(parent, treeBaseInfo, locale_L2);
                this.LinkDisplayName(parent, treeBaseInfo, locale_L3);
            }
            this.checkLNForTree(ctx, treeBaseInfo);
            int level = treeBaseInfo.getLongNumber().split("!").length;
            treeBaseInfo.setLevel(level);
            longNumber = treeBaseInfo.getLongNumber();
            if (!longNumber.substring(longNumber.lastIndexOf("!") + 1).equals(number)) {
                this._checkNumberDup(ctx, (IObjectValue)treeBaseInfo);
                treeBaseInfo.setLongNumber(longNumber.substring(0, longNumber.lastIndexOf("!") + 1) + treeBaseInfo.getNumber());
                this.checkLongNumberLen(ctx, treeBaseInfo);
            }
        }
        this.limitDisplayNameLength(treeBaseInfo);
        this.limitDisplayNameLength(treeBaseInfo, locale_L1);
        this.limitDisplayNameLength(treeBaseInfo, locale_L2);
        this.limitDisplayNameLength(treeBaseInfo, locale_L3);
        if (this.needUpdtaeChild(treeBaseInfo, oldInfo)) {
            this.updateChildrens(ctx, (IObjectValue)treeBaseInfo, (IObjectValue)oldInfo);
        }
        Long t3 = System.currentTimeMillis();
        logger.error((Object)"begin update self");
        super._update(ctx, pk, (IObjectValue)treeBaseInfo);
        logger.error((Object)("update self ended and cost time " + (t3 - t2)));
    }

    private boolean needUpdtaeChild(TreeBaseInfo treeBaseInfo, TreeBaseInfo oldTreeBaseInfo) {
        if (oldTreeBaseInfo.getLongNumber() != null && !oldTreeBaseInfo.getLongNumber().equals(treeBaseInfo.getLongNumber())) {
            return true;
        }
        if (oldTreeBaseInfo.getDisplayName() != null && !oldTreeBaseInfo.getDisplayName().equals(treeBaseInfo.getDisplayName())) {
            return true;
        }
        if (oldTreeBaseInfo.getDisplayName(locale_L1) != null && !oldTreeBaseInfo.getDisplayName(locale_L1).equals(treeBaseInfo.getDisplayName(locale_L1))) {
            return true;
        }
        if (oldTreeBaseInfo.getDisplayName(locale_L2) != null && !oldTreeBaseInfo.getDisplayName(locale_L2).equals(treeBaseInfo.getDisplayName(locale_L2))) {
            return true;
        }
        return oldTreeBaseInfo.getDisplayName(locale_L3) != null && !oldTreeBaseInfo.getDisplayName(locale_L3).equals(treeBaseInfo.getDisplayName(locale_L3));
    }

    protected void checkLNForTree(Context ctx, TreeBaseInfo treeBaseInfo) throws BOSException, EASBizException, TreeBaseException {
        FilterInfo lNfilter = new FilterInfo();
        lNfilter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)treeBaseInfo.getLongNumber()));
        lNfilter.getFilterItems().add(new FilterItemInfo("id", (Object)treeBaseInfo.getId().toString(), CompareType.NOTEQUALS));
        lNfilter.setMaskString("#0 AND #1");
        FilterInfo filterCU = this.getFilterForDefaultCU(ctx, (IObjectValue)treeBaseInfo);
        if (FilterUtility.hasFilterItem(filterCU)) {
            lNfilter.mergeFilter(filterCU, "AND");
        }
        if (this.exists(ctx, lNfilter)) {
            throw new TreeBaseException(TreeBaseException.CHECKNUMBERDUPLICATED, new Object[]{treeBaseInfo.getNumber()});
        }
    }

    private void resetLeafAndUpdateByChildRemoved(Context ctx, IObjectValue model) throws BOSException, EASBizException, TreeBaseException {
        TreeBaseInfo treeBaseInfo = (TreeBaseInfo)model;
        if (treeBaseInfo == null) {
            throw new TreeBaseException(TreeBaseException.CHECKISNULL);
        }
        boolean isLeaf = this.isLeaf(ctx, treeBaseInfo.getId().toString());
        if (isLeaf) {
            treeBaseInfo.setIsLeaf(true);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(treeBaseInfo.getId()), (IObjectValue)treeBaseInfo);
        }
    }

    private void updateChildrenByNumberUpdated(Context ctx, IObjectValue model, String oldLongNumber) throws BOSException, EASBizException {
        TreeBaseInfo treeBaseInfo = (TreeBaseInfo)model;
        String longNumber = treeBaseInfo.getLongNumber();
        FilterItemInfo item = new FilterItemInfo("longNumber", (Object)(oldLongNumber + "!" + "%"), CompareType.LIKE);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(item);
        FilterInfo filterCU = this.getFilterForDefaultCU(ctx, (IObjectValue)treeBaseInfo);
        if (FilterUtility.hasFilterItem(filterCU)) {
            filter.mergeFilter(filterCU, "AND");
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        TreeBaseCollection collection = this.getTreeBaseCollection(ctx, view);
        TreeBaseInfo temp = null;
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            temp = (TreeBaseInfo)iter.next();
            String temps = StringUtility.castRegular(oldLongNumber);
            String temps1 = StringUtility.castRegular(longNumber);
            temp.setLongNumber(temp.getLongNumber().replaceFirst(temps, temps1));
            this.checkLongNumberLen(ctx, temp);
            int level = temp.getLongNumber().split("!").length;
            temp.setLevel(level);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(temp.getId()), (IObjectValue)temp);
        }
    }

    private String getTableName(Context ctx, IObjectValue model) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo bo = loader.getEntity(this.getBOSType());
        return bo.getTable().getName();
    }

    private TreeBaseInfo getParent(Context ctx, TreeBaseInfo model) throws BOSException, EASBizException {
        TreeBaseInfo treeBaseInfo = model;
        return treeBaseInfo.innerGetParent();
    }

    private TreeBaseInfo getFullParent(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TreeBaseInfo treeBaseInfo = (TreeBaseInfo)model;
        TreeBaseInfo parent = treeBaseInfo.innerGetParent();
        if (parent == null || parent.getId().equals((Object)treeBaseInfo.getId())) {
            return null;
        }
        parent = this.lazyLoad(ctx, (IObjectValue)parent);
        treeBaseInfo.innerSetParent(parent);
        return parent;
    }

    private TreeBaseInfo lazyLoad(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TreeBaseInfo treeBaseInfo = (TreeBaseInfo)model;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("CU.id"));
        selector.add(new SelectorItemInfo("longNumber"));
        selector.add(new SelectorItemInfo("parent"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("level"));
        selector.add(new SelectorItemInfo("isLeaf"));
        selector.add(new SelectorItemInfo("displayName"));
        selector.add(new SelectorItemInfo("deletedStatus"));
        TreeBaseInfo result = (TreeBaseInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(treeBaseInfo.getId()), selector);
        return result;
    }

    @Override
    protected void _moveTreeNode(Context ctx, IObjectValue sourceNode, IObjectValue targetNode) throws EASBizException, BOSException {
        TreeBaseInfo sourceTree = (TreeBaseInfo)sourceNode;
        TreeBaseInfo targetTree = (TreeBaseInfo)targetNode;
        ObjectUuidPK sourceTreePK = new ObjectUuidPK(((TreeBaseInfo)sourceNode).getId());
        ObjectUuidPK targetTreePK = null;
        sourceTree = (TreeBaseInfo)super._getValue(ctx, (IObjectPK)sourceTreePK);
        if (targetNode == null) {
            targetTree = null;
        } else {
            targetTreePK = new ObjectUuidPK(((TreeBaseInfo)targetNode).getId());
            targetTree = (TreeBaseInfo)super._getValue(ctx, (IObjectPK)targetTreePK);
        }
        this.canMove(sourceTree);
        this.canReceive(targetTree);
        if (sourceTree.getLevel() > 1) {
            ObjectUuidPK parentPK = new ObjectUuidPK(((TreeBaseInfo)sourceNode.get("parent")).getId());
            TreeBaseInfo parent = (TreeBaseInfo)super._getValue(ctx, (IObjectPK)parentPK);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent", (Object)parent.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)sourceTree.getId().toString(), CompareType.NOTEQUALS));
            if (!this._exists(ctx, filter)) {
                parent.setIsLeaf(true);
                this._update(ctx, (IObjectPK)parentPK, (IObjectValue)parent);
            }
        }
        if (targetTree != null && targetTree.isIsLeaf()) {
            targetTree.setIsLeaf(false);
            this._update(ctx, (IObjectPK)targetTreePK, (IObjectValue)targetTree);
        }
        sourceTree.innerSetParent(targetTree);
        this._update(ctx, (IObjectPK)sourceTreePK, (IObjectValue)sourceTree);
    }

    protected void canMove(TreeBaseInfo tree) throws EASBizException, BOSException {
    }

    protected void canReceive(TreeBaseInfo tree) throws EASBizException, BOSException {
    }

    @Override
    protected IObjectCollection _getAllChildren(Context ctx, IObjectValue model, EntityViewInfo view) throws BOSException, EASBizException {
        FilterInfo filterCU;
        TreeBaseInfo treeBaseInfo = (TreeBaseInfo)model;
        if (treeBaseInfo == null) {
            EntityViewInfo ev = view;
            if (view.getFilter() == null || view.getFilter().size() == 0) {
                ev.setFilter(new FilterInfo());
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)"%", CompareType.LIKE));
            if (FilterUtility.hasFilterItem(ev.getFilter())) {
                ev.getFilter().mergeFilter(filter, "AND");
            } else {
                ev.setFilter(filter);
            }
            FilterInfo filterCU2 = this.getFilterForDefaultCU(ctx, (IObjectValue)treeBaseInfo);
            if (FilterUtility.hasFilterItem(filterCU2)) {
                ev.getFilter().mergeFilter(filterCU2, "AND");
            }
            TreeBaseCollection col = this.getTreeBaseCollection(ctx, ev);
            return col;
        }
        treeBaseInfo = this.lazyLoad(ctx, (IObjectValue)treeBaseInfo);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(new FilterInfo());
        ev.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", (Object)(treeBaseInfo.getLongNumber() + "!" + "%"), CompareType.LIKE));
        if (FilterUtility.hasFilterItem(view.getFilter())) {
            ev.getFilter().mergeFilter(view.getFilter(), "AND");
        }
        if (view != null && view.getSelector() != null) {
            ev.getSelector().addObjectCollection((IObjectCollection)view.getSelector());
        }
        if (FilterUtility.hasFilterItem(filterCU = this.getFilterForDefaultCU(ctx, (IObjectValue)treeBaseInfo))) {
            ev.getFilter().mergeFilter(filterCU, "AND");
        }
        TreeBaseCollection col = this.getTreeBaseCollection(ctx, ev);
        return col;
    }

    private void updateChildrenByNameUpdated(Context ctx, IObjectValue model, String oldDisplayName, String oldLongNumber) throws BOSException, EASBizException {
        TreeBaseInfo treeBaseInfo = (TreeBaseInfo)model;
        String displayName = treeBaseInfo.getDisplayName();
        FilterItemInfo item = new FilterItemInfo("longNumber", (Object)(treeBaseInfo.getLongNumber() + "!" + "%"), CompareType.LIKE);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(item);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        FilterInfo filterCU = this.getFilterForDefaultCU(ctx, (IObjectValue)treeBaseInfo);
        if (FilterUtility.hasFilterItem(filterCU)) {
            view.getFilter().mergeFilter(filterCU, "AND");
        }
        TreeBaseCollection collection = this.getTreeBaseCollection(ctx, view);
        TreeBaseInfo temp = null;
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            temp = (TreeBaseInfo)iter.next();
            if (oldDisplayName != null) {
                if (temp.getDisplayName() != null) {
                    if (temp.getDisplayName().indexOf(oldDisplayName) > 1) {
                        return;
                    }
                    String temps = StringUtility.castRegular(oldDisplayName);
                    String temps1 = StringUtility.castRegular(displayName);
                    temp.setDisplayName(temp.getDisplayName().replaceFirst(temps + "_", temps1 + "_"));
                } else {
                    temp.setDisplayName(displayName);
                }
            } else {
                temp.setDisplayName(displayName);
            }
            this.limitDisplayNameLength(temp);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(temp.getId()), (IObjectValue)temp);
        }
    }

    private void updateChildrenByNameUpdated(Context ctx, IObjectValue model, String oldDisplayName, String oldLongNumber, Locale locale) throws BOSException, EASBizException {
        TreeBaseInfo treeBaseInfo = (TreeBaseInfo)model;
        String displayName = treeBaseInfo.getDisplayName(locale);
        if (displayName == null) {
            return;
        }
        FilterItemInfo item = new FilterItemInfo("longNumber", (Object)(treeBaseInfo.getLongNumber() + "!" + "%"), CompareType.LIKE);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(item);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        FilterInfo filterCU = this.getFilterForDefaultCU(ctx, (IObjectValue)treeBaseInfo);
        if (FilterUtility.hasFilterItem(filterCU)) {
            view.getFilter().mergeFilter(filterCU, "AND");
        }
        TreeBaseCollection collection = this.getTreeBaseCollection(ctx, view);
        TreeBaseInfo temp = null;
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            temp = (TreeBaseInfo)iter.next();
            if (oldDisplayName != null) {
                if (temp.getDisplayName(locale) != null) {
                    if (temp.getDisplayName(locale).indexOf(oldDisplayName) > 1) {
                        return;
                    }
                    String temps = StringUtility.castRegular(oldDisplayName);
                    String temps1 = StringUtility.castRegular(displayName);
                    if (!displayName.startsWith(temps)) {
                        temp.setDisplayName(temp.getDisplayName(locale).replaceFirst(temps + "_", temps1 + "_"), locale);
                    }
                } else {
                    temp.setDisplayName(displayName, locale);
                }
            } else {
                temp.setDisplayName(displayName, locale);
            }
            this.limitDisplayNameLength(temp);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(temp.getId()), (IObjectValue)temp);
        }
    }

    private void updateChildrens(Context ctx, IObjectValue model, IObjectValue oldModel) throws BOSException, EASBizException {
        TreeBaseInfo treeBaseInfo = (TreeBaseInfo)model;
        TreeBaseInfo oldTreeBaseInfo = (TreeBaseInfo)oldModel;
        String oldDisplayName_l1 = oldTreeBaseInfo.getDisplayName(locale_L1);
        String oldDisplayName_l2 = oldTreeBaseInfo.getDisplayName(locale_L2);
        String oldDisplayName_l3 = oldTreeBaseInfo.getDisplayName(locale_L3);
        String oldLongNumber = oldTreeBaseInfo.getLongNumber();
        logger.error((Object)"begin get Childrens");
        Long t1 = System.currentTimeMillis();
        if (treeBaseInfo.containsKey("number") && treeBaseInfo.containsKey("name")) {
            FilterItemInfo item = new FilterItemInfo("longNumber", (Object)(oldLongNumber + "!" + "%"), CompareType.LIKE);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(item);
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            FilterInfo filterCU = this.getFilterForDefaultCU(ctx, (IObjectValue)treeBaseInfo);
            if (FilterUtility.hasFilterItem(filterCU)) {
                view.getFilter().mergeFilter(filterCU, "AND");
            }
            TreeBaseCollection collection = this.getTreeBaseCollection(ctx, view);
            logger.error((Object)("get Childrens size : " + collection.size()));
            Long t2 = System.currentTimeMillis();
            logger.error((Object)("get Childrens ended and cost time : " + (t2 - t1)));
            TreeBaseInfo temp = null;
            Iterator iter = collection.iterator();
            StringBuffer sql = new StringBuffer();
            String newDisplayName_l1 = treeBaseInfo.getDisplayName(locale_L1);
            String newDisplayName_l2 = treeBaseInfo.getDisplayName(locale_L2);
            String newDisplayName_l3 = treeBaseInfo.getDisplayName(locale_L3);
            String newLongNumber = treeBaseInfo.getLongNumber();
            String tempDisplayName_l1 = null;
            String tempDisplayName_l2 = null;
            String tempDisplayName_l3 = null;
            String tempLongNumber = null;
            int temLevel = 0;
            sql.append("update ").append(this.getTableName(ctx, model));
            sql.append(" set  FLONGNUMBER=?,FDISPLAYNAME_L1=?,FDISPLAYNAME_L2=?,FDISPLAYNAME_L3=?,FLEVEL=?, ");
            sql.append("FLASTUPDATEUSERID=?,FLASTUPDATETIME=? ");
            sql.append("where FID = ?");
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            Timestamp updateTime = this.getTime2();
            String updater = ctx.getCaller().toString();
            logger.error((Object)("begin update children with sql :" + sql.toString()));
            Long t3 = System.currentTimeMillis();
            while (iter.hasNext()) {
                temp = (TreeBaseInfo)iter.next();
                tempDisplayName_l1 = this.generateDisplayame(temp.getDisplayName(locale_L1), oldDisplayName_l1, newDisplayName_l1);
                tempDisplayName_l2 = this.generateDisplayame(temp.getDisplayName(locale_L2), oldDisplayName_l2, newDisplayName_l2);
                tempDisplayName_l3 = this.generateDisplayame(temp.getDisplayName(locale_L3), oldDisplayName_l3, newDisplayName_l3);
                tempLongNumber = this.generateLongNumber(ctx, temp.getLongNumber(), oldLongNumber, newLongNumber, temp);
                temLevel = tempLongNumber.split("!").length;
                Object[] params = new Object[]{tempLongNumber, tempDisplayName_l1, tempDisplayName_l2, tempDisplayName_l3, temLevel, updater, updateTime, temp.getId().toString()};
                paramList.add(params);
                if (paramList.size() <= 200) continue;
                DbUtil.executeBatch((Context)ctx, (String)sql.toString(), paramList);
                paramList.clear();
            }
            if (paramList.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)sql.toString(), paramList);
                paramList.clear();
            }
            Long t4 = System.currentTimeMillis();
            logger.error((Object)("update children ended and cost time :" + (t4 - t3)));
        } else if (!treeBaseInfo.containsKey("number") && treeBaseInfo.containsKey("name") || !treeBaseInfo.containsKey("number") || !treeBaseInfo.containsKey("name")) {
            // empty if block
        }
    }

    private Timestamp getTime2() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    private String generateDisplayame(String temp, String oldValue, String newValue) {
        if (temp == null) {
            return null;
        }
        if (temp != null && newValue != null) {
            if (oldValue == null) {
                temp = newValue + "_" + temp;
                return this.limitDisplayNameLength(temp);
            }
            if (!temp.startsWith(oldValue + "_")) {
                temp = temp.indexOf("_") == -1 ? newValue + "_" + temp : newValue + temp.substring(temp.indexOf("_"));
                return this.limitDisplayNameLength(temp);
            }
            oldValue = StringUtility.castRegular(oldValue);
            newValue = StringUtility.castRegular(newValue);
            temp = temp.replaceFirst(oldValue + "_", newValue + "_");
            return this.limitDisplayNameLength(temp);
        }
        if (temp != null && newValue == null) {
            return temp;
        }
        return temp;
    }

    private String generateLongNumber(Context ctx, String temp, String oldValue, String newValue, TreeBaseInfo info) throws EASBizException, BOSException {
        if (temp == null) {
            return null;
        }
        if (temp != null && newValue != null) {
            oldValue = StringUtility.castRegular(oldValue);
            newValue = StringUtility.castRegular(newValue);
            temp = temp.replaceFirst(oldValue + "!", newValue + "!");
            this.checkLongNumberLen(ctx, info, temp);
            return temp;
        }
        if (temp != null && newValue == null) {
            return temp;
        }
        return temp;
    }

    protected int getDisplayNameLength() {
        return 80;
    }

    private void limitDisplayNameLength(TreeBaseInfo tree) {
        String displayName = tree.getDisplayName();
        String[] displayNameVar = StringUtils.split((String)displayName, (String)"_");
        if (displayNameVar == null) {
            return;
        }
        if (displayNameVar.length > 1 && displayName.length() > this.getDisplayNameLength()) {
            int len = displayName.indexOf("_");
            displayName = displayName.substring(len + 1);
            tree.setDisplayName(displayName);
            this.limitDisplayNameLength(tree);
        }
    }

    private String limitDisplayNameLength(String displayName) {
        String[] displayNameVar = StringUtils.split((String)displayName, (String)"_");
        if (displayNameVar == null) {
            return null;
        }
        if (displayNameVar.length > 1 && displayName.length() > this.getDisplayNameLength()) {
            int len = displayName.indexOf("_");
            displayName = displayName.substring(len + 1);
            this.limitDisplayNameLength(displayName);
        }
        return displayName;
    }

    private void limitDisplayNameLength(TreeBaseInfo tree, Locale locale) {
        String displayName = tree.getDisplayName(locale);
        String[] displayNameVar = StringUtils.split((String)displayName, (String)"_");
        if (displayNameVar == null) {
            return;
        }
        if (displayNameVar.length > 1 && displayName.length() > this.getDisplayNameLength()) {
            int len = displayName.indexOf("_");
            displayName = displayName.substring(len + 1);
            tree.setDisplayName(displayName, locale);
            this.limitDisplayNameLength(tree, locale);
        }
    }

    @Override
    protected String _getFullDisplayName(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String fullDisplayName = "";
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("displayName"));
        TreeBaseInfo tree = (TreeBaseInfo)this._getValue(ctx, pk, selector);
        fullDisplayName = tree.getDisplayName();
        return fullDisplayName;
    }

    private void syncParentIsLeafStatus(Context ctx, TreeBaseInfo oldParentInfo, TreeBaseInfo parentInfo) throws EASBizException, BOSException {
        if (oldParentInfo != null && oldParentInfo.getId() != null && parentInfo != null && parentInfo.getId() != null && oldParentInfo.getId().toString().equals(parentInfo.getId().toString())) {
            return;
        }
        if (oldParentInfo != null && oldParentInfo.getId() != null) {
            this.updateIsLeafState(ctx, oldParentInfo.getId().toString());
        }
        if (parentInfo != null && parentInfo.getId() != null) {
            this.updateIsLeafState(ctx, parentInfo.getId().toString());
        }
    }

    private void updateIsLeafState(Context ctx, String id) throws BOSException, EASBizException {
        boolean isLeaf = this.isLeaf(ctx, id);
        if (isLeaf) {
            this.updateIsLeafState(ctx, id, true);
        } else {
            this.updateIsLeafState(ctx, id, false);
        }
    }

    private boolean isLeaf(Context ctx, String id) throws BOSException {
        boolean isLeaf = false;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)id));
        viewInfo.setFilter(filter);
        viewInfo.setTopCount(1);
        TreeBaseCollection coll = this.getTreeBaseCollection(ctx, viewInfo);
        isLeaf = coll.size() <= 0;
        return isLeaf;
    }

    private void updateIsLeafState(Context ctx, String id, boolean isLeaf) throws EASBizException, BOSException {
        if (this.exists(ctx, (IObjectPK)new ObjectUuidPK(id))) {
            TreeBaseInfo baseInfo = this.getTreeBaseInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
            baseInfo.setIsLeaf(isLeaf);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("isLeaf"));
            this.updatePartial(ctx, baseInfo, selector);
        }
    }
}

