/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.portal;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.cp.common.json.org.JSONArray;
import com.kingdee.eas.cp.common.json.org.JSONObject;
import com.kingdee.eas.portal.IPortletCategory;
import com.kingdee.eas.portal.PortletCategoryCollection;
import com.kingdee.eas.portal.PortletCategoryFactory;
import com.kingdee.eas.portal.PortletCategoryInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class PortletCategoryTreeUtil {
    public static final String ROOT_LONGNUMBER = "root";
    public static final String PC_OTHER = "XkGI/dDGlkWJhX5ZEW9lOEPH2a4=";

    public static Map getPortletCategoryMap(PortletCategoryCollection pcc) {
        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>();
        String parentLongNumber = "";
        String currentLongNumber = "";
        ArrayList pcInfos = null;
        PortletCategoryInfo pcInfo = null;
        int pccSize = pcc.size();
        for (int i = 0; i < pccSize; ++i) {
            pcInfo = pcc.get(i);
            currentLongNumber = pcInfo.getLongNumber();
            parentLongNumber = currentLongNumber.lastIndexOf("!") != -1 ? currentLongNumber.substring(0, currentLongNumber.lastIndexOf("!")) : ROOT_LONGNUMBER;
            pcInfos = !map.containsKey(parentLongNumber) ? new ArrayList() : (ArrayList)map.get(parentLongNumber);
            pcInfos.add(pcInfo);
            map.put(parentLongNumber, pcInfos);
        }
        return map;
    }

    public static PortletCategoryCollection getAllPortletCategory(Context ctx) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SorterItemInfo info = new SorterItemInfo("createtime");
        SorterItemCollection coll = new SorterItemCollection();
        info.setSortType(SortType.ASCEND);
        coll.add(info);
        viewInfo.setSorter(coll);
        IPortletCategory pcf = null;
        pcf = ctx == null ? PortletCategoryFactory.getRemoteInstance() : PortletCategoryFactory.getLocalInstance(ctx);
        return pcf.getPortletCategoryCollection(viewInfo);
    }

    public static JSONArray makePortletsTreeData(Locale locale, Map map, String rootLongNumber, Map portletsMap) {
        JSONArray reply = new JSONArray();
        JSONObject cells = null;
        if (map.size() == 0) {
            return reply;
        }
        ArrayList pcInfos = (ArrayList)map.get(rootLongNumber);
        if (pcInfos == null || pcInfos.size() == 0) {
            return reply;
        }
        PortletCategoryInfo pcInfo = null;
        JSONArray portletJson = null;
        int size = pcInfos.size();
        for (int i = 0; i < size; ++i) {
            pcInfo = (PortletCategoryInfo)pcInfos.get(i);
            String pcID = pcInfo.getId().toString();
            portletJson = (JSONArray)portletsMap.get(pcID);
            cells = new JSONObject();
            cells.put("id", (Object)pcID);
            cells.put("text", (Object)pcInfo.getName(locale));
            cells.put("isStandard", (Object)(pcInfo.getIsStandard() == 0 ? Boolean.valueOf(false) : Boolean.valueOf(true)));
            cells.put("draggable", (Object)new Boolean(false));
            if (!(map.containsKey(pcInfo.getLongNumber()) || portletJson != null && portletJson.length() > 0)) {
                cells.put("leaf", (Object)true);
            } else {
                JSONArray childArray = PortletCategoryTreeUtil.makePortletsTreeData(locale, map, pcInfo.getLongNumber(), portletsMap);
                if (portletJson != null) {
                    int len = portletJson.length();
                    for (int j = 0; j < len; ++j) {
                        childArray.put(portletJson.get(j));
                    }
                }
                cells.put("children", (Object)childArray);
            }
            cells.put("iconCls", (Object)"x-tree-node-kd");
            reply.put((Object)cells);
        }
        return reply;
    }
}

