/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.portal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.portal.IPage;
import com.kingdee.eas.portal.IPageFacade;
import com.kingdee.eas.portal.PageCollection;
import com.kingdee.eas.portal.PageFacadeFactory;
import com.kingdee.eas.portal.PageFactory;
import com.kingdee.eas.portal.PageInfo;
import com.kingdee.eas.portal.PagesInfo;
import com.kingdee.eas.portal.PortalException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class PortalSynchronizationBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.portal.app.PortalSynchronizationBean");

    private HashSet getUserPageIds(Context ctx) throws BOSException, SQLException {
        HashSet<String> set = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isDefault", (Object)"0"));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("user.id", (Object)ctx.getCaller().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("pageDescription.pageState", (Object)"20"));
        filter.setMaskString("#0 and #1 and #2 and #3");
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("createTime"));
        String strTemp = null;
        IRowSet rowSet = this.queryExe(ctx, "com.kingdee.eas.portal.app", "PagesQuery", view);
        if (rowSet != null) {
            set = new HashSet<String>();
            while (rowSet.next()) {
                set.add(rowSet.getString("page.id"));
                strTemp = rowSet.getString("page.fromPage");
                if (strTemp == null || strTemp.length() <= 0) continue;
                set.add(strTemp);
            }
        }
        return set;
    }

    private IRowSet queryExe(Context ctx, String packageName, String queryName, EntityViewInfo viewInfo) throws BOSException {
        IQueryExecutor queryExecutor = null;
        MetaDataPK metaDataPK = new MetaDataPK(packageName, queryName);
        queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)metaDataPK);
        if (viewInfo != null && viewInfo.getSorter() != null && viewInfo.getSorter().size() > 0) {
            queryExecutor.option().isIgnoreOrder = true;
        }
        queryExecutor.setObjectView(viewInfo);
        IRowSet rowSet = queryExecutor.executeQuery();
        return rowSet;
    }

    private HashSet getDefaultPageIds(Context ctx, HashSet userPageSet) throws BOSException, SQLException {
        HashSet<String> pageIds = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isDefault", (Object)"1"));
        filter.getFilterItems().add(new FilterItemInfo("pageDescription.controlable", (Object)"0"));
        filter.getFilterItems().add(new FilterItemInfo("pageDescription.sysPage", (Object)"1"));
        filter.getFilterItems().add(new FilterItemInfo("user.id", (Object)ctx.getCaller().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("pageDescription.sysPage", (Object)new Integer(2), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("pageDescription.pageState", (Object)"20"));
        if (userPageSet != null && userPageSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("page.id", (Object)userPageSet, CompareType.NOTINCLUDE));
            filter.setMaskString("((#0 and  #1 and #2) or (#3 and #4))  and #5 and #6 ");
        } else {
            filter.setMaskString("((#0 and  #1 and #2) or (#3 and #4)) and #5 ");
        }
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("createTime"));
        IRowSet rowSet = this.queryExe(ctx, "com.kingdee.eas.portal.app", "PagesQuery", view);
        if (rowSet != null) {
            pageIds = new HashSet<String>();
            while (rowSet.next()) {
                pageIds.add(rowSet.getString("page.id"));
            }
        }
        return pageIds;
    }

    private void updatePersonPage(Context ctx) {
        StringBuffer strbCPersonSql = new StringBuffer();
        strbCPersonSql.append("select * where ").append("fromPage is null");
        strbCPersonSql.append(" and pageDescription.sysPage = ").append("2");
        HashMap<String, String[]> hashMap = null;
        HashSet<String> set = null;
        String strTemp = null;
        String[] ids = null;
        try {
            IPageFacade iPageFacade = PageFacadeFactory.getLocalInstance(ctx);
            IPage iPage = PageFactory.getLocalInstance(ctx);
            PageCollection pagecol = iPage.getPageCollection(strbCPersonSql.toString());
            Iterator it = pagecol.iterator();
            if (pagecol.size() != 0) {
                while (it.hasNext()) {
                    PageInfo pageInfo = (PageInfo)it.next();
                    strbCPersonSql = new StringBuffer();
                    strbCPersonSql.append("select * where ").append("fromPage = '" + pageInfo.getId().toString() + "'");
                    strbCPersonSql.append(" and pageDescription.sysPage = 2");
                    strbCPersonSql.append(" and COPYTIME <'" + pageInfo.getLastUpdateTime() + "'");
                    PageCollection temppagecol = iPage.getPageCollection(strbCPersonSql.toString());
                    Iterator tempit = temppagecol.iterator();
                    if (temppagecol.size() == 0) continue;
                    hashMap = new HashMap<String, String[]>();
                    set = new HashSet<String>();
                    while (tempit.hasNext()) {
                        PageInfo info = (PageInfo)tempit.next();
                        ids = new String[]{info.getId().toString(), String.valueOf(info.getOrderNum()), String.valueOf(info.getIsDefaultOpen()), info.getPageDescription().getId().toString(), info.getTab().getId().toString(), info.getParent() != null ? info.getParent().getId().toString() : ""};
                        strTemp = pageInfo.getId().toString();
                        set.add(strTemp);
                        hashMap.put(strTemp, ids);
                    }
                    iPageFacade.copyPage(set, pageInfo.getPages(), hashMap, 1);
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    public void synchronizate(Context ctx) throws BOSException, EASBizException {
        long startTime = System.currentTimeMillis();
        logger.info((Object)"check portal data start.");
        try {
            IPageFacade iPageFacade = PageFacadeFactory.getLocalInstance(ctx);
            PagesInfo pagesInfo = iPageFacade.getUserPagesInfo();
            HashSet userPageSet = this.getUserPageIds(ctx);
            StringBuffer idBuffer = new StringBuffer();
            Iterator iterator = userPageSet.iterator();
            boolean bFlag = false;
            while (iterator.hasNext()) {
                if (bFlag) {
                    idBuffer.append(",");
                } else {
                    bFlag = true;
                }
                idBuffer.append("'").append(iterator.next()).append("'");
            }
            logger.info((Object)"check no control portal data.");
            HashSet sysPageIds = this.getDefaultPageIds(ctx, userPageSet);
            logger.info((Object)"check control portal data.");
            String sqlPermission = null;
            IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
            sqlPermission = iPermission.getQueryPermissionSQL(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()), "portal_page_view");
            bFlag = false;
            IRowSet rowSet = null;
            String strTemp = null;
            StringBuffer sqlBuffer = new StringBuffer();
            sqlBuffer.append("select A.FID ID from T_PORTAL_PAGE A,T_PORTAL_PAGEDESCRIPTION B where ");
            sqlBuffer.append("A.FID in(");
            sqlBuffer.append("select ID from (").append(sqlPermission);
            if (idBuffer.length() > 0) {
                sqlBuffer.append(") perItem where \"ID\" not in (").append(idBuffer).append(")");
            } else {
                sqlBuffer.append(") permItem");
            }
            sqlBuffer.append(") and A.FPAGEDESCRIPTIONID=B.FID and B.FPAGESTATE=").append(20);
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
            if (rowSet != null) {
                while (rowSet.next()) {
                    strTemp = rowSet.getString("ID");
                    if (sysPageIds.contains(strTemp)) continue;
                    sysPageIds.add(strTemp);
                }
            }
            idBuffer = new StringBuffer();
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlPermission);
            if (rowSet != null) {
                while (rowSet.next()) {
                    strTemp = rowSet.getString("ID");
                    if (bFlag) {
                        idBuffer.append(",");
                    } else {
                        bFlag = true;
                    }
                    idBuffer.append("'").append(strTemp).append("'");
                }
            }
            logger.info((Object)"delete canceled control portal data.");
            sqlBuffer = new StringBuffer();
            sqlBuffer.append("update T_PORTAL_PAGEDESCRIPTION set FPAGESTATE=");
            sqlBuffer.append(40);
            sqlBuffer.append(" where T_PORTAL_PAGEDESCRIPTION.FCONTROLABLE=1 and T_PORTAL_PAGEDESCRIPTION.FPAGESTATE=");
            sqlBuffer.append(20).append(" and T_PORTAL_PAGEDESCRIPTION.FID in (select T_PORTAL_PAGE.FPAGEDESCRIPTIONID from T_PORTAL_PAGE where T_PORTAL_PAGE.FPAGESID='");
            sqlBuffer.append(pagesInfo.getId().toString()).append("'");
            if (idBuffer != null && idBuffer.length() > 0) {
                sqlBuffer.append(" and T_PORTAL_PAGE.FFROMPAGEID not in (").append(idBuffer).append("))");
            } else {
                sqlBuffer.append(")");
            }
            logger.info((Object)("---lyanzhang update sql: " + sqlBuffer.toString()));
            iPageFacade.copyPages(sysPageIds, pagesInfo, sqlBuffer.toString());
            logger.info((Object)"start update portal data.");
            this.copyFromPage(ctx, pagesInfo);
            this.updatePersonPage(ctx);
            logger.info((Object)"update end.");
            System.out.println("synchronizate portal data cost:" + (System.currentTimeMillis() - startTime));
        }
        catch (SQLException e) {
            logger.info((Object)"check portal data err.");
            e.printStackTrace();
            throw new PortalException(PortalException.SYNCH_FAIL, e);
        }
    }

    private void copyFromPage(Context ctx, PagesInfo pagsInfo) throws BOSException, SQLException, EASBizException {
        HashMap<String, String[]> hashMap = null;
        HashSet<String> set = null;
        String strTemp = null;
        String[] ids = null;
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select A.FID AID,A.FORDERNUM,A.FISDEFAULTOPEN,A.FPARENTID,D.FID DID,C.FID CID,B.FID BID from T_PORTAL_PAGE A,T_PORTAL_PAGE B,T_PORTAL_PAGEDESCRIPTION C,T_PORTAL_TAB D,");
        sqlBuffer.append("T_PORTAL_PAGES E where E.FID='").append(pagsInfo.getId().toString()).append("' and E.FID=A.FPAGESID and ");
        sqlBuffer.append("A.FFROMPAGEID=B.FID and A.FPAGEDESCRIPTIONID=C.FID and A.FTABID=D.FID AND C.FPAGESTATE=").append(20);
        sqlBuffer.append(" and ((C.FCHANGEABLE=1 and A.FMARK IS NULL and B.FLASTUPDATETIME>A.FCOPYTIME) ");
        sqlBuffer.append("or (C.FCHANGEABLE=0 and B.FLASTUPDATETIME>A.FCOPYTIME))");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
        if (rowSet != null) {
            hashMap = new HashMap<String, String[]>();
            set = new HashSet<String>();
            while (rowSet.next()) {
                ids = new String[]{rowSet.getString("AID"), rowSet.getString("FORDERNUM"), rowSet.getString("FISDEFAULTOPEN"), rowSet.getString("CID"), rowSet.getString("DID"), rowSet.getString("FPARENTID")};
                strTemp = rowSet.getString("BID");
                set.add(strTemp);
                hashMap.put(strTemp, ids);
            }
        }
        IPageFacade iPageFacade = PageFacadeFactory.getLocalInstance(ctx);
        iPageFacade.copyPage(set, pagsInfo, hashMap, 1);
    }
}

