/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.portal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.portal.IPortlet;
import com.kingdee.eas.portal.PortletExtInfo;
import com.kingdee.eas.portal.PortletFactory;
import com.kingdee.eas.portal.PortletInfo;
import com.kingdee.eas.portal.app.AbstractPortletForClusterFacadeControllerBean;
import com.kingdee.eas.portal.web.configuration.PortletDefine;
import com.kingdee.eas.portal.web.configuration.PortletDefinitionsFactoryWrapper;
import com.kingdee.eas.portal.web.util.PortalUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class PortletForClusterFacadeControllerBean
extends AbstractPortletForClusterFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.portal.app.PortletForClusterFacadeControllerBean");

    @Override
    protected void _disablePortlet(Context ctx, String portletID) throws BOSException, EASBizException {
        ObjectUuidPK pk;
        IPortlet iPortlet = PortletFactory.getLocalInstance(ctx);
        if (iPortlet.exists((IObjectPK)(pk = new ObjectUuidPK(portletID)))) {
            Object[] param = new String[]{portletID};
            String strSql = "update T_PORTAL_PORTLET set FENABLE = 0 where FID=?";
            DbUtil.execute((Context)ctx, (String)strSql, (Object[])param);
            strSql = "update T_PORTAL_PORTLETPREFERENCES set FENABLE = 0 where FPORTLETID=?";
            DbUtil.execute((Context)ctx, (String)strSql, (Object[])param);
        }
    }

    @Override
    protected List _disablePortlet(Context ctx, List portletIDs) throws BOSException, EASBizException {
        return this.updatePorletStatus(ctx, 0, portletIDs);
    }

    @Override
    protected void _enablePortlet(Context ctx, String portletID) throws EASBizException, BOSException {
        ObjectUuidPK pk;
        IPortlet iPortlet = PortletFactory.getLocalInstance(ctx);
        if (iPortlet.exists((IObjectPK)(pk = new ObjectUuidPK(portletID)))) {
            Object[] param = new String[]{portletID};
            String strSql = "update T_PORTAL_PORTLET set FENABLE = 1 where FID=?";
            DbUtil.execute((Context)ctx, (String)strSql, (Object[])param);
            strSql = "update T_PORTAL_PORTLETPREFERENCES set FENABLE = 1 where FPORTLETID=?";
            DbUtil.execute((Context)ctx, (String)strSql, (Object[])param);
        }
    }

    @Override
    protected List _enablePortlet(Context ctx, List portletIDs) throws BOSException, EASBizException {
        return this.updatePorletStatus(ctx, 1, portletIDs);
    }

    @Override
    protected void _deletePortlet(Context ctx, String portletID) throws BOSException, EASBizException {
        ObjectUuidPK pk;
        IPortlet iPortlet = PortletFactory.getLocalInstance(ctx);
        if (iPortlet.exists((IObjectPK)(pk = new ObjectUuidPK(portletID)))) {
            Object[] param = new String[]{portletID};
            String strSql = "update T_PORTAL_PORTLET set FENABLE = 3 where FID=?";
            DbUtil.execute((Context)ctx, (String)strSql, (Object[])param);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)"select FID,FORDERNUM,FCOLID from T_PORTAL_PORTLETPREFERENCES where FPORTLETID=?", (Object[])param);
            try {
                if (rowSet != null) {
                    while (rowSet.next()) {
                        param = new String[]{rowSet.getString("FID")};
                        DbUtil.execute((Context)ctx, (String)"delete from T_PORTAL_PORTLETPREFERENCES where FID=?", (Object[])param);
                        param = new String[]{rowSet.getString("FORDERNUM"), rowSet.getString("FCOLID")};
                        DbUtil.execute((Context)ctx, (String)"update T_PORTAL_PORTLETPREFERENCES set FORDERNUM=FORDERNUM-1 where FORDERNUM>? and FCOLID=?", (Object[])param);
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void _refreshPortletCache(Context ctx) throws BOSException, EASBizException {
        try {
            PortletDefinitionsFactoryWrapper.refreshPortletDefinitions(ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void _addPortlet(Context ctx, IObjectValue portletinfo) throws BOSException, EASBizException {
        PortletInfo portletInfo = (PortletInfo)portletinfo;
        PortletExtInfo portletExtInfo = portletInfo.getPortletExt();
        if (portletExtInfo != null) {
            PortalUtil.setSuperInfo(ctx, portletExtInfo);
        }
        PortletFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)portletInfo);
    }

    @Override
    protected void _update(Context ctx, BOSUuid portletID, IObjectValue portletinfo) throws BOSException, EASBizException {
        PortletInfo portletInfo = (PortletInfo)portletinfo;
        PortletExtInfo portletExtInfo = portletInfo.getPortletExt();
        if (portletExtInfo != null) {
            if (portletExtInfo.getCreator() == null) {
                PortalUtil.setSuperInfo(ctx, portletExtInfo);
            } else {
                PortalUtil.updateSuperInfo(ctx, portletExtInfo);
            }
        }
        PortletFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(portletID), (CoreBaseInfo)portletInfo);
    }

    private List updatePorletStatus(Context ctx, int status, List portletIDs) throws BOSException, EASBizException {
        if (portletIDs == null || portletIDs.size() <= 0) {
            return null;
        }
        Iterator ite = portletIDs.iterator();
        StringBuffer whereSqlOfPortlet = new StringBuffer();
        StringBuffer whereSqlOfReference = new StringBuffer();
        int index = 0;
        while (ite.hasNext()) {
            String tempPortletIds = ite.next().toString();
            if (index == 0) {
                whereSqlOfReference.append(" FPORTLETID='").append(tempPortletIds).append("' ");
                whereSqlOfPortlet.append(" FID='").append(tempPortletIds).append("' ");
            } else {
                whereSqlOfReference.append(" or FPORTLETID='").append(tempPortletIds).append("' ");
                whereSqlOfPortlet.append(" or FID='").append(tempPortletIds).append("' ");
            }
            ++index;
        }
        StringBuffer updatePortletSql = new StringBuffer();
        updatePortletSql.append("update T_PORTAL_PORTLET set FENABLE =");
        updatePortletSql.append(status).append(" where ");
        updatePortletSql.append(whereSqlOfPortlet);
        StringBuffer updateReferenceSql = new StringBuffer();
        updateReferenceSql.append("update T_PORTAL_PORTLETPREFERENCES set FENABLE =");
        updateReferenceSql.append(status).append(" where ");
        updateReferenceSql.append(whereSqlOfReference);
        DbUtil.execute((Context)ctx, (String)updatePortletSql.toString());
        DbUtil.execute((Context)ctx, (String)updateReferenceSql.toString());
        return null;
    }

    @Override
    protected PortletInfo _getPortlet(Context ctx, String portletId) throws BOSException, EASBizException {
        PortletInfo portletInfo = PortletFactory.getLocalInstance(ctx).getPortletInfo((IObjectPK)new ObjectUuidPK(portletId));
        return portletInfo;
    }

    @Override
    protected String _addPortletReturnId(Context ctx, IObjectValue portletInfo) throws BOSException, EASBizException {
        IObjectPK pk;
        PortletInfo cPortletInfo = (PortletInfo)portletInfo;
        PortletExtInfo portletExtInfo = cPortletInfo.getPortletExt();
        if (portletExtInfo != null) {
            PortalUtil.setSuperInfo(ctx, portletExtInfo);
        }
        return (pk = PortletFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)cPortletInfo)) == null ? "" : pk.toString();
    }

    @Override
    protected PortletDefine _getPortletDefine(Context ctx, String portletDefineId) throws BOSException, EASBizException {
        try {
            return PortletDefinitionsFactoryWrapper.getPortletDefinitionsFactory(ctx).getPortletDefine(portletDefineId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected HashMap _getPortlets(Context ctx) throws BOSException, EASBizException {
        try {
            return PortletDefinitionsFactoryWrapper.getPortletDefinitionsFactory(ctx).getPortlets();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

