/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.portal.web.cache;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import com.kingdee.eas.portal.web.cache.CacheConfig;
import com.kingdee.eas.portal.web.cache.resource.IDirContext;
import com.kingdee.eas.portal.web.cache.resource.ResourceAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;

public class CacheResource {
    private static CacheResource instance = new CacheResource();
    private IDirContext dirContext;
    private Map urlMap = new ConcurrentHashMap();
    private List notFindList = new ArrayList();

    public IDirContext getDirContext() {
        return this.dirContext;
    }

    public void setDirContext(IDirContext dirContext) {
        this.dirContext = dirContext;
    }

    public static CacheResource getInstance() {
        return instance;
    }

    public String getRenderName(String resName) {
        return this.getRenderName(resName, true);
    }

    public String getRenderName(String resName, boolean isGZip) {
        if (resName == null) {
            return "";
        }
        if (!resName.startsWith("/")) {
            resName = "/" + resName;
        }
        if (this.dirContext == null || !this.isCache(resName)) {
            return resName;
        }
        return this.encodeName(resName, isGZip);
    }

    public boolean isCache(String resource) {
        int index = resource.lastIndexOf(".");
        if (index < 0) {
            return false;
        }
        String ext = resource.substring(index);
        return CacheConfig.getInstance().isCacheMime(ext);
    }

    public String decodeName(String urlName) {
        urlName = urlName.replaceFirst("ETAG-[0-9]*-[0-9]*[.]", ".");
        return urlName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String encodeName(String urlName, boolean isGZip) {
        String ename = (String)this.urlMap.get(urlName);
        if (ename == null) {
            if (this.notFindList.contains(urlName)) {
                return urlName;
            }
            try {
                String ext;
                int last = urlName.lastIndexOf(".");
                StringBuffer buf = new StringBuffer();
                String ext0 = urlName.substring(last);
                ename = urlName.substring(0, last);
                ResourceAttributes attr = this.dirContext.getAttributes(urlName);
                if (".gz".equals(ext0)) {
                    last = ename.lastIndexOf(".");
                    ext = ename.substring(last);
                    ename = ename.substring(0, last);
                } else {
                    ext = ext0;
                }
                buf.append(ename).append(attr.getETag()).append(ext0);
                if (CacheConfig.getInstance().isGZMime(ext)) {
                    buf.append(".gz");
                }
                ename = buf.toString();
                Map map = this.urlMap;
                synchronized (map) {
                    this.urlMap.put(urlName, ename);
                }
                return this.getGzipSupportName(ename, isGZip);
            }
            catch (NamingException e) {
                e.printStackTrace();
                List list = this.notFindList;
                synchronized (list) {
                    this.notFindList.add(urlName);
                }
                return urlName;
            }
        }
        return this.getGzipSupportName(ename, isGZip);
    }

    private String getGzipSupportName(String name, boolean isGZipSupport) {
        if (name.endsWith(".gz") && !isGZipSupport) {
            return name.substring(0, name.lastIndexOf("."));
        }
        return name;
    }

    public void reset() {
        this.urlMap.clear();
        this.notFindList.clear();
    }
}

