/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.portal.web.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.cp.common.json.simple.JSONObject;
import com.kingdee.eas.portal.PortletExtInfo;
import com.kingdee.eas.portal.PortletInfo;
import com.kingdee.eas.portal.web.util.PortletUtil;
import java.util.Locale;

public class JsonObjectUtil {
    private static final Integer TRUE = new Integer(1);
    private static final Integer FALSE = new Integer(0);

    private JsonObjectUtil() {
    }

    private static String filterColorValue(String colorValue) {
        if (colorValue == null || colorValue.length() == 0) {
            return "";
        }
        return colorValue;
    }

    public static JSONObject fromPortletExt(Context ctx, PortletExtInfo info) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)"portletExtId", (Object)info.getId().toString());
        jsonObj.put((Object)"showTitleArea", (Object)new Integer(info.getShowTitleArea()));
        jsonObj.put((Object)"title", (Object)info.getTitle(ctx.getLocale()));
        jsonObj.put((Object)"title_en", (Object)info.getTitle(new Locale("L1")));
        jsonObj.put((Object)"title_ch", (Object)info.getTitle(new Locale("L2")));
        jsonObj.put((Object)"title_tw", (Object)info.getTitle(new Locale("L3")));
        jsonObj.put((Object)"titleFontColor", (Object)JsonObjectUtil.filterColorValue(info.getTitleFontColor()));
        jsonObj.put((Object)"titleBoxLeftSuffix", (Object)info.getTitleBoxLeftSuffix());
        jsonObj.put((Object)"titleBoxBgSuffix", (Object)info.getTitleBoxBgSuffix());
        jsonObj.put((Object)"titleBoxRightSuffix", (Object)info.getTitleBoxRightSuffix());
        jsonObj.put((Object)"titleAreaBgSuffix", (Object)info.getTitleAreaBgSuffix());
        jsonObj.put((Object)"titleIconSuffix", (Object)info.getTitleIconSuffix());
        jsonObj.put((Object)"showTitleAreaBorder", (Object)new Integer(info.getShowTitleAreaBorder()));
        jsonObj.put((Object)"titleAreaBorderColor", (Object)JsonObjectUtil.filterColorValue(info.getTitleAreaBorderColor()));
        jsonObj.put((Object)"showContentAreaBorder", (Object)new Integer(info.getShowContentAreaBorder()));
        jsonObj.put((Object)"contentAreaBorderColor", (Object)JsonObjectUtil.filterColorValue(info.getContentAreaBorderColor()));
        jsonObj.put((Object)"contentAreaBgColor", (Object)JsonObjectUtil.filterColorValue(info.getContentAreaBgColor()));
        int portletHeight = info.getHeight();
        if (portletHeight != 0) {
            jsonObj.put((Object)"portletAutoHeight", (Object)FALSE);
            jsonObj.put((Object)"portletHeight", (Object)new Integer(info.getHeight()));
        } else {
            jsonObj.put((Object)"portletAutoHeight", (Object)TRUE);
            jsonObj.put((Object)"portletHeight", (Object)"");
        }
        jsonObj.put((Object)"attrConfigurable", (Object)new Integer(info.getAttrConfigurable()));
        jsonObj.put((Object)"lastModified", (Object)new Long(info.getLastUpdateTime().getTime()));
        return jsonObj;
    }

    public static JSONObject fromPortletExtPartial(PortletExtInfo info) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)"portletExtId", (Object)info.getId().toString());
        jsonObj.put((Object)"titleBoxLeftSuffix", (Object)info.getTitleBoxLeftSuffix());
        jsonObj.put((Object)"titleBoxBgSuffix", (Object)info.getTitleBoxBgSuffix());
        jsonObj.put((Object)"titleBoxRightSuffix", (Object)info.getTitleBoxRightSuffix());
        jsonObj.put((Object)"titleAreaBgSuffix", (Object)info.getTitleAreaBgSuffix());
        jsonObj.put((Object)"titleIconSuffix", (Object)info.getTitleIconSuffix());
        jsonObj.put((Object)"lastModified", (Object)new Long(info.getLastUpdateTime().getTime()));
        return jsonObj;
    }

    public static JSONObject fromPortletForList(Context ctx, PortletInfo info, int currIndex) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)"no", (Object)new Integer(currIndex));
        jsonObj.put((Object)"id", (Object)info.getId().toString());
        jsonObj.put((Object)"number", (Object)info.getPortletNumber());
        jsonObj.put((Object)"name_en", (Object)info.getPortletName(new Locale("l1")));
        jsonObj.put((Object)"name_ch", (Object)info.getPortletName(new Locale("l2")));
        jsonObj.put((Object)"name_tw", (Object)info.getPortletName(new Locale("l3")));
        String flag = info.getFlag() == null ? null : info.getFlag().getValue();
        jsonObj.put((Object)"portletType", (Object)flag);
        jsonObj.put((Object)"enabled", (Object)new Integer(info.getEnable().getValue()));
        jsonObj.put((Object)"description", (Object)info.getDescription(ctx.getLocale()));
        PortletExtInfo portletExtInfo = info.getPortletExt();
        String customizedName = null;
        String hasBizDef = null;
        String portletExtID = null;
        if (portletExtInfo != null) {
            customizedName = portletExtInfo.getTitle(ctx.getLocale());
            hasBizDef = portletExtInfo.getBizDefUrl();
            portletExtID = portletExtInfo.getId().toString();
        }
        jsonObj.put((Object)"customizedName", customizedName);
        jsonObj.put((Object)"hasBizDef", (Object)hasBizDef);
        jsonObj.put((Object)"portletExtID", (Object)portletExtID);
        jsonObj.put((Object)"isCustomized", (Object)PortletUtil.isCustomized(info));
        jsonObj.put((Object)"defineCheck", (Object)(info.getDefineCheck().getValue() + ""));
        jsonObj.put((Object)"runtimeCheck", (Object)(info.getRuntimeCheck().getValue() + ""));
        return jsonObj;
    }
}

