/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.portal.web.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.portal.IPortletFacade;
import com.kingdee.eas.portal.PortletCollection;
import com.kingdee.eas.portal.PortletExtInfo;
import com.kingdee.eas.portal.PortletFacadeFactory;
import com.kingdee.eas.portal.PortletInfo;
import com.kingdee.eas.portal.PortletPrefParameterCollection;
import com.kingdee.eas.portal.PortletPrefParameterInfo;
import com.kingdee.eas.portal.PortletPreferencesInfo;
import com.kingdee.eas.portal.PortletStateEnum;
import com.kingdee.eas.portal.web.configuration.PortletDefinitionsFactoryWrapper;
import com.kingdee.eas.portal.web.control.PortalContextBean;
import com.kingdee.eas.portal.web.util.PortletIndexGenerator;
import com.kingdee.util.StringUtils;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;

public class PortletUtil {
    private static final String GET_PIC_URI = "/portal_public/managePortlet.do?method=getPic";

    private static PortletInfo getPortletById(HttpServletRequest request, String portletId) throws Exception {
        if (portletId == null) {
            return null;
        }
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        return (PortletInfo)PortletDefinitionsFactoryWrapper.getPortletDefinitionsFactory(ctx).getPortlets().get(portletId);
    }

    private static PortletPreferencesInfo getPortletInstanceById(HttpServletRequest request, String portletInstanceId) {
        if (portletInstanceId == null) {
            return null;
        }
        PortalContextBean portalContextBean = (PortalContextBean)request.getSession().getAttribute("com.kingdee.portal.web.control.PORTAL_CONTEXT_BEAN");
        return portalContextBean.getPortletPreferencesInfo(BOSUuid.read((String)portletInstanceId));
    }

    private static String getPortletId(HttpServletRequest request) {
        Object portletIdObjInAttr = request.getAttribute("p_p_id");
        String portletIdInParam = request.getParameter("p_p_id");
        if (portletIdObjInAttr != null) {
            return portletIdObjInAttr.toString();
        }
        if (portletIdInParam != null) {
            return portletIdInParam;
        }
        return null;
    }

    private static String getPortletInstanceId(HttpServletRequest request) {
        Object portletInsIdObjInAttr = request.getAttribute("portal_portlet_instance_id");
        String portletInsIdInParam = request.getParameter("portal_portlet_instance_id");
        if (portletInsIdObjInAttr != null) {
            return portletInsIdObjInAttr.toString();
        }
        if (portletInsIdInParam != null) {
            return portletInsIdInParam;
        }
        Object newInsId = request.getAttribute("new_portal_portlet_instance_id");
        return newInsId == null ? null : newInsId.toString();
    }

    private static PortletInfo getPortlet(HttpServletRequest request) throws Exception {
        String portletId = PortletUtil.getPortletId(request);
        return PortletUtil.getPortletById(request, portletId);
    }

    private static PortletExtInfo getPortletExt(HttpServletRequest request) throws Exception {
        PortletInfo portlet = PortletUtil.getPortlet(request);
        if (portlet == null) {
            return null;
        }
        return portlet.getPortletExt();
    }

    private static PortletPreferencesInfo getPortletInstance(HttpServletRequest request) {
        String portletInstanceId = PortletUtil.getPortletInstanceId(request);
        return PortletUtil.getPortletInstanceById(request, portletInstanceId);
    }

    private static String getPicUri(HttpServletRequest request, int picType) throws Exception {
        PortletInfo portlet = PortletUtil.getPortlet(request);
        if (portlet == null) {
            return null;
        }
        PortletExtInfo portletExt = portlet.getPortletExt();
        String suffix = null;
        switch (picType) {
            case 0: {
                if (portletExt != null && (suffix = portletExt.getTitleBoxLeftSuffix()) != null) break;
                return WebContextUtil.renderSkin((HttpServletRequest)request, (String)"/image/portlet/portlet_title_left.gif");
            }
            case 1: {
                if (portletExt != null && (suffix = portletExt.getTitleBoxBgSuffix()) != null) break;
                return WebContextUtil.renderSkin((HttpServletRequest)request, (String)"/image/portlet/portlet_title_fill.gif");
            }
            case 2: {
                if (portletExt != null && (suffix = portletExt.getTitleBoxRightSuffix()) != null) break;
                return WebContextUtil.renderSkin((HttpServletRequest)request, (String)"/image/portlet/portlet_title_right.gif");
            }
            case 3: {
                if (portletExt != null && (suffix = portletExt.getTitleAreaBgSuffix()) != null) break;
                return WebContextUtil.renderSkin((HttpServletRequest)request, (String)"/image/portlet/portlet_title_bg.gif");
            }
            case 4: {
                if (portletExt != null && (suffix = portletExt.getTitleIconSuffix()) != null) break;
                return null;
            }
            default: {
                return null;
            }
        }
        String portalContextPath = WebContextUtil.getPortalContextPath((HttpServletRequest)request);
        StringBuffer picUriSb = new StringBuffer(portalContextPath);
        picUriSb.append(GET_PIC_URI).append("&portletExtId=").append(portletExt.getId().toString()).append("&picType=").append(picType).append("&suffix=").append(suffix).append("&lastModified=").append(portletExt.getLastUpdateTime().getTime());
        return picUriSb.toString();
    }

    private static String getPortletString(HttpServletRequest request, String property) throws Exception {
        PortletInfo portlet = PortletUtil.getPortlet(request);
        if (portlet == null) {
            return null;
        }
        if (property.equals("id")) {
            return portlet.getId().toString();
        }
        if (property.equals("configId")) {
            return portlet.getPortletDefineId();
        }
        if (property.equals("number")) {
            return portlet.getPortletNumber();
        }
        if (property.equals("name")) {
            return portlet.getPortletName();
        }
        if (property.equals("description")) {
            return portlet.getDescription();
        }
        if (property.equals("type")) {
            return portlet.getFlag().getValue();
        }
        PortletExtInfo portletExt = portlet.getPortletExt();
        if (portletExt == null) {
            return null;
        }
        if (property.equals("customizedName")) {
            return portletExt.getTitle();
        }
        if (property.equals("titleFontColor")) {
            return portletExt.getTitleFontColor();
        }
        if (property.equals("titleAreaBorderColor")) {
            return portletExt.getTitleAreaBorderColor();
        }
        if (property.equals("contentAreaBorderColor")) {
            return portletExt.getContentAreaBorderColor();
        }
        if (property.equals("contentAreaBgColor")) {
            return portletExt.getContentAreaBgColor();
        }
        return null;
    }

    private static boolean getPortletBoolean(HttpServletRequest request, String property) throws Exception {
        PortletInfo portlet = PortletUtil.getPortlet(request);
        if (portlet == null) {
            return false;
        }
        if (property.equals("enabled") && portlet.getEnable().equals((Object)PortletStateEnum.PORTLET_RUN)) {
            return true;
        }
        PortletExtInfo portletExt = portlet.getPortletExt();
        if (portletExt == null) {
            return false;
        }
        if (property.equals("showTitleArea")) {
            return PortletUtil.int2bool(portletExt.getShowTitleArea());
        }
        if (property.equals("showTitleAreaBorder")) {
            return PortletUtil.int2bool(portletExt.getShowTitleAreaBorder());
        }
        if (property.equals("showContentAreaBorder")) {
            return PortletUtil.int2bool(portletExt.getShowContentAreaBorder());
        }
        if (property.equals("attrConfigurable")) {
            return PortletUtil.int2bool(portletExt.getAttrConfigurable());
        }
        return false;
    }

    private static boolean int2bool(int intValue) {
        return intValue == 1;
    }

    public static String getId(HttpServletRequest request) throws Exception {
        return PortletUtil.getPortletString(request, "id");
    }

    public static String getConfigId(HttpServletRequest request) throws Exception {
        return PortletUtil.getPortletString(request, "configId");
    }

    public static String getNumber(HttpServletRequest request) throws Exception {
        return PortletUtil.getPortletString(request, "number");
    }

    public static String getName(HttpServletRequest request) throws Exception {
        return PortletUtil.getPortletString(request, "name");
    }

    public static boolean isEnabled(HttpServletRequest request) throws Exception {
        return PortletUtil.getPortletBoolean(request, "enabled");
    }

    public static String getDescription(HttpServletRequest request) throws Exception {
        return PortletUtil.getPortletString(request, "description");
    }

    public static String getType(HttpServletRequest request) throws Exception {
        return PortletUtil.getPortletString(request, "type");
    }

    public static boolean isCustomized(PortletInfo portlet) {
        if (portlet == null) {
            return false;
        }
        PortletExtInfo portletExt = portlet.getPortletExt();
        if (portletExt == null) {
            return false;
        }
        return !StringUtils.isEmpty((String)portletExt.getContentAreaBgColor());
    }

    public static boolean isCustomized(HttpServletRequest request) throws Exception {
        return PortletUtil.isCustomized(PortletUtil.getPortlet(request));
    }

    public static boolean showTitleArea(HttpServletRequest request) throws Exception {
        return PortletUtil.getPortletBoolean(request, "showTitleArea");
    }

    public static String getCustomizedName(HttpServletRequest request) throws Exception {
        return PortletUtil.getPortletString(request, "customizedName");
    }

    public static String getTitleFontColor(HttpServletRequest request) throws Exception {
        return PortletUtil.getPortletString(request, "titleFontColor");
    }

    public static String getTitleBoxLeftUri(HttpServletRequest request) throws Exception {
        return PortletUtil.getPicUri(request, 0);
    }

    public static String getTitleBoxBgUri(HttpServletRequest request) throws Exception {
        return PortletUtil.getPicUri(request, 1);
    }

    public static String getTitleBoxRightUri(HttpServletRequest request) throws Exception {
        return PortletUtil.getPicUri(request, 2);
    }

    public static String getTitleAreaBgUri(HttpServletRequest request) throws Exception {
        return PortletUtil.getPicUri(request, 3);
    }

    public static String getTitleIconUri(HttpServletRequest request) throws Exception {
        return PortletUtil.getPicUri(request, 4);
    }

    public static boolean showTitleAreaBorder(HttpServletRequest request) throws Exception {
        return PortletUtil.getPortletBoolean(request, "showTitleAreaBorder");
    }

    public static String getTitleAreaBorderColor(HttpServletRequest request) throws Exception {
        return PortletUtil.getPortletString(request, "titleAreaBorderColor");
    }

    public static boolean showContentAreaBorder(HttpServletRequest request) throws Exception {
        return PortletUtil.getPortletBoolean(request, "showContentAreaBorder");
    }

    public static String getContentAreaBorderColor(HttpServletRequest request) throws Exception {
        return PortletUtil.getPortletString(request, "contentAreaBorderColor");
    }

    public static String getContentAreaBgColor(HttpServletRequest request) throws Exception {
        return PortletUtil.getPortletString(request, "contentAreaBgColor");
    }

    public static int getDefHeight(HttpServletRequest request) throws Exception {
        PortletExtInfo portletExt = PortletUtil.getPortletExt(request);
        if (portletExt == null) {
            return 0;
        }
        return portletExt.getHeight();
    }

    public static boolean isAttrConfigurable(HttpServletRequest request) throws Exception {
        return PortletUtil.getPortletBoolean(request, "attrConfigurable");
    }

    public static String getInsId(HttpServletRequest request) throws Exception {
        return PortletUtil.getPortletInstanceId(request);
    }

    public static int getInsHeight(HttpServletRequest request) {
        PortletPreferencesInfo portletInstance = PortletUtil.getPortletInstance(request);
        if (portletInstance == null) {
            return 0;
        }
        PortletPrefParameterCollection params = portletInstance.getParams();
        if (params.size() == 0) {
            return 0;
        }
        int insHeight = 0;
        Iterator paramsIt = params.iterator();
        while (paramsIt.hasNext()) {
            PortletPrefParameterInfo param = (PortletPrefParameterInfo)paramsIt.next();
            if (!param.getParamName().equals("height")) continue;
            String insHeightStr = param.getParamValue();
            insHeight = Integer.parseInt(insHeightStr);
        }
        return insHeight;
    }

    public static String getPageId(HttpServletRequest request) {
        Object pageIdObjInAttr = request.getAttribute("p_l_id");
        String pageIdInParam = request.getParameter("p_l_id");
        if (pageIdObjInAttr != null) {
            return pageIdObjInAttr.toString();
        }
        if (pageIdInParam != null) {
            return pageIdInParam;
        }
        return null;
    }

    public static String getPortalContextPath(HttpServletRequest request) {
        return WebContextUtil.getPortalContextPath((HttpServletRequest)request);
    }

    public static String getFingerprint(HttpServletRequest request) {
        String portletInstanceId = PortletUtil.getPortletInstanceId(request);
        if (portletInstanceId == null) {
            return null;
        }
        return PortletIndexGenerator.next(request, portletInstanceId);
    }

    public static PortletCollection getUserAllRuntimePortlet(HttpServletRequest request) throws EASBizException, BOSException {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        IPortletFacade facade = PortletFacadeFactory.getRemoteInstance();
        PortletCollection portletCollection = (PortletCollection)facade.getPermissionPortlet4Runtime();
        return portletCollection;
    }

    public static boolean canShow4RuntimePortlet(HttpServletRequest request, String currentPortletId) {
        PortletCollection runtimePortlets4CurrentUser = (PortletCollection)((Object)request.getSession().getAttribute("com.kingdee.portal.web.control.RUNTIME_PORTLETS_FOR_CURRENT_USER"));
        if (runtimePortlets4CurrentUser != null) {
            for (int i = 0; i < runtimePortlets4CurrentUser.size(); ++i) {
                PortletInfo portlet = runtimePortlets4CurrentUser.get(i);
                if (!portlet.getId().toString().equals(currentPortletId)) continue;
                return true;
            }
        }
        return false;
    }
}

