/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.formula.kscript.debug.ui;

import com.kingdee.bos.formula.kscript.debug.ui.DebugUI;
import com.kingdee.bos.formula.kscript.debug.ui.FormulaDebugTool;
import com.kingdee.bos.formula.kscript.debug.ui.JFontChooser;
import com.kingdee.bos.kscript.parser.Source;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashSet;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class DefaultEditMenu
implements ActionListener {
    public static final String COPY_ALL = "Copy All";
    public static final String CUT = "Cut";
    public static final String PASTE = "Paste";
    public static final String DELETE = "Delete";
    public static final String COPY_SELECTED = "Copy Selected";
    public static final String CLEAR = "Clear";
    public static final String LOAD = "Load...";
    public static final String SAVE = "Save...";
    public static final String FONT = "Font...";
    public boolean supportLoadSave = false;
    public JTextComponent source;
    public boolean isEditable;
    public String type;
    private HashSet disableActions = new HashSet();

    public DefaultEditMenu(String type, JTextComponent source, boolean isEditable) {
        this.type = "editmenu." + type;
        this.isEditable = isEditable;
        this.source = source;
        source.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3) {
                    DefaultEditMenu.this.tracePopupMenu(e);
                }
            }
        });
        try {
            Font font = DebugUI.props.getFont(type + ".font");
            if (font != null) {
                source.setFont(font);
            }
        }
        catch (Exception _) {
            _.printStackTrace();
        }
    }

    public void setActionEnabled(String action, boolean enabled) {
        if (enabled) {
            this.disableActions.remove(action);
        } else {
            this.disableActions.add(action);
        }
    }

    public static void setClipboardText(String s) {
        if (s == null || s.length() == 0) {
            return;
        }
        StringSelection sel = new StringSelection(s);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(sel, sel);
    }

    public static String getClipboardText() {
        return null;
    }

    public boolean isActionEnabled(String action) {
        if (this.disableActions.contains(action)) {
            return false;
        }
        if (action.equals(FONT)) {
            return false;
        }
        Document doc = this.source.getDocument();
        if (action.equals(COPY_ALL) || action.equals(CLEAR)) {
            return doc.getLength() > 0;
        }
        int start = this.source.getSelectionStart();
        int end = this.source.getSelectionEnd();
        if (action.equals(COPY_SELECTED)) {
            return start >= 0 && end > start;
        }
        if (action.equals(CUT) || action.equals(DELETE)) {
            return this.isEditable && start >= 0 && end > start;
        }
        if (action.equals(PASTE)) {
            return this.isEditable && DefaultEditMenu.getClipboardText() != null;
        }
        if (action.equals(LOAD)) {
            return this.supportLoadSave;
        }
        if (action.equals(SAVE)) {
            return this.supportLoadSave && doc.getLength() > 0;
        }
        return this.isExtandActionEnabled(action);
    }

    protected boolean isExtandActionEnabled(String action) {
        return false;
    }

    public void tracePopupMenu(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu("Actions");
        this.buildActionMenu(menu);
        menu.show(this.source, e.getX(), e.getY());
    }

    public void addAction(JPopupMenu menu, String action) {
        JMenuItem m = menu.add(action);
        m.addActionListener(this);
        m.setEnabled(this.isActionEnabled(action));
    }

    protected void buildActionMenu(JPopupMenu menu) {
        this.addAction(menu, COPY_ALL);
        this.addAction(menu, COPY_SELECTED);
        this.addAction(menu, CUT);
        this.addAction(menu, PASTE);
        this.addAction(menu, DELETE);
        this.addAction(menu, CLEAR);
        menu.addSeparator();
        this.addAction(menu, FONT);
        if (this.supportLoadSave) {
            menu.addSeparator();
            this.addAction(menu, LOAD);
            this.addAction(menu, SAVE);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            String action = e.getActionCommand();
            if (!this.isActionEnabled(action)) {
                return;
            }
            int start = this.source.getSelectionStart();
            int end = this.source.getSelectionEnd();
            if (action.equals(COPY_ALL)) {
                DefaultEditMenu.setClipboardText(this.source.getText());
            } else if (action.equals(COPY_SELECTED)) {
                DefaultEditMenu.setClipboardText(this.source.getSelectedText());
            } else if (action.equals(CUT)) {
                DefaultEditMenu.setClipboardText(this.source.getSelectedText());
                this.source.getDocument().remove(start, end - start);
            } else if (action.equals(PASTE)) {
                String text = DefaultEditMenu.getClipboardText();
                if (text != null) {
                    if (start >= 0 && end > start) {
                        this.source.getDocument().remove(start, end - start);
                    }
                    this.source.getDocument().insertString(start, text, null);
                }
            } else if (action.equals(DELETE)) {
                this.source.getDocument().remove(start, end - start);
            } else if (action.equals(CLEAR)) {
                this.source.getDocument().remove(0, this.source.getDocument().getLength());
            } else if (action.equals(LOAD)) {
                this.load();
            } else if (action.equals(SAVE)) {
                this.save();
            } else if (action.equals(FONT)) {
                this.changeFont();
            } else {
                this.extandActionPerformed(e);
            }
        }
        catch (Exception ex) {
            FormulaDebugTool.getDebugUI().handleException(ex);
        }
    }

    protected void load() throws Exception {
        File f = DebugUI.props.selectFile("scriptfile", "load a kscript file");
        if (f == null) {
            return;
        }
        Source s = new Source(f);
        this.source.setText(s.getText());
        this.fileLoaded(f);
    }

    protected void changeFont() throws Exception {
        Font f = JFontChooser.chooseFont(FormulaDebugTool.getDebugUI(), this.source.getFont());
    }

    protected void save() throws Exception {
        File f = DebugUI.props.selectFile("scriptfile", "save script file");
        if (f == null) {
            return;
        }
        try (FileOutputStream out = new FileOutputStream(f);){
            out.write(this.source.getText().getBytes());
        }
        this.fileSaved(f);
    }

    protected void extandActionPerformed(ActionEvent e) {
    }

    protected void fileLoaded(File file) {
    }

    protected void fileSaved(File file) {
    }
}

