/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.formula.api;

import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class FormulaOperator {
    private static String HEAD = "//bizenum";
    private static String PK = "package";
    private static String NAME = "name";

    public static Vector getEnumsVector(String formulaStr) {
        Vector<BizEnumInfo> ret = new Vector<BizEnumInfo>();
        LineNumberReader lnr = new LineNumberReader(new StringReader(formulaStr));
        String line = null;
        try {
            line = lnr.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        while (line != null) {
            int pos = line.indexOf(HEAD);
            if (pos > -1) {
                String newLine = line.substring(pos);
                StringTokenizer st = new StringTokenizer(newLine, "|");
                String pk = "";
                String name = "";
                while (st.hasMoreTokens()) {
                    int index;
                    String temp = st.nextToken();
                    String left = temp.substring(0, index = temp.indexOf("="));
                    if (left != null && left.equals("//bizenum:package")) {
                        pk = temp.substring(index + 1);
                        continue;
                    }
                    if (left == null || !left.equals("name")) continue;
                    name = temp.substring(index + 1);
                }
                IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
                MetaDataPK mdpk = new MetaDataPK(pk, name);
                BizEnumInfo bizenum = (BizEnumInfo)loader.get(MetaDataTypeList.BIZENUM, (IMetaDataPK)mdpk);
                ret.add(bizenum);
            }
            try {
                line = null;
                line = lnr.readLine();
            }
            catch (IOException iOException) {}
        }
        return ret;
    }

    public static String getEnumsString(Vector enumVec) {
        StringBuffer sb = new StringBuffer("");
        int size = enumVec.size();
        for (int i = 0; i < size; ++i) {
            BizEnumInfo bizenum = (BizEnumInfo)enumVec.get(i);
            String pk = bizenum.getPackage();
            String name = bizenum.getName();
            sb.append(HEAD).append(":");
            sb.append(PK).append("=");
            sb.append(pk).append("|");
            sb.append(NAME).append("=");
            sb.append(name).append("\n");
        }
        return sb.toString();
    }

    public static String getDisplayString(String formulaStr) {
        StringBuffer sb = new StringBuffer("");
        LineNumberReader lnr = new LineNumberReader(new StringReader(formulaStr));
        String line = null;
        try {
            line = lnr.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        while (line != null) {
            int epos = line.indexOf(HEAD);
            int vpos = line.indexOf("//{bos_formula_comments_var");
            if (epos < 0 && vpos < 0) {
                int index = line.indexOf("return formula_result;");
                if (index > -1) {
                    line = line.substring(0, index);
                }
                if (line != null && !line.equals("")) {
                    sb.append(line).append("\n");
                }
            }
            try {
                line = null;
                line = lnr.readLine();
            }
            catch (IOException iOException) {}
        }
        return sb.toString();
    }
}

