/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.service.formula.builder;

import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.service.formula.builder.AddDelLineButton;
import com.kingdee.bos.service.formula.builder.FormulaBuilderPanelBean;
import com.kingdee.bos.service.formula.builder.FormulaEleComponent;
import com.kingdee.bos.service.formula.builder.FormulaEleGapComponent;
import com.kingdee.bos.service.formula.builder.FormulaEleInfo;
import com.kingdee.bos.service.formula.builder.FormulaLineIndentComponent;
import com.kingdee.bos.service.formula.builder.FormulaPanel;
import com.kingdee.bos.service.formula.builder.TableVarInfo;
import com.kingdee.bos.service.formula.builder.VarSelectDlg;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

class FormulaLinePanel
extends KDPanel {
    public static int LINEWIDTH = 25;
    int index;
    private AddDelLineButton delBtn;
    Vector formulaEleComponents = new Vector();
    private FormulaPanel formulaPane;
    FormulaLineIndentComponent indentComponent = new FormulaLineIndentComponent(0);

    public FormulaLinePanel(FormulaPanel formulaPane, int idx) {
        this.formulaPane = formulaPane;
        this.index = idx;
        FlowLayout fl = new FlowLayout();
        fl.setHgap(0);
        fl.setVgap(0);
        this.setLayout(fl);
        this.setBorder(null);
        this.setBackground(FormulaPanel.CENTER_BGCOLOR);
        this.delBtn = new AddDelLineButton(AddDelLineButton.LINEDEL, formulaPane, idx);
        this.add((Component)((Object)this.delBtn));
        this.setOpaque(true);
        FormulaEleGapComponent gapComponent = new FormulaEleGapComponent(0, this);
        this.add(gapComponent);
    }

    public Dimension getPreferredSize() {
        return new Dimension(super.getPreferredSize().width, LINEWIDTH);
    }

    public void setIndex(int idx) {
        this.index = idx;
        this.delBtn.setIndex(idx);
    }

    private void innerDealVar(FormulaEleComponent eleComponent) {
        FormulaEleInfo eleInfo = eleComponent.getEleInfo();
        if (eleInfo.getEleType() == 4) {
            TableVarInfo varInfo = null;
            varInfo = FormulaBuilderPanelBean.This.getVarTableModel().addVar(eleInfo.getVarInfo());
            FormulaBuilderPanelBean.This.getVarTableModel().fireTableDataChanged();
            eleComponent.getEleInfo().setVarInfo(varInfo);
        }
    }

    public boolean addEle(int idx, FormulaEleComponent eleComponent, boolean needReDisp) {
        if (eleComponent.isValid()) {
            if (eleComponent.eleInfo.getEleType() == 20) {
                return false;
            }
            this.innerDealVar(eleComponent);
            if (idx == -1) {
                idx = this.formulaEleComponents.size();
            }
            this.formulaEleComponents.add(idx, eleComponent);
            eleComponent.setParent(this);
            if (needReDisp) {
                this.reDisp();
                if (eleComponent.getEleInfo().getEleType() == 14 || eleComponent.getEleInfo().getEleType() == 17) {
                    this.formulaPane.reIndentLines();
                }
            }
            return true;
        }
        return false;
    }

    public boolean delEle(int idx, boolean needReDisp) {
        if (idx < 0 || idx > this.formulaEleComponents.size() - 1) {
            return false;
        }
        FormulaEleComponent delEleComponent = (FormulaEleComponent)this.formulaEleComponents.get(idx);
        long groupId = delEleComponent.getEleInfo().getGroupId();
        if (groupId > 0L) {
            int i;
            int beginDelIdx = -1;
            int endDelIdx = -1;
            for (i = 0; i < this.formulaEleComponents.size(); ++i) {
                FormulaEleComponent currEleComponent = (FormulaEleComponent)this.formulaEleComponents.get(i);
                if (currEleComponent.getEleInfo().getGroupId() != groupId) continue;
                if (beginDelIdx == -1) {
                    beginDelIdx = i;
                }
                endDelIdx = i;
            }
            if (beginDelIdx >= 0 && endDelIdx >= 0) {
                for (i = beginDelIdx; i <= endDelIdx; ++i) {
                    this.formulaEleComponents.remove(beginDelIdx);
                }
            }
        } else {
            this.formulaEleComponents.remove(idx);
        }
        if (needReDisp) {
            this.reDisp();
            if (delEleComponent.getEleInfo().getEleType() == 14 || delEleComponent.getEleInfo().getEleType() == 17) {
                this.formulaPane.reIndentLines();
            }
        }
        return true;
    }

    public boolean removeEle(FormulaEleComponent eleComponent, boolean needReDisp) {
        int idx = this.formulaEleComponents.indexOf(eleComponent);
        if (idx > -1) {
            return this.delEle(idx, needReDisp);
        }
        return false;
    }

    public void reDisp() {
        for (int i = this.getComponentCount() - 1; i >= 1; --i) {
            this.remove(i);
        }
        int indentCnt = this.formulaPane.calcIndent(this.index);
        this.indentComponent.setIndentCnt(indentCnt);
        this.add((Component)((Object)this.indentComponent));
        FormulaEleGapComponent lastGapComponent = null;
        FormulaEleGapComponent gapComponent = new FormulaEleGapComponent(0, this);
        this.add(gapComponent);
        if (this.formulaEleComponents.size() < 1) {
            lastGapComponent = gapComponent;
        }
        for (int i = 0; i < this.formulaEleComponents.size(); ++i) {
            FormulaEleComponent eleComponent = (FormulaEleComponent)this.formulaEleComponents.get(i);
            this.add(eleComponent.getComponent());
            boolean needAddGap = true;
            if (!eleComponent.getEleInfo().isNeedAddGap()) continue;
            gapComponent = new FormulaEleGapComponent(i + 1, this);
            this.add(gapComponent);
            if (i != this.formulaEleComponents.size() - 1) continue;
            lastGapComponent = gapComponent;
        }
        if (lastGapComponent != null) {
            lastGapComponent.setLineLast(true);
        }
        this.revalidate();
    }

    public void changeAliasDisp() {
        for (int i = 0; i < this.formulaEleComponents.size(); ++i) {
            ((FormulaEleComponent)this.formulaEleComponents.get(i)).changeAliasDisp();
        }
    }

    public String genFormulaStr() {
        if (this.formulaEleComponents.size() == 0) {
            return null;
        }
        String expLine = "";
        boolean needAddSemi = true;
        for (int i = 0; i < this.formulaEleComponents.size(); ++i) {
            FormulaEleComponent fEleComponent = (FormulaEleComponent)this.formulaEleComponents.get(i);
            String eleStr = fEleComponent.genFormulaStr();
            if (fEleComponent.getEleInfo().getEleType() == 14) {
                if (FormulaEleInfo.BAS_LOGICEXP_TYPES_STRS.get(2).equals(eleStr)) {
                    if (i == this.formulaEleComponents.size() - 1) {
                        needAddSemi = false;
                    }
                } else {
                    needAddSemi = false;
                }
            }
            if (fEleComponent.getEleInfo().getEleType() == 17) {
                if (FormulaEleInfo.BAS_BBRACKET_TYPES_STRS.get(0).equals(eleStr)) {
                    if (i == this.formulaEleComponents.size() - 1) {
                        needAddSemi = false;
                    }
                } else {
                    if (i == this.formulaEleComponents.size() - 1) {
                        needAddSemi = false;
                    }
                    if (i >= 1) {
                        expLine = expLine + ";";
                    }
                }
            } else if (fEleComponent.getEleInfo().getEleType() == 5 && fEleComponent.getEleInfo().isLeafProp) {
                eleStr = eleStr + "\"";
            }
            if (eleStr != null) {
                expLine = expLine + eleStr;
            }
            if (i < 0 || i >= this.formulaEleComponents.size() - 1 || !fEleComponent.getEleInfo().isNeedAddGap()) continue;
            expLine = expLine + " ";
        }
        if (needAddSemi) {
            expLine = expLine + ";";
        }
        return expLine;
    }

    public String genFormulaAliasStr() {
        StringBuffer aliasStrBuffer = new StringBuffer();
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (component instanceof KDLabel && !(component instanceof FormulaEleGapComponent) && !(component instanceof FormulaLineIndentComponent)) {
                aliasStrBuffer.append(((KDLabel)component).getText());
                continue;
            }
            if (component instanceof KDTextField) {
                aliasStrBuffer.append(((KDTextField)component).getText());
                continue;
            }
            if (aliasStrBuffer.toString().equals("") || i >= this.getComponentCount() - 1) continue;
            aliasStrBuffer.append(" ");
        }
        return aliasStrBuffer.toString();
    }

    public void setIndentCnt(int cnt) {
        this.indentComponent.setIndentCnt(cnt);
        this.revalidate();
    }

    public Vector getAllEleComponents() {
        return this.formulaEleComponents;
    }

    public void addSelectedEle(int idx) {
        block14: {
            block15: {
                block13: {
                    if (FormulaEleInfo.getSelectedEle() == null) {
                        return;
                    }
                    if (!(FormulaEleInfo.getSelectedEle() instanceof FormulaEleInfo)) break block13;
                    FormulaEleInfo selectedEle = ((FormulaEleInfo)FormulaEleInfo.getSelectedEle()).cloneMe();
                    if (selectedEle.getEleType() == 20) {
                        return;
                    }
                    FormulaEleComponent newEleComponent = new FormulaEleComponent(selectedEle);
                    this.addEle(idx, newEleComponent, true);
                    if (selectedEle.getEleType() == 14 && !selectedEle.getSimpleStr().equals(FormulaEleInfo.BAS_LOGICEXP_TYPES_STRS.get(2))) {
                        selectedEle.setNeedAddGap(false);
                        FormulaEleInfo newEle = FormulaEleInfo.createBaseEle((String)FormulaEleInfo.BAS_SBRACKET_TYPES_STRS.get(0));
                        this.addEle(idx < 0 ? idx : idx + 1, new FormulaEleComponent(newEle), true);
                        newEle = FormulaEleInfo.createBaseEle((String)FormulaEleInfo.BAS_SBRACKET_TYPES_STRS.get(1));
                        newEle.setNeedAddGap(false);
                        this.addEle(idx < 0 ? idx : idx + 2, new FormulaEleComponent(newEle), true);
                    }
                    newEleComponent.afterAddToContainer();
                    break block14;
                }
                if (!(FormulaEleInfo.getSelectedEle() instanceof Vector)) break block15;
                Vector objEles = FormulaEleInfo.cloneMultiEles();
                for (int i = 0; i < objEles.size(); ++i) {
                    TableVarInfo varInfo;
                    FormulaEleInfo currEle = ((FormulaEleInfo)objEles.get(i)).cloneMe();
                    if (currEle.getEleType() == 4 && (varInfo = currEle.getVarInfo()).getCreatedWay() == 4) {
                        varInfo.setCreatedWay(5);
                        if (FormulaBuilderPanelBean.This.getVarTableModel().getVarInfoByType(varInfo.getVarType()) != null) {
                            if (!FormulaBuilderPanelBean.This.isAlwaysRefOldVar()) {
                                TableVarInfo selectVarInfo = VarSelectDlg.showSelectDlg(FormulaBuilderPanelBean.This.getVarTableModel(), varInfo);
                                if (selectVarInfo == null) {
                                    return;
                                }
                                if (selectVarInfo != varInfo) {
                                    TableVarInfo tmpVarInfo = new TableVarInfo(selectVarInfo);
                                    tmpVarInfo.setCreatedWay(1);
                                    currEle.setVarInfo(tmpVarInfo);
                                }
                            } else {
                                TableVarInfo tmpVarInfo = new TableVarInfo(FormulaBuilderPanelBean.This.getVarTableModel().getVarInfoByType(varInfo.getVarType()));
                                tmpVarInfo.setCreatedWay(3);
                                currEle.setVarInfo(tmpVarInfo);
                            }
                        }
                    }
                    FormulaEleComponent newFec = new FormulaEleComponent(currEle);
                    this.addEle(idx < 0 ? idx : idx++, newFec, true);
                }
                break block14;
            }
            if (!(FormulaEleInfo.getSelectedEle() instanceof List)) break block14;
            ArrayList objEles = (ArrayList)FormulaEleInfo.getSelectedEle();
            for (int i = 0; i < objEles.size(); ++i) {
                FormulaEleInfo currEle = ((FormulaEleInfo)objEles.get(i)).cloneMe();
                if (i == 0) {
                    currEle.genFormulaStr();
                }
                if (currEle.getEleType() == 5 || currEle.getEleType() == 6) {
                    // empty if block
                }
                FormulaEleComponent newFec = new FormulaEleComponent(currEle);
                this.addEle(idx < 0 ? idx : idx++, newFec, true);
            }
        }
    }

    public boolean isEmpty() {
        return this.formulaEleComponents.size() < 1;
    }
}

