/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.dingtalk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.lightapp.dingtalk.DingtalkAPIInvokeUtil;
import com.kingdee.lightapp.pa.IMessagePusher;
import com.kingdee.lightapp.pa.api.IMessageAdapter;
import com.kingdee.lightapp.util.TransferUserIdToXtIdUtil;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DingtalkMessagePusher
implements IMessagePusher {
    private final Logger logger = Logger.getLogger(DingtalkMessagePusher.class);
    private String messageType;

    public DingtalkMessagePusher(String messageType) {
        this.messageType = messageType;
    }

    @Override
    public Map<String, Object> pushMessage(Context ctx, List<IMessageAdapter> messageList) {
        String dbCode = ctx.getAIS();
        String eid = XTServiceConfig.getInstance().getEidByDbCode(dbCode);
        String appKey = XTServiceConfig.getInstance().getDingtalkAppKey(eid);
        for (IMessageAdapter adapter : messageList) {
            String msgStr = this.createDingTalkMsg(ctx, eid, appKey, adapter);
            this.logger.error((Object)("DingtalkMessage=====" + msgStr));
            if (StringUtils.isEmpty((String)msgStr)) continue;
            String pushResult = "";
            String assignid = (String)adapter.getContent().get("assignId");
            String userId = (String)adapter.getContent().get("receiver");
            try {
                pushResult = DingtalkAPIInvokeUtil.pushTodoMessage(msgStr, appKey);
                this.savePushedMsg(ctx, 1, assignid, userId, null, pushResult);
                this.logger.error((Object)("DingtalkMessage==push==re=" + pushResult));
            }
            catch (Exception e) {
                this.logger.error((Object)e);
                this.insertEror(ctx, assignid, userId, "0", e.getMessage());
            }
        }
        return null;
    }

    @Override
    public Map<String, Object> pushNoitceMessage(Context ctx, List<IMessageAdapter> messageList) {
        String dbCode = ctx.getAIS();
        String eid = XTServiceConfig.getInstance().getEidByDbCode(dbCode);
        String appKey = XTServiceConfig.getInstance().getDingtalkAppKey(eid);
        for (IMessageAdapter adapter : messageList) {
            String msgStr = this.createDingTalkNoitceMsg(ctx, eid, appKey, adapter);
            this.logger.error((Object)("DingtalkMessage=====" + msgStr));
            if (StringUtils.isEmpty((String)msgStr)) continue;
            String pushResult = "";
            String assignid = (String)adapter.getContent().get("assignId");
            String userId = (String)adapter.getContent().get("receiver");
            try {
                pushResult = DingtalkAPIInvokeUtil.pushNoticeMessage(msgStr, appKey);
                String procinstid = (String)adapter.getContent().get("procinstid");
                this.savePushedMsg(ctx, 2, assignid, userId, procinstid, pushResult);
                this.logger.error((Object)("DingtalkMessage==push==re=" + pushResult));
            }
            catch (Exception e) {
                this.logger.error((Object)e);
                this.insertEror(ctx, assignid, userId, "0", e.getMessage());
            }
        }
        return null;
    }

    private void savePushedMsg(Context ctx, int type, String assignid, String userid, String procinstid, String pushResult) {
        String sourceID;
        JSONObject pushResultObject = JSON.parseObject((String)pushResult);
        int errcode = pushResultObject.getIntValue("errcode");
        String errmsg = pushResultObject.getString("errmsg");
        String string = sourceID = type == 1 ? pushResultObject.getString("record_id") : pushResultObject.get((Object)"task_id") + "";
        if (errcode == 0 && ("ok".equals(errmsg) || StringUtils.isEmpty((String)errmsg))) {
            try {
                String sql = " insert into t_assign_dtmsg(msgid,fassignid,fuserid,procinstid,msgtype) values(?,?,?,?,?)";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{sourceID, assignid, userid, procinstid, type});
            }
            catch (BOSException e) {
                this.logger.error((Object)e);
                this.insertEror(ctx, assignid, userid, errcode + "", errmsg + "~" + e.getMessage());
            }
        } else {
            this.insertEror(ctx, assignid, userid, errcode + "", errmsg);
        }
    }

    private void insertEror(Context ctx, String assignid, String userid, String errorcode, String errormsg) {
        try {
            String sql = " insert into t_assign_dtmsgerror(msgid,fassignid,fuserid,errorcode,errormsg,sendtime) values(?,?,?,?,?,getdate())";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{"", assignid, userid, errorcode, errormsg});
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
    }

    private String createDingTalkMsg(Context ctx, String eid, String appKey, IMessageAdapter adapter) {
        List<String> personIds = adapter.getUsers();
        List<String> useridList = TransferUserIdToXtIdUtil.transferWithList4Dingtalk(ctx, personIds);
        String touser = "";
        for (int i = 0; i < useridList.size(); ++i) {
            if (i > 0) {
                touser = touser + ",";
            }
            touser = touser + useridList.get(i);
        }
        if (StringUtils.isEmpty((String)touser)) {
            return null;
        }
        HashMap map = (HashMap)adapter.getContent();
        String todoTitle = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "todoTitle", "");
        String title = StringUtils.isEmpty((String)todoTitle) ? "\u60a8\u6709\u5f85\u5ba1\u6279\u6d41\u7a0b" : todoTitle;
        String description = (String)map.get("text");
        String easTitle = (String)map.get("title");
        if (!StringUtils.isEmpty((String)easTitle)) {
            description = description + "\n\u53d1\u8d77\u4eba: " + easTitle;
        }
        HashMap<String, Object> msgMap = new HashMap<String, Object>();
        String url = (String)map.get("url");
        msgMap.put("userid", touser);
        msgMap.put("create_time", System.currentTimeMillis());
        msgMap.put("title", title);
        msgMap.put("url", this.changToDingTalkUrl(eid, url, appKey));
        ArrayList formItemList = new ArrayList();
        HashMap<String, String> formItem = new HashMap<String, String>();
        formItem.put("title", "\u6807\u9898");
        formItem.put("content", description);
        formItemList.add(formItem);
        msgMap.put("formItemList", formItemList);
        return JSON.toJSONString(msgMap);
    }

    private String createDingTalkNoitceMsg(Context ctx, String eid, String appKey, IMessageAdapter adapter) {
        List<String> personIds = adapter.getUsers();
        List<String> useridList = TransferUserIdToXtIdUtil.transferWithList4Dingtalk(ctx, personIds);
        String touser = "";
        for (int i = 0; i < useridList.size(); ++i) {
            if (i > 0) {
                touser = touser + ",";
            }
            touser = touser + useridList.get(i);
        }
        if (StringUtils.isEmpty((String)touser)) {
            return null;
        }
        String noticeTitle = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "noticeTitle", "");
        String title = StringUtils.isEmpty((String)noticeTitle) ? "\u60a8\u6709\u901a\u77e5\u6d88\u606f" : noticeTitle;
        HashMap map = (HashMap)adapter.getContent();
        String wxtitle = (String)map.get("wxtitle");
        if (!StringUtils.isEmpty((String)wxtitle)) {
            title = wxtitle;
        }
        String description = (String)map.get("text");
        String easTitle = (String)map.get("title");
        if (!StringUtils.isEmpty((String)easTitle)) {
            description = description + "\n\u53d1\u8d77\u4eba: " + easTitle;
        }
        HashMap<String, Object> msgMap = new HashMap<String, Object>();
        String agentid = XTServiceConfig.getInstance().getDingtalkAppAgentId(eid);
        HashMap<String, Object> msg = new HashMap<String, Object>();
        msgMap.put("agent_id", agentid);
        msgMap.put("userid_list", touser);
        msgMap.put("msg", msg);
        if (adapter.getType().value() == 2) {
            HashMap<String, String> textMsg = new HashMap<String, String>();
            msg.put("msgtype", "text");
            msg.put("text", textMsg);
            textMsg.put("content", description);
        } else {
            String url = (String)map.get("url");
            HashMap<String, String> action_card = new HashMap<String, String>();
            msg.put("msgtype", "action_card");
            msg.put("action_card", action_card);
            if (!StringUtils.isEmpty((String)description)) {
                description = "####  " + description.replaceAll("\n", "  \n  ");
            }
            action_card.put("markdown", description);
            action_card.put("title", title);
            action_card.put("single_title", "\u8fdb\u5165\u9605\u8bfb");
            action_card.put("single_url", this.changToDingTalkUrl(eid, url, appKey));
        }
        return JSON.toJSONString(msgMap);
    }

    private String changToDingTalkUrl(String eid, String originalURL, String appKey) {
        if (StringUtils.isEmpty((String)originalURL)) {
            return null;
        }
        String corpId = XTServiceConfig.getInstance().getDingtalkCorpId();
        corpId = StringUtils.isEmpty((String)corpId) ? eid : corpId;
        String url = "";
        String host = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "host", "");
        String easHost = host.replaceAll("/mbos/page/loadPage\\S*", "");
        String configHost = XTServiceConfig.getInstance().getDingtalkProperty("EASHost");
        String string = easHost = StringUtils.isEmpty((String)configHost) ? easHost : configHost;
        if (originalURL.contains("mbosw/getWorkflowUrl")) {
            String mainPage = originalURL.replaceAll("^http\\S*/getWorkflowUrl", "/mbos/auth/dingtalk.html");
            url = easHost + mainPage;
            url = url + "&replaceUrl=mbosw/getWorkflowUrl";
        } else {
            String bindingUrl = originalURL.replaceAll("^http\\S+/mbos/page/loadPage", "/mbos/auth/dingtalk.html");
            url = easHost + bindingUrl;
            url = url + "&replaceUrl=page/loadPage";
        }
        url = url + "&appKey=" + appKey;
        url = url + "&CorpId=" + corpId;
        return url;
    }
}

