/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.dingtalk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.dingtalk.DingtalkAPIInvokeUtil;
import com.kingdee.lightapp.dingtalk.DingtalkMessagePusher;
import com.kingdee.lightapp.pa.IMessagePusher;
import com.kingdee.lightapp.pa.api.IMessageAdapter;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DingtalkTaskPusher
implements IMessagePusher {
    private final Logger logger = Logger.getLogger(DingtalkTaskPusher.class);
    private String messageType;

    public DingtalkTaskPusher(String messageType) {
        this.messageType = messageType;
    }

    @Override
    public Map<String, Object> pushMessage(Context ctx, List<IMessageAdapter> messageList) {
        for (IMessageAdapter adapter : messageList) {
            this.pushTask(ctx, adapter);
        }
        return null;
    }

    @Override
    public Map<String, Object> pushNoitceMessage(Context ctx, List<IMessageAdapter> messageList) {
        DingtalkMessagePusher oldpusher = new DingtalkMessagePusher("");
        return oldpusher.pushNoitceMessage(ctx, messageList);
    }

    private void pushTask(Context ctx, IMessageAdapter adapter) {
        String autoBind;
        String eid = XTServiceConfig.getInstance().getEidByDbCode(ctx.getAIS());
        String appKey = XTServiceConfig.getInstance().getDingtalkAppKey(eid);
        String reciverUserid = adapter.getUsers().get(0);
        String[] userBindDtIds = this.getUserBindDtIds(ctx, reciverUserid);
        if (userBindDtIds != null && !StringUtils.isEmpty((String)userBindDtIds[0]) && StringUtils.isEmpty((String)userBindDtIds[1])) {
            String unionID;
            userBindDtIds[1] = unionID = this.getAndUpdateUnionID(ctx, appKey, userBindDtIds[0]);
        }
        if ((userBindDtIds == null || StringUtils.isEmpty((String)userBindDtIds[0])) && "true".equals(autoBind = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "autoBind", ""))) {
            userBindDtIds = DingtalkAPIInvokeUtil.tryAutoBind(ctx, appKey, reciverUserid);
        }
        if (userBindDtIds == null || StringUtils.isEmpty((String)userBindDtIds[1])) {
            return;
        }
        Map<String, Object> contentMap = adapter.getContent();
        String msgStr = this.createTodoDingTalkMsg(ctx, contentMap, eid, appKey, userBindDtIds[1]);
        String assignid = (String)contentMap.get("assignId");
        String userId = (String)contentMap.get("receiver");
        try {
            this.logger.error((Object)("pushTodoTask message=====" + msgStr));
            String pushResult = DingtalkAPIInvokeUtil.pushTodoTask(msgStr, userBindDtIds[1], appKey);
            this.logger.error((Object)("pushTodoTask pushResult ===" + pushResult));
            this.savePushedMsg(ctx, assignid, userId, null, pushResult);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            this.insertEror(ctx, assignid, userId, "0", e.getMessage());
        }
        String withNotie = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "withNotie", "");
        if ("true".equals(withNotie)) {
            try {
                ArrayList<IMessageAdapter> messageList = new ArrayList<IMessageAdapter>();
                messageList.add(adapter);
                this.pushNoitceMessage(ctx, messageList);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String createTodoDingTalkMsg(Context ctx, Map<String, Object> map, String eid, String appKey, String dtUserID) {
        String creatorId;
        String description = (String)map.get("text");
        String easTitle = (String)map.get("title");
        String assignId = (String)map.get("assignId");
        String sendId = (String)map.get("sendId");
        String[] idArr = this.getUserBindDtIds(ctx, sendId);
        if (idArr != null && !StringUtils.isEmpty((String)idArr[0]) && StringUtils.isEmpty((String)idArr[1])) {
            String creatorUnionID;
            idArr[1] = creatorUnionID = this.getAndUpdateUnionID(ctx, appKey, idArr[0]);
        }
        String string = creatorId = idArr == null || StringUtils.isEmpty((String)idArr[1]) ? dtUserID : idArr[1];
        if (!StringUtils.isEmpty((String)easTitle)) {
            description = description + "\n\u53d1\u8d77\u4eba: " + easTitle;
        }
        String url = (String)map.get("url");
        HashMap<String, Object> msgMap = new HashMap<String, Object>();
        HashMap<String, String> detailUrl = new HashMap<String, String>();
        HashMap<String, String> notifyConfigs = new HashMap<String, String>();
        ArrayList<String> executorIds = new ArrayList<String>();
        executorIds.add(dtUserID);
        msgMap.put("sourceId", assignId);
        msgMap.put("subject", description);
        msgMap.put("description", description);
        msgMap.put("creatorId", creatorId);
        msgMap.put("executorIds", executorIds);
        msgMap.put("detailUrl", detailUrl);
        msgMap.put("notifyConfigs", notifyConfigs);
        String dingTalkUrl = this.changToDingTalkUrl(eid, url, appKey);
        detailUrl.put("appUrl", dingTalkUrl);
        detailUrl.put("pcUrl", dingTalkUrl);
        notifyConfigs.put("dingNotify", "1");
        return JSON.toJSONString(msgMap);
    }

    private String getAndUpdateUnionID(Context ctx, String appKey, String userID) {
        String unionID = "";
        try {
            unionID = DingtalkAPIInvokeUtil.getDingtalkUserUnionid(userID, appKey);
            if (!StringUtils.isEmpty((String)unionID)) {
                String sql = "UPDATE T_PM_EASDTUSERMAP SET FUNIONID = ?  WHERE  FXTID = ? ";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{unionID, userID});
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("UpdateCreatorUnionID" + e.getMessage()));
        }
        return unionID;
    }

    private void savePushedMsg(Context ctx, String assignid, String userid, String procinstid, String pushResult) {
        block5: {
            if (pushResult != null) {
                try {
                    JSONObject pushResultObject = JSON.parseObject((String)pushResult);
                    if (pushResultObject.containsKey((Object)"id")) {
                        String sourceID = pushResultObject.getString("id");
                        String sql = " insert into t_assign_dtmsg(msgid,fassignid,fuserid,procinstid) values(?,?,?,?)";
                        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{sourceID, assignid, userid, procinstid});
                        break block5;
                    }
                    String code = pushResultObject.getString("code");
                    String message = pushResultObject.getString("message");
                    this.insertEror(ctx, assignid, userid, code, message);
                }
                catch (BOSException e) {
                    this.insertEror(ctx, assignid, userid, "1", e.getMessage());
                }
            } else {
                this.insertEror(ctx, assignid, userid, "2", "push return null");
            }
        }
    }

    private void insertEror(Context ctx, String assignid, String userid, String errorcode, String errormsg) {
        try {
            String sql = " insert into t_assign_dtmsgerror(msgid,fassignid,fuserid,errorcode,errormsg,sendtime) values(?,?,?,?,?,getdate())";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{"", assignid, userid, errorcode, errormsg});
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
    }

    private String[] getUserBindDtIds(Context ctx, String userId) {
        String sql = "SELECT FXTID,FUNIONID FROM T_PM_EASDTUSERMAP WHERE FUSERID = ?";
        String[] Idsarr = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{userId});
            if (rs.next()) {
                Idsarr = new String[]{rs.getString("FXTID"), rs.getString("FUNIONID")};
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        return Idsarr;
    }

    private String changToDingTalkUrl(String eid, String originalURL, String appKey) {
        if (StringUtils.isEmpty((String)originalURL)) {
            return null;
        }
        String corpId = XTServiceConfig.getInstance().getDingtalkCorpId();
        corpId = StringUtils.isEmpty((String)corpId) ? eid : corpId;
        String url = "";
        String host = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "host", "");
        String easHost = host.replaceAll("/mbos/page/loadPage\\S*", "");
        String configHost = XTServiceConfig.getInstance().getDingtalkProperty("EASHost");
        String string = easHost = StringUtils.isEmpty((String)configHost) ? easHost : configHost;
        if (originalURL.contains("mbosw/getWorkflowUrl")) {
            String mainPage = originalURL.replaceAll("^http\\S*/getWorkflowUrl", "/mbos/auth/dingtalk.html");
            url = easHost + mainPage;
            url = url + "&replaceUrl=mbosw/getWorkflowUrl";
        } else {
            String bindingUrl = originalURL.replaceAll("^http\\S+/mbos/page/loadPage", "/mbos/auth/dingtalk.html");
            url = easHost + bindingUrl;
            url = url + "&replaceUrl=page/loadPage";
        }
        url = url + "&appKey=" + appKey;
        url = url + "&CorpId=" + corpId;
        return url;
    }
}

