/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.message;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.eas.base.message.MsgBizType;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.lightapp.pa.MessageModelEnum;
import com.kingdee.lightapp.pa.MessageTypeEnum;
import com.kingdee.lightapp.pa.api.IMessageAdapter;
import com.kingdee.lightapp.xt.XTServiceConfig;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class WFNoticeAdapter
implements IMessageAdapter {
    private static Logger logger = Logger.getLogger(WFNoticeAdapter.class);
    private Message message = null;
    private Context ctx = null;
    private MessageModelEnum MESSAGEMODEL = null;

    @Override
    public boolean isNeedSendXT() {
        String content;
        boolean blackMode = true;
        String dbCode = this.ctx.getAIS();
        String eid = XTServiceConfig.getInstance().getEidByDbCode(dbCode);
        String mode = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "scope.text.pattern.mode", "");
        if ("0".equals(mode)) {
            blackMode = false;
        }
        if ((content = this.parseContent()) == null) {
            return false;
        }
        String list = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "scope.text.pattern.list", "");
        if (list == null || list.length() == 0) {
            return true;
        }
        String[] patternList = list.split(";");
        boolean findStr = false;
        for (int i = 0; i < patternList.length; ++i) {
            String patternStr = "^((?!" + patternList[i] + ").)+$";
            Pattern pattern = Pattern.compile(patternStr);
            Matcher matcher = pattern.matcher(content.toString());
            if (matcher.find()) continue;
            findStr = true;
            break;
        }
        if (blackMode) {
            return !findStr;
        }
        return findStr;
    }

    public WFNoticeAdapter(Message message) {
        logger.debug((Object)"WfNoticeAdapter init");
        this.message = message;
        this.ctx = WFNoticeAdapter.createContext(message.getStringHeader("solution"), message.getStringHeader("databaseCenter"));
        this.initMessageModel();
    }

    @Override
    public MessageTypeEnum getType() {
        return MessageTypeEnum.TEXT;
    }

    @Override
    public MessageModelEnum getModel() {
        return this.MESSAGEMODEL;
    }

    @Override
    public Map<String, Object> getContent() {
        HashMap<String, Object> contents = new HashMap<String, Object>();
        String eid = XTServiceConfig.getInstance().getEidByDbCode(this.ctx.getAIS());
        String appId = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "appId", "");
        contents.put("appid", appId);
        if (MessageModelEnum.FLOWCENTERNOTICE.equals((Object)this.MESSAGEMODEL)) {
            MsgBizType bizType = MsgBizType.getEnum((int)this.message.getIntHeader("bizType"));
            String tagId = MsgBizType.FORWARN == bizType ? "alarm" : "notify";
            contents.put("tagId", tagId);
            contents.put("itemtitle", this.message.getLocaleStringHeader("title", new Locale("L2")));
            contents.put("text", this.message.getLocaleStringHeader("body", new Locale("L2")));
            contents.put("assignId", UUID.randomUUID() + "LCZSITEM");
        } else {
            contents.put("text", this.parseContent());
        }
        contents.put("wxtitle", "\u6d88\u606f\u901a\u77e5");
        contents.put("sendId", this.message.getStringHeader("initiatorId"));
        contents.put("procinstid", this.message.getStringHeader("ProcessInstId"));
        contents.put("receiver", this.message.getStringHeader("receiver"));
        return contents;
    }

    private String parseContent() {
        String msgContent = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (msgContent == null || msgContent.equals("")) {
            msgContent = this.message.getLocaleStringHeader("title", new Locale("L2"));
            msgContent = msgContent + "\n\u6d88\u606f\u5185\u5bb9\uff1a" + this.message.getLocaleStringHeader("body", new Locale("L2"));
        }
        logger.info((Object)("XT Notices parseContext() body=" + this.message.getLocaleStringHeader("body", new Locale("L2")) + ",title=" + this.message.getLocaleStringHeader("title", new Locale("L2"))));
        return msgContent;
    }

    @Override
    public List<String> getUsers() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            IUser user = UserFactory.getLocalInstance((Context)this.ctx);
            String msgReceiver = this.message.getStringHeader("receiver");
            logger.info((Object)("XT Message getUsers() msgReceiver: " + msgReceiver));
            if (msgReceiver != null) {
                list.add(msgReceiver);
                logger.info((Object)("XT Message getUsers() userID:" + msgReceiver));
            }
        }
        catch (Exception e) {
            logger.error((Object)"XT Message getUsers() error!", (Throwable)e);
        }
        return list;
    }

    @Override
    public Date getUpdateTime() {
        return new Date();
    }

    @Override
    public void clearTemporary() {
    }

    private static Context createContext(String solution, String ais) {
        Context context = new Context((IObjectPK)new ObjectUuidPK(), solution, ais, new Locale("l2"));
        return context;
    }

    private void initMessageModel() {
        String api = XTServiceConfig.getInstance().getXTInfoProperties().get("apiVersion");
        this.MESSAGEMODEL = "flowcenter".equalsIgnoreCase(api) ? MessageModelEnum.FLOWCENTERNOTICE : null;
    }

    public static void main(String[] args) {
        Message newMessage = MessageFactory.newMessage();
        Locale locale = new Locale("L2");
        newMessage.setLocaleStringHeader("title", "aaa", locale);
        newMessage.setLocaleStringHeader("body", "bbb", locale);
        newMessage.setLocaleStringHeader("sender", "ccc", locale);
    }
}

