/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.pa.common;

import com.kingdee.lightapp.pa.MessageModelEnum;
import com.kingdee.lightapp.pa.MessageTypeEnum;
import com.kingdee.lightapp.pa.api.IMessageSection;
import com.kingdee.lightapp.pa.common.CommonMessageHead;
import com.kingdee.lightapp.pa.common.FlowCenterToReadMessageHead;
import com.kingdee.lightapp.pa.common.FlowCenterTodoMessageHead;
import com.kingdee.lightapp.pa.common.TodoMessageHead;
import com.kingdee.lightapp.pa.common.messagebody.ImageMessageBody;
import com.kingdee.lightapp.pa.common.messagebody.LinkMessageBody;
import com.kingdee.lightapp.pa.common.messagebody.MultiGraphicMessageBody;
import com.kingdee.lightapp.pa.common.messagebody.SingleGraphicMessageBody;
import com.kingdee.lightapp.pa.common.messagebody.TextGraphicMessageBody;
import com.kingdee.lightapp.pa.common.messagebody.TextMessageBody;

public class MessageSectionFactory {
    private static MessageSectionFactory instance = new MessageSectionFactory();
    private String eid = null;

    protected MessageSectionFactory() {
    }

    public static MessageSectionFactory getInstance() {
        return instance;
    }

    public IMessageSection getMessageHeadNew(String type, String eid) throws ClassNotFoundException {
        if (type != null && type.equalsIgnoreCase("common")) {
            return new TodoMessageHead(eid);
        }
        if (type != null && type.equalsIgnoreCase("flowcenter")) {
            return new FlowCenterTodoMessageHead(eid);
        }
        if (type != null && type.equalsIgnoreCase("flowcentertoread")) {
            return new FlowCenterToReadMessageHead(eid);
        }
        throw new ClassNotFoundException("the class of message head type :" + type + "has not found.");
    }

    public IMessageSection getMessageHead(String type, String eid) throws ClassNotFoundException {
        if (type != null && type.equalsIgnoreCase("common")) {
            return new CommonMessageHead(eid);
        }
        throw new ClassNotFoundException("the class of message head type :" + type + "has not found.");
    }

    public IMessageSection getMessageBody(MessageTypeEnum type, MessageModelEnum model) throws ClassNotFoundException {
        if (type != null && type == MessageTypeEnum.TEXT) {
            return new TextMessageBody();
        }
        if (type != null && type == MessageTypeEnum.IMAGE) {
            return new ImageMessageBody();
        }
        if (type != null && type == MessageTypeEnum.LINK) {
            return new LinkMessageBody();
        }
        if (type != null && type == MessageTypeEnum.GRAPHIC) {
            if (model != null && model == MessageModelEnum.SINGLETEXT) {
                return new TextGraphicMessageBody();
            }
            if (model != null && model == MessageModelEnum.SINGLEGRAPHIC) {
                return new SingleGraphicMessageBody();
            }
            if (model != null && model == MessageModelEnum.MULTIGRAPHIC) {
                return new MultiGraphicMessageBody();
            }
            try {
                throw new ClassNotFoundException("the class of message body model :" + model.toString() + "has not found.");
            }
            catch (NullPointerException e) {
                throw new ClassNotFoundException("the model is null,message body object can not be created");
            }
        }
        try {
            throw new ClassNotFoundException("the class of message body type :" + type.toString() + "has not found.");
        }
        catch (NullPointerException e) {
            throw new ClassNotFoundException("the type is null,message body object can not be created");
        }
    }
}

