/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.pa.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.pa.MessageModelEnum;
import com.kingdee.lightapp.pa.api.AbstractYZJMessage;
import com.kingdee.lightapp.pa.api.IMessageAdapter;
import com.kingdee.lightapp.pa.common.MessageSectionFactory;
import com.kingdee.lightapp.util.StringUtil;
import com.kingdee.lightapp.xt.XTServiceConfig;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TodoMessage
extends AbstractYZJMessage {
    private static Logger logger = Logger.getLogger((String)TodoMessage.class.getName());
    private static String PUSH_ALL_USERS = "PUSH_ALL_USERS";

    public TodoMessage(Context ctx, String eid, IMessageAdapter msg, String code, boolean toAllUser) throws Exception {
        super(msg);
        if (msg == null) {
            throw new NullPointerException("adapter is null");
        }
        MessageModelEnum model = null;
        HashMap<String, Object> contentMap = null;
        Map<String, Object> bodyPackage = null;
        String signTime = null;
        List<String> userList = null;
        if (msg.isNeedSendXT()) {
            model = msg.getModel();
            signTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(msg.getUpdateTime());
            List<String> xtList = this.transferUserIdToXtId(ctx, msg.getUsers());
            if ((userList = this.mergeUsers(userList, xtList, toAllUser)) == null || userList.size() < 1) {
                logger.error((Object)"userList is null");
                throw new Exception("nouser");
            }
            bodyPackage = msg.getContent();
            this.content = MessageSectionFactory.getInstance().getMessageHeadNew("common", eid);
            contentMap = new HashMap<String, Object>();
            ArrayList<String> sendList = new ArrayList<String>();
            sendList.add((String)bodyPackage.get("sendId"));
            List<String> sendxtList = this.transferUserIdToXtId(ctx, sendList);
            if (sendxtList.size() > 0) {
                contentMap.put("sendId", sendxtList.get(0));
            }
            contentMap.put("itemtitle", bodyPackage.get("itemtitle"));
            contentMap.put("signtime", signTime);
            contentMap.put("users", userList);
            contentMap.put("code", code);
            contentMap.put("eid", eid);
            contentMap.put("assignId", bodyPackage.get("assignId"));
            contentMap.put("title", "\u6d41\u7a0b\u52a9\u624b");
            contentMap.put("text", bodyPackage.get("text"));
            contentMap.put("appid", bodyPackage.get("appid"));
            contentMap.put("url", bodyPackage.get("url"));
            contentMap.put("passUrl", bodyPackage.get("passUrl"));
            if (MessageModelEnum.FLOWCENTERNOTICE.equals((Object)msg.getModel())) {
                String dbEid;
                XTServiceConfig instance = XTServiceConfig.getInstance();
                String mouldSortName = instance.getPubAcctProperty(dbEid = instance.getEidByDbCode(ctx.getAIS()), "WFMessage", "mouldSortName", "");
                if (StringUtil.isNotEmpty(mouldSortName)) {
                    contentMap.put("title", mouldSortName);
                }
                contentMap.put("todoType", 0);
                contentMap.put("tagId", bodyPackage.get("tagId"));
                String url = (String)bodyPackage.get("url");
                if (StringUtil.isNotEmpty(url)) {
                    contentMap.put("url", url + "&noticeMsgId=" + eid + "-" + bodyPackage.get("assignId"));
                }
            }
            this.content.makeContent(contentMap);
        }
    }

    private List<String> transferUserIdToXtId(Context ctx, List<String> userIdList) {
        ArrayList<String> xtIdList = new ArrayList<String>();
        if (userIdList != null) {
            int pageSize = 900;
            int totalCount = userIdList.size();
            int totalPage = (totalCount - 1) / pageSize + 1;
            for (int i = 0; i < totalPage; ++i) {
                IRowSet rs;
                int firstCount = i * pageSize;
                int maxCount = (i + 1) * pageSize;
                if (maxCount > totalCount) {
                    maxCount = totalCount;
                }
                StringBuilder sb = new StringBuilder(100);
                sb.append("''");
                for (int j = firstCount; j < maxCount; ++j) {
                    if (!StringUtil.isNotEmpty(userIdList.get(j))) continue;
                    sb.append(",'").append(userIdList.get(j)).append("'");
                }
                if (sb.length() <= 5) continue;
                Object[] params = new Object[1];
                String sql = "select FXtId from T_PM_easxtusermap where FuserId in (" + sb.toString() + ")";
                params[0] = sb.toString();
                try {
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                    while (rs.next()) {
                        if (StringUtil.isEmpty(rs.getString("FXtId"))) continue;
                        xtIdList.add(rs.getString("FXtId"));
                    }
                }
                catch (BOSException e) {
                    logger.error((Object)("transferUserIdToXtId === excute sql error" + e.getMessage()));
                    e.printStackTrace();
                }
                catch (SQLException se) {
                    logger.error((Object)("transferUserIdToXtId === rs operation error" + se.getMessage()));
                    se.printStackTrace();
                }
                if (xtIdList.size() != 0) continue;
                sql = "select FXtId from T_PM_easxtusermap where FPersonId in (" + sb.toString() + ")";
                try {
                    rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                    while (rs.next()) {
                        if (StringUtil.isEmpty(rs.getString("FXtId"))) continue;
                        xtIdList.add(rs.getString("FXtId"));
                    }
                    continue;
                }
                catch (BOSException e) {
                    logger.error((Object)("transferUserIdToXtId === excute sql error" + e.getMessage()));
                    e.printStackTrace();
                    continue;
                }
                catch (SQLException se) {
                    logger.error((Object)("transferUserIdToXtId === rs operation error" + se.getMessage()));
                    se.printStackTrace();
                }
            }
        }
        return xtIdList;
    }

    private List<String> mergeUsers(List<String> firstList, List<String> secondList, boolean toAllUser) {
        List<Object> list;
        block5: {
            list = null;
            if (!toAllUser) {
                try {
                    if (firstList == null) {
                        list = secondList;
                        break block5;
                    }
                    list = new ArrayList();
                    list.addAll(firstList);
                    secondList.removeAll(list);
                    list.addAll(secondList);
                }
                catch (Exception e) {
                    logger.error((Object)("the list of user has error:" + e.getMessage()));
                }
            } else {
                list = new ArrayList();
                list.add(PUSH_ALL_USERS);
                logger.info((Object)"push to all user switch has enabled");
            }
        }
        return list;
    }
}

