/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.util;

import com.alibaba.fastjson.JSON;
import com.kingdee.lightapp.exception.WorkflowException;
import com.kingdee.lightapp.exception.enums.WorkflowErrorEnums;
import com.kingdee.lightapp.pa.api.HttpClientUtil;
import com.kingdee.lightapp.pa.api.YZJInvokeUtil;
import com.kingdee.lightapp.util.AppAuth2;
import com.kingdee.lightapp.util.StringUtil;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.lightapp.xt.YZJUrlContants;
import com.kingdee.lightapp.xt.dto.XtParamsDTO;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class McloudParamsUtil {
    private static final Logger logger = Logger.getLogger(McloudParamsUtil.class);
    protected static McloudParamsUtil instance = null;
    private static Map accessTokenMap = new HashMap();
    private static Object lock = new Object();

    private McloudParamsUtil() {
    }

    public static McloudParamsUtil getInstance() {
        if (instance == null) {
            instance = new McloudParamsUtil();
        }
        return instance;
    }

    public XtParamsDTO getXtParamsDTO(String appId, String ticket) throws Exception {
        return null;
    }

    public XtParamsDTO getXtParamsDTO(HttpServletRequest httpRequest, String appId, String ticket) throws Exception {
        XtParamsDTO xtparamsDto = null;
        String cloudtime = httpRequest.getParameter("$timestamp$");
        String accessToken = YZJInvokeUtil.getInstance().getAccessToken(appId, cloudtime);
        if (StringUtil.isNotEmpty(accessToken) && !"null".equalsIgnoreCase(accessToken)) {
            String apivs = XTServiceConfig.getInstance().getXTInfoProperties().get("apiVersion");
            xtparamsDto = "old".equalsIgnoreCase(apivs) ? this.getKdWeiboInfoOld(httpRequest, accessToken, appId, ticket) : this.getKdWeiboInfo(httpRequest, accessToken, appId, ticket);
        } else {
            logger.error((Object)"McloudParamsUtil == getXtParamsDTO== AccessToken is null!!!");
            throw new WorkflowException(WorkflowErrorEnums.CONNET_YZJTOKENURL_FAILED);
        }
        return xtparamsDto;
    }

    private XtParamsDTO getKdWeiboInfoOld(HttpServletRequest httpRequest, String accessToken, String appId, String ticket) {
        XtParamsDTO xtparamsDto;
        block9: {
            xtparamsDto = null;
            String url = YZJUrlContants.GET_CONTEXT_URL + "?ticket=" + ticket + "&access_token=" + accessToken;
            String response = "";
            try {
                String secret = XTServiceConfig.getInstance().getAppSecret(appId);
                String headerValue = AppAuth2.appAuth2Treaty(appId, secret);
                HashMap<String, String> headMap = new HashMap<String, String>();
                headMap.put("authorization", headerValue);
                logger.error((Object)("getKdWeiboInfoOld url= " + url));
                response = HttpClientUtil.doGet(url, headMap, "UTF-8");
                if (StringUtil.isNotEmpty(response)) {
                    try {
                        JSONObject jsonObj = new JSONObject(response);
                        if (jsonObj != null) {
                            xtparamsDto = new XtParamsDTO();
                            xtparamsDto.setEid(jsonObj.getString("eid"));
                            xtparamsDto.setOpenid(jsonObj.getString("openid"));
                        }
                        break block9;
                    }
                    catch (JSONException e) {
                        logger.error((Object)("McloudParamsUtil === response=" + response + " JSONException ==" + e.getMessage()), (Throwable)e);
                        throw new WorkflowException(WorkflowErrorEnums.CONNET_CONTEXTURL_RESPONSEERROR, YZJUrlContants.GET_CONTEXT_URL, e.getMessage());
                    }
                }
                logger.error((Object)"McloudParamsUtil === JSONException getKdWeiboInfo is null==");
                throw new WorkflowException(WorkflowErrorEnums.CONNET_CONTEXTURL_NORESPONSE, YZJUrlContants.GET_CONTEXT_URL, null);
            }
            catch (WorkflowException e) {
                throw e;
            }
            catch (UnknownHostException e) {
                throw new WorkflowException(WorkflowErrorEnums.CONNET_CONTEXTURL_UNKNOWNHOST, YZJUrlContants.GET_CONTEXT_URL, null);
            }
            catch (SocketException e) {
                throw new WorkflowException(WorkflowErrorEnums.CONNET_CONTEXTURL_SOCKETEXCEPTION, YZJUrlContants.GET_CONTEXT_URL, null);
            }
            catch (Exception e) {
                logger.error((Object)("McloudParamsUtil getKdWeiboInfo \u83b7\u53d6\u4e91\u4e4b\u5bb6openid\u5931\u8d25 \u8fd4\u56de\u4fe1\u606f =" + response), (Throwable)e);
                throw new WorkflowException(WorkflowErrorEnums.CONNET_CONTEXTURL_EXCEPTION, YZJUrlContants.GET_CONTEXT_URL, null);
            }
        }
        return xtparamsDto;
    }

    public XtParamsDTO getXtParamsDTOByEid(String appId, String eid, String openId) throws Exception {
        XtParamsDTO xtparamsDto = null;
        if (!StringUtil.isNotEmpty(openId) || "null".equalsIgnoreCase(openId)) {
            logger.error((Object)"McloudParamsUtil == getXtParamsDTO== AccessToken is null!!!");
            throw new Exception("EAS_LOGIN_CODE_00004");
        }
        xtparamsDto = new XtParamsDTO();
        xtparamsDto.setEid(eid);
        xtparamsDto.setOpenid(openId);
        return xtparamsDto;
    }

    private XtParamsDTO getKdWeiboInfo(HttpServletRequest httpRequest, String accessToken, String appid, String ticket) throws Exception {
        XtParamsDTO xtparamsDto;
        block11: {
            xtparamsDto = null;
            String url = YZJUrlContants.GET_CONTEXT_URL_NEW + "?accessToken=" + accessToken;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("appid", appid);
            map.put("ticket", ticket);
            String response = "";
            try {
                response = HttpClientUtil.doPost(url, JSON.toJSONString(map), "UTF-8");
                if (StringUtil.isNotEmpty(response)) {
                    try {
                        JSONObject jsonObj = new JSONObject(response);
                        if (jsonObj == null || !jsonObj.getBoolean("success")) {
                            logger.error((Object)("getKdWeiboInfo error url= " + url));
                            logger.error((Object)("getKdWeiboInfo error response= " + response));
                            String yzjReError = "";
                            if (jsonObj != null) {
                                if ("40001".equals(jsonObj.get("errorCode") + "")) {
                                    throw new WorkflowException(WorkflowErrorEnums.LOGIN_ERROR_TICKETEXPIRE);
                                }
                                yzjReError = (String)jsonObj.get("error");
                            }
                            throw new WorkflowException(WorkflowErrorEnums.CONNET_CONTEXTURL_RESPONSEERROR, YZJUrlContants.GET_CONTEXT_URL_NEW, yzjReError);
                        }
                        JSONObject jb = (JSONObject)jsonObj.get("data");
                        xtparamsDto = new XtParamsDTO();
                        xtparamsDto.setEid(jb.getString("eid"));
                        xtparamsDto.setOpenid(jb.getString("openid"));
                        break block11;
                    }
                    catch (JSONException e) {
                        logger.error((Object)("McloudParamsUtil === response=" + response + " JSONException ==" + e.getMessage()), (Throwable)e);
                        throw new WorkflowException(WorkflowErrorEnums.CONNET_CONTEXTURL_RESPONSEERROR, YZJUrlContants.GET_CONTEXT_URL_NEW, e.getMessage());
                    }
                }
                logger.error((Object)"McloudParamsUtil === JSONException getKdWeiboInfo is null==");
                throw new WorkflowException(WorkflowErrorEnums.CONNET_CONTEXTURL_NORESPONSE, YZJUrlContants.GET_CONTEXT_URL_NEW, null);
            }
            catch (WorkflowException e) {
                throw e;
            }
            catch (UnknownHostException e) {
                throw new WorkflowException(WorkflowErrorEnums.CONNET_CONTEXTURL_UNKNOWNHOST, YZJUrlContants.GET_CONTEXT_URL_NEW, null);
            }
            catch (SocketException e) {
                throw new WorkflowException(WorkflowErrorEnums.CONNET_CONTEXTURL_SOCKETEXCEPTION, YZJUrlContants.GET_CONTEXT_URL_NEW, null);
            }
            catch (Exception e) {
                logger.error((Object)("McloudParamsUtil getKdWeiboInfo \u83b7\u53d6\u4e91\u4e4b\u5bb6openid\u5931\u8d25 \u8fd4\u56de\u4fe1\u606f =" + response), (Throwable)e);
                throw new WorkflowException(WorkflowErrorEnums.CONNET_CONTEXTURL_EXCEPTION, YZJUrlContants.GET_CONTEXT_URL_NEW, null);
            }
        }
        return xtparamsDto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMessage(HttpServletRequest httpRequest, String surl, String appid, String secret) throws Exception {
        secret = XTServiceConfig.getInstance().getAppSecret(appid);
        String response = null;
        HttpClient http = new HttpClient();
        GetMethod get = null;
        try {
            get = new GetMethod(surl);
            http.setConnectionTimeout(50000);
            http.setTimeout(50000);
            String headerValue = AppAuth2.appAuth2Treaty(httpRequest, appid, secret);
            get.setRequestHeader("authorization", headerValue);
            http.executeMethod((HttpMethod)get);
            response = new String(get.getResponseBodyAsString().getBytes("UTF-8"));
        }
        finally {
            get.releaseConnection();
        }
        return response;
    }

    private class AccessTokenInfo {
        private String accessToken = null;
        private long accessTokenTime = 0L;
        private long expireTime = 0L;

        private AccessTokenInfo() {
        }
    }
}

