/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.workflow.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.lightapp.kcclight.KccLightAPIInvokeUtil;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.util.StringUtils;
import java.security.SecureRandom;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class KccLightMessageDeal {
    private static Logger logger = Logger.getLogger(KccLightMessageDeal.class);

    public static String deal(Context ctx, String assignId) {
        String dbCode = ctx.getAIS();
        String eid = XTServiceConfig.getInstance().getEidByDbCode(dbCode);
        HashMap<String, Object> dealMap = new HashMap<String, Object>();
        HashMap optionMap = new HashMap();
        long timestamp = System.currentTimeMillis();
        SecureRandom secureRandom = new SecureRandom();
        int noce = secureRandom.nextInt(Integer.MAX_VALUE);
        dealMap.put("appId", "10748");
        dealMap.put("nonce", noce + "");
        dealMap.put("timestamp", timestamp);
        dealMap.put("bizId", assignId);
        dealMap.put("status", 3);
        dealMap.put("toUser", "");
        dealMap.put("option", optionMap);
        String updateRe = "";
        String accountId = eid + "-" + dbCode;
        try {
            updateRe = KccLightAPIInvokeUtil.updateTodoMessage(eid, accountId, JSON.toJSONString(dealMap));
            KccLightMessageDeal.updateRecord(ctx, eid, assignId, updateRe);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return updateRe;
    }

    private static void updateRecord(Context ctx, String eid, String assignId, String updateRe) {
        try {
            String entryRole = XTServiceConfig.getInstance().getKccLightConfig(eid, "entryRole");
            String table = KccLightMessageDeal.getMsgTableByEntryRole(entryRole);
            if (!StringUtils.isEmpty((String)updateRe) && updateRe.contains("success")) {
                JSONObject updateReJSONObj = JSON.parseObject((String)updateRe);
                if (updateReJSONObj.getBooleanValue("success")) {
                    String updatesql = "UPDATE " + table + "  SET fstate= '1' WHERE  FASSIGNID=  ? ";
                    DbUtil.execute((Context)ctx, (String)updatesql, (Object[])new Object[]{assignId});
                } else {
                    String message = updateReJSONObj.getString("message");
                    String errorCode = updateReJSONObj.getInteger("errorCode") + "";
                    KccLightMessageDeal.insertError(ctx, entryRole, assignId, assignId, errorCode, message);
                }
            } else {
                KccLightMessageDeal.insertError(ctx, entryRole, assignId, assignId, "0", updateRe);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void insertError(Context ctx, String entryRole, String msgid, String assignId, String errorCode, String errormsg) {
        String string = errormsg = errormsg != null && errormsg.length() > 200 ? errormsg.substring(0, 200) : errormsg;
        if ("1".equals(entryRole)) {
            logger.error((Object)("changge kccmsg faild assignId: " + assignId));
            logger.error((Object)("changge kccmsg faild errormsg: " + errormsg));
            return;
        }
        try {
            String errorTable = KccLightMessageDeal.getDealErrorTableByEntryRole(entryRole);
            String insertsql = " insert into " + errorTable + "(msgid,fassignid,errorcode,errormsg,sendtime) values(?,?,?,?,getdate())";
            DbUtil.execute((Context)ctx, (String)insertsql, (Object[])new Object[]{msgid, assignId, errorCode, errormsg});
        }
        catch (Exception e) {
            logger.error((Object)("changge kccmsg assignId faild: " + assignId));
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private static String getDealErrorTableByEntryRole(String entryRole) {
        String tableName = "T_ASSIGN_CHANGGEERROR";
        tableName = "1".equals(entryRole) ? "T_ASSIGN_WXMSG" : tableName;
        tableName = "2".equals(entryRole) ? "T_ASSIGN_DTMSGDEALERROR" : tableName;
        tableName = "3".equals(entryRole) ? "T_ASSIGN_WLMSGDEALERROR" : tableName;
        return tableName;
    }

    private static String getMsgTableByEntryRole(String entryRole) {
        String tableName = "T_ASSIGN_XTMSG";
        tableName = "1".equals(entryRole) ? "T_ASSIGN_WXMSG" : tableName;
        tableName = "2".equals(entryRole) ? "T_ASSIGN_DTMSG" : tableName;
        tableName = "3".equals(entryRole) ? "T_ASSIGN_WLMSG" : tableName;
        return tableName;
    }
}

