/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.xt;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.Context;
import com.kingdee.lightapp.dingtalk.DingtalkTaskPusher;
import com.kingdee.lightapp.pa.IMessagePusher;
import com.kingdee.lightapp.pa.api.IMessageAdapter;
import com.kingdee.lightapp.welink.WeLinkMessagePusher;
import com.kingdee.lightapp.wx.WXMessagePusher;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.lightapp.xt.YZJFlowCenterPusher;
import com.kingdee.lightapp.xt.YZJMessageTokenPusher;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MultiAppPusher
implements IMessagePusher {
    private final Logger logger = Logger.getLogger(MultiAppPusher.class);
    private String messageType;

    public MultiAppPusher(String messageType) {
        this.messageType = messageType;
    }

    @Override
    public Map<String, Object> pushMessage(Context ctx, List<IMessageAdapter> messageList) {
        this.pushMultiAppMessage(ctx, 0, messageList);
        return null;
    }

    @Override
    public Map<String, Object> pushNoitceMessage(Context ctx, List<IMessageAdapter> messageList) {
        this.pushMultiAppMessage(ctx, 1, messageList);
        return null;
    }

    private void pushMultiAppMessage(Context ctx, int type, List<IMessageAdapter> messageList) {
        XTServiceConfig instance = XTServiceConfig.getInstance();
        String eid = instance.getEidByDbCode(ctx.getAIS());
        List<String> allConfNames = instance.getMultiAppConfNamesListByEid(eid);
        for (String appName : allConfNames) {
            IMessagePusher pusher = null;
            pusher = this.getMultiAppPusher(appName);
            if (pusher == null) continue;
            try {
                Map<String, Object> pushRe = null;
                pushRe = type == 0 ? pusher.pushMessage(ctx, messageList) : pusher.pushNoitceMessage(ctx, messageList);
                if (pushRe == null) continue;
                this.logger.error((Object)("multiAppPusher push result:" + JSON.toJSONString(pushRe)));
            }
            catch (Throwable T) {
                String name = pusher.getClass().getName();
                this.logger.error((Object)("multiAppPusher :+" + name + "pusher failed."), T);
            }
        }
    }

    private IMessagePusher getMultiAppPusher(String appName) {
        IMessagePusher pusher = null;
        if ("YZJ".equals(appName)) {
            String apiVersion = XTServiceConfig.getInstance().getXTInfoProperties().get("apiVersion");
            pusher = "flowcenter".equalsIgnoreCase(apiVersion) ? new YZJFlowCenterPusher("") : new YZJMessageTokenPusher("WFMessage");
            this.logger.error((Object)"YZJ pusher init");
        }
        if ("WX".equals(appName)) {
            pusher = new WXMessagePusher("");
            this.logger.error((Object)"WXMessage pusher init");
        }
        if ("Dingtalk".equals(appName)) {
            pusher = new DingtalkTaskPusher("");
            this.logger.error((Object)"DingtalkTask pusher init");
        }
        if ("WeLink".equals(appName)) {
            pusher = new WeLinkMessagePusher("");
            this.logger.error((Object)"WeLinkMessage pusher init");
        }
        return pusher;
    }
}

