/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.xt.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.session.ILoginModule;
import com.kingdee.bos.framework.session.LoginContext;
import com.kingdee.bos.framework.session.LoginModuleFactory;
import com.kingdee.bos.framework.session.LoginType;
import com.kingdee.bos.sql.DbType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaToken;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaTokenManager;
import com.kingdee.eas.util.CryptoTean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.exception.WorkflowException;
import com.kingdee.lightapp.exception.enums.WorkflowErrorEnums;
import com.kingdee.lightapp.xt.UserNotFoundException;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.lightapp.xt.dto.XtParamsDTO;
import com.kingdee.lightapp.xt.util.OrgSwitchUtil;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class LoginHelper {
    private static final Logger logger = Logger.getLogger(LoginHelper.class);

    public static Context loginByXtId(HttpServletRequest request, XtParamsDTO xtparamsDto) throws Exception {
        Context ctx = null;
        long time1 = System.currentTimeMillis();
        UserInfo user = LoginHelper.getUserByXtId(xtparamsDto);
        if (user == null) {
            logger.error((Object)"LoginHelper == loginByXtId== No match User !!!");
            HttpSession session = request.getSession();
            session.setAttribute("openid", (Object)xtparamsDto.getOpenid());
            session.setAttribute("eid", (Object)xtparamsDto.getEid());
            throw new UserNotFoundException(xtparamsDto.getOpenid());
        }
        ctx = LoginHelper.loginEAS(user, xtparamsDto);
        long time2 = System.currentTimeMillis();
        logger.info((Object)("LoginHelper" + user.getName() + " == loginByXtId sucess == time ====" + (time2 - time1)));
        return ctx;
    }

    public static Context loginEAS(String eid, String user, String password) throws Exception {
        return LoginHelper.loginEAS(eid, user, password, "");
    }

    public static Context loginEAS(String eid, String user, String password, String authType) throws Exception {
        XTServiceConfig cfg = XTServiceConfig.getInstance();
        String aix = cfg.getDbCode(eid);
        String sln = cfg.getSlnName(eid);
        String localeStr = cfg.getLocale(eid);
        LoginHelper.checkDBInfoConfig(eid, cfg);
        try {
            Locale locale = new Locale(localeStr);
            String clientIP = "101.124.7.210";
            LoginContext loginCtx = new LoginContext(user, password, sln, aix, locale);
            loginCtx.put("dbTypeCode", (Object)cfg.getDbType(eid));
            loginCtx.put("dbType", (Object)DbType.getName((int)cfg.getDbType(eid)));
            loginCtx.put("ClientIP", (Object)clientIP);
            loginCtx.setLoginType(LoginType.MOBILE);
            if (!StringUtils.isEmpty((String)authType)) {
                loginCtx.put("UserAuthPattern", (Object)authType);
            }
            Context userContext = new Context(null, loginCtx.getSlnName(), loginCtx.getAis(), loginCtx.getLocale(), loginCtx.getContextID());
            loginCtx.setContextID(userContext.getContextID());
            WebContextUtil.initRpcConfig((Context)userContext);
            ILoginModule loginModule = LoginModuleFactory.getRemoteInstance();
            Context userCtx = loginModule.fullLogin(loginCtx);
            OrgSwitchUtil.switchForLogin(userCtx);
            return userCtx;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new WorkflowException(WorkflowErrorEnums.LOGIN_ERROR_LOGINEASERROR, null, e.getCause().getMessage());
        }
    }

    private static void checkDBInfoConfig(String eid, XTServiceConfig cfg) throws Exception {
        if (StringUtils.isEmpty((String)cfg.getDbCode(eid))) {
            throw new WorkflowException(WorkflowErrorEnums.CONFIG_ERROR_NODBINFO, null, eid);
        }
        if (StringUtils.isEmpty((String)cfg.getSlnName(eid))) {
            throw new WorkflowException(WorkflowErrorEnums.CONFIG_ERROR_NOLNNAME, null, eid);
        }
        if (StringUtils.isEmpty((String)cfg.getLocale(eid))) {
            throw new WorkflowException(WorkflowErrorEnums.CONFIG_ERROR_NOLOCALE, null, eid);
        }
        try {
            cfg.getDbType(eid);
        }
        catch (Exception e) {
            throw new WorkflowException(WorkflowErrorEnums.CONFIG_ERROR_NODBTYPE, null, eid);
        }
    }

    public static Context loginEAS(UserInfo user, XtParamsDTO xtparamsDto) throws Exception {
        String userName = user.getNumber();
        String eid = xtparamsDto.getEid();
        String authType = "BaseTrdLtpaToken";
        LtpaToken token = LtpaTokenManager.generate((String)userName, (String)LtpaTokenManager.getDefaultLtpaConfig());
        String authPassword = token.getTokenStr();
        XTServiceConfig cfg = XTServiceConfig.getInstance();
        LoginHelper.checkDBInfoConfig(eid, cfg);
        Context userCtx = null;
        try {
            String encodePwd = CryptoTean.encrypt((String)userName, (String)authPassword);
            Locale locale = new Locale(cfg.getLocale(eid));
            String clientIP = "101.124.7.210";
            LoginContext loginCtx = new LoginContext(userName, encodePwd, cfg.getSlnName(eid), cfg.getDbCode(eid), locale, clientIP, clientIP);
            loginCtx.put("UserAuthPattern", (Object)authType);
            loginCtx.put("dbTypeCode", (Object)cfg.getDbType(eid));
            loginCtx.put("dbType", (Object)DbType.getName((int)cfg.getDbType(eid)));
            loginCtx.put("ClientIP", (Object)clientIP);
            loginCtx.setLoginType(LoginType.MOBILE);
            String contextID = (String)loginCtx.get("contextID");
            if (contextID != null) {
                loginCtx.setContextID(contextID);
            }
            Context userContext = new Context(null, loginCtx.getSlnName(), loginCtx.getAis(), loginCtx.getLocale(), loginCtx.getContextID());
            loginCtx.setContextID(userContext.getContextID());
            WebContextUtil.initRpcConfig((Context)userContext);
            ILoginModule loginModule = LoginModuleFactory.getRemoteInstance();
            userCtx = loginModule.fullLogin(loginCtx);
            OrgSwitchUtil.switchForLogin(userCtx);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new WorkflowException(WorkflowErrorEnums.LOGIN_ERROR_LOGINEASERROR, null, e.getCause().getMessage());
        }
        return userCtx;
    }

    public static UserInfo getUserByXtId(XtParamsDTO xtparamsDto) throws Exception {
        String ais = "";
        try {
            ais = XTServiceConfig.getInstance().getDbCode(xtparamsDto.getEid());
        }
        catch (Exception e) {
            logger.error((Object)"LoginHelper == getUserByXtId== ais is Empty!!!", (Throwable)e);
            throw new WorkflowException(WorkflowErrorEnums.CONFIG_ERROR_NODBINFO, null, xtparamsDto.getEid());
        }
        Context ctx = new Context(null, "eas", ais, new Locale("l2"));
        UserInfo user = null;
        Object[] params = new Object[1];
        String sql = null;
        sql = xtparamsDto.isWx() ? "select us.* from t_pm_user us,T_PM_easwxusermap xt  where xt.fxtId=? and xt.fuserId=us.fid and us.fisdelete = 0" : "select us.* from t_pm_user us,T_PM_easxtusermap xt  where xt.fxtId=? and xt.fuserId=us.fid and us.fisdelete = 0";
        if (StringUtils.isEmpty((String)xtparamsDto.getOpenid())) {
            return null;
        }
        params[0] = xtparamsDto.getOpenid();
        try {
            IRowSet dataSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            if (dataSet.next()) {
                user = new UserInfo();
                user.setId(BOSUuid.read((String)dataSet.getString("FID")));
                user.setName(dataSet.getString("FNAME_L2"));
                user.setNumber(dataSet.getString("FNumber"));
            }
        }
        catch (Exception e) {
            user = null;
            logger.error((Object)("LoginHelper == getUserByXtId== " + e));
        }
        return user;
    }

    public static UserInfo getUserByPhone(Context ctx, String phone) throws BOSException, SQLException {
        UserInfo user = new UserInfo();
        String usersql = "select * from t_pm_user where fcell = ? and fisdelete =0 and fislocked=0 and fforbidden=0 ";
        Object[] params = new Object[]{phone};
        IRowSet dataSet = DbUtil.executeQuery((Context)ctx, (String)usersql, (Object[])params);
        if (dataSet.next()) {
            user = new UserInfo();
            user.setId(BOSUuid.read((String)dataSet.getString("FID")));
            user.setName(dataSet.getString("FNAME_L2"));
            user.setNumber(dataSet.getString("FNumber"));
        }
        return user;
    }
}

