/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.mobile;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.mobile.IMobileMessageFormat;
import com.kingdee.eas.mobile.MobileMessageFormatCollection;
import com.kingdee.eas.mobile.MobileMessageFormatFactory;
import com.kingdee.eas.mobile.MobileMessageFormatInfo;
import com.kingdee.eas.tools.datatask.databind.DataBindUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.LongEnum;
import com.kingdee.util.enums.StringEnum;
import java.util.ArrayList;

public class MobileMessageFormatUtils {
    private static int SINGLETYPE = 0;
    private static int MULTITTYPE = 1;

    public String constructContentByMessageFormat(Context ctx, CoreBaseInfo editData) throws Exception {
        MobileMessageFormatCollection formatCol = this.getFormatColl(ctx, editData);
        if (formatCol.size() == 0) {
            return null;
        }
        MobileMessageFormatInfo formatInfo = formatCol.get(0);
        String format = formatInfo.getFormat();
        return this.getFormatContentNew(format, formatCol, editData);
    }

    private String getFormatContentNew(String format, MobileMessageFormatCollection formatCol, CoreBaseInfo editData) throws Exception {
        FullOrgUnitInfo fullOrgUnitInfo = this.getFullOrgUnitInfoByfield(format, formatCol, editData);
        if (fullOrgUnitInfo != null) {
            editData = fullOrgUnitInfo;
        }
        SegmentColleciton segmentColl = new SegmentColleciton();
        int i = 0;
        while (!StringUtils.isEmpty((String)format)) {
            int leftIndex = format.indexOf(123);
            if (leftIndex != -1) {
                int rightIndex = format.indexOf(125);
                String indexStr = format.substring(leftIndex + 1, rightIndex);
                int fIndex = new Integer(indexStr);
                if (formatCol.get(fIndex) == null || StringUtils.isEmpty((String)formatCol.get(fIndex).getFieldName())) continue;
                String fieldName = formatCol.get(fIndex).getFieldName();
                ArrayList value = this.getValueByFieldName(editData, fieldName);
                segmentColl.add(this.getConstantSegmentInfo(i, format.substring(0, leftIndex)));
                ++i;
                if (value.size() > 0) {
                    segmentColl.add(this.getConstantSegmentInfo(i, value));
                    ++i;
                }
                format = format.substring(rightIndex + 1);
                continue;
            }
            segmentColl.add(this.getConstantSegmentInfo(i, format));
            ++i;
            format = null;
        }
        StringBuffer formatedContent = new StringBuffer();
        int size = segmentColl.size();
        for (int j = 0; j < size; ++j) {
            SegmentInfo info = segmentColl.get(j);
            if (j < segmentColl.getStartMultiIndex() || j > segmentColl.getEndMultiIndex()) {
                formatedContent.append(info.getContent());
                continue;
            }
            if (j != segmentColl.getStartMultiIndex()) continue;
            int entrySize = info.getSize();
            boolean isFirstEntry = true;
            for (int entryIndex = 0; entryIndex < entrySize; ++entryIndex) {
                for (int multiIndex = segmentColl.getStartMultiIndex(); multiIndex <= segmentColl.getEndMultiIndex(); ++multiIndex) {
                    SegmentInfo tmpinfo = segmentColl.get(multiIndex);
                    String cellContent = "";
                    cellContent = tmpinfo.getType() == SINGLETYPE ? tmpinfo.getContent() : tmpinfo.getContent(entryIndex);
                    if (StringUtils.isEmpty((String)cellContent)) continue;
                    if (isFirstEntry) {
                        formatedContent.append("\n");
                        isFirstEntry = false;
                    }
                    formatedContent.append(cellContent).append(" ");
                }
                if (entrySize <= 1) continue;
                formatedContent.append("\n");
            }
            j = segmentColl.getEndMultiIndex();
        }
        return formatedContent.toString();
    }

    private FullOrgUnitInfo getFullOrgUnitInfoByfield(String format, MobileMessageFormatCollection formatCol, CoreBaseInfo editData) {
        StringBuffer formatedContent = new StringBuffer();
        while (!StringUtils.isEmpty((String)format)) {
            int leftIndex = format.indexOf(123);
            if (leftIndex != -1) {
                int rightIndex = format.indexOf(125);
                String indexStr = format.substring(leftIndex + 1, rightIndex);
                int fIndex = new Integer(indexStr);
                String fieldName = formatCol.get(fIndex).getFieldName();
                if (formatedContent.length() != 0 && !StringUtils.isEmpty((String)fieldName)) {
                    formatedContent.append(',');
                }
                if (!StringUtils.isEmpty((String)fieldName)) {
                    formatedContent.append(fieldName);
                }
                format = format.substring(rightIndex + 1);
                continue;
            }
            format = null;
        }
        FullOrgUnitInfo fullOrgUnitInfo = null;
        if (!StringUtils.isEmpty((String)formatedContent.toString())) {
            String oql = "select " + formatedContent.toString() + " where id = '" + editData.getId() + "'";
            try {
                IFullOrgUnit iFull = FullOrgUnitFactory.getRemoteInstance();
                fullOrgUnitInfo = iFull.getFullOrgUnitInfo(oql);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
        return fullOrgUnitInfo;
    }

    private SegmentInfo getConstantSegmentInfo(int index, String content) {
        SegmentInfo info = new SegmentInfo();
        info.setContent(content);
        info.setIndex(index);
        info.setType(SINGLETYPE);
        return info;
    }

    private SegmentInfo getConstantSegmentInfo(int index, ArrayList content) {
        SegmentInfo info = new SegmentInfo();
        info.setContent(content);
        info.setIndex(index);
        if (content.size() > 1) {
            info.setType(MULTITTYPE);
        } else {
            info.setType(SINGLETYPE);
        }
        return info;
    }

    public MobileMessageFormatCollection getFormatColl(Context ctx, CoreBaseInfo editData) throws Exception {
        String userId = null;
        IMobileMessageFormat iMessageFormat = null;
        if (ctx == null) {
            userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            iMessageFormat = MobileMessageFormatFactory.getRemoteInstance();
        } else {
            userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            iMessageFormat = MobileMessageFormatFactory.getLocalInstance(ctx);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("user.id", (Object)userId));
        if (editData != null && editData.getBOSType() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("bosType", (Object)editData.getBOSType().toString()));
        }
        viewInfo.setFilter(filterInfo);
        viewInfo.getSorter().add(new SorterItemInfo("index"));
        MobileMessageFormatCollection formatCol = iMessageFormat.getMobileMessageFormatCollection(viewInfo);
        return formatCol;
    }

    private ArrayList getValueByFieldName(CoreBaseInfo editData, String fieldName) {
        ArrayList<String> list = new ArrayList<String>();
        if (editData == null) {
            return null;
        }
        while (!StringUtils.isEmpty((String)fieldName)) {
            int index = fieldName.indexOf(46);
            if (index != -1) {
                list.add(fieldName.substring(0, index));
                fieldName = fieldName.substring(index + 1);
                continue;
            }
            list.add(fieldName);
            fieldName = null;
        }
        String[] simpleFieldNames = list.toArray(new String[0]);
        Object value = editData;
        for (int i = 0; i < simpleFieldNames.length; ++i) {
            if (value instanceof IObjectValue) {
                IObjectValue vo = (IObjectValue)value;
                value = vo.get(simpleFieldNames[i]);
                value = this.EnumAlias(vo, simpleFieldNames[i], value);
                continue;
            }
            if (value instanceof IObjectCollection) {
                IObjectCollection coll = (IObjectCollection)value;
                ArrayList<Object> content = new ArrayList<Object>();
                int size = coll.size();
                for (int colli = 0; colli < size; ++colli) {
                    Object o = coll.getObject(colli) == null ? "" : coll.getObject(colli).get(simpleFieldNames[i]);
                    o = this.EnumAlias(coll.getObject(colli), simpleFieldNames[i], o);
                    content.add(o);
                }
                value = content;
                continue;
            }
            if (!(value instanceof ArrayList)) continue;
            ArrayList<Object> valueListStr = new ArrayList<Object>();
            ArrayList valueList = (ArrayList)value;
            for (int listi = 0; listi < valueList.size(); ++listi) {
                Object o = valueList.get(listi);
                if (o instanceof IObjectValue) {
                    IObjectValue tmpValue = (IObjectValue)o;
                    Object ot = tmpValue.get(simpleFieldNames[i]);
                    ot = this.EnumAlias(tmpValue, simpleFieldNames[i], ot);
                    valueListStr.add(ot);
                    continue;
                }
                valueListStr.add(o);
            }
            value = valueListStr;
        }
        ArrayList content = new ArrayList();
        if (value instanceof ArrayList) {
            content = (ArrayList)value;
        } else {
            content.add(value == null ? "" : value.toString());
        }
        return content;
    }

    private Object EnumAlias(IObjectValue vo, String propName, Object value) {
        OwnPropertyInfo opInfo;
        String className;
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo eoInfo = loader.getEntity(vo.getBOSType());
        PropertyInfo propInfo = eoInfo.getPropertyByName(propName);
        if (propInfo instanceof OwnPropertyInfo && "Enum".equalsIgnoreCase(className = (opInfo = (OwnPropertyInfo)propInfo).getDataType().toString())) {
            try {
                Class returnType = (Class)DataBindUtil.getReadValueOfObject((String)eoInfo.getObjectValueClass(), (String)propName);
                String methodName = "getEnum";
                Enum tmpEnum = null;
                if (IntEnum.class.isAssignableFrom(returnType)) {
                    tmpEnum = DataBindUtil.getIntegerEnum((Class)returnType, (String)methodName, (int)((Integer)value));
                } else if (StringEnum.class.isAssignableFrom(returnType)) {
                    tmpEnum = DataBindUtil.getStringEnum((Class)returnType, (String)methodName, (String)((String)value));
                } else if (LongEnum.class.isAssignableFrom(returnType)) {
                    tmpEnum = DataBindUtil.getLongEnum((Class)returnType, (String)methodName, (long)((Long)value));
                } else if (FloatEnum.class.isAssignableFrom(returnType)) {
                    tmpEnum = DataBindUtil.getFloatEnum((Class)returnType, (String)methodName, (float)((Float)value).floatValue());
                } else if (DoubleEnum.class.isAssignableFrom(returnType)) {
                    tmpEnum = DataBindUtil.getDoubleEnum((Class)returnType, (String)methodName, (double)((Double)value));
                }
                return tmpEnum == null ? value : tmpEnum.getAlias();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return value;
    }

    static /* synthetic */ int access$700() {
        return SINGLETYPE;
    }

    private class SegmentColleciton {
        private int startMultiIndex = -1;
        private int endMultiIndex = -1;
        private ArrayList coll = new ArrayList();

        private SegmentColleciton() {
        }

        public void add(SegmentInfo info) {
            this.coll.add(info);
            if (info.getType() == MULTITTYPE) {
                int index = this.coll.size() - 1;
                this.endMultiIndex = this.startMultiIndex < 0 ? (this.startMultiIndex = index) : index;
            }
        }

        public SegmentInfo get(int index) {
            return (SegmentInfo)this.coll.get(index);
        }

        public int size() {
            return this.coll.size();
        }

        public int getEndMultiIndex() {
            return this.endMultiIndex;
        }

        public void setEndMultiIndex(int endMultiIndex) {
            this.endMultiIndex = endMultiIndex;
        }

        public int getStartMultiIndex() {
            return this.startMultiIndex;
        }

        public void setStartMultiIndex(int startMultiIndex) {
            this.startMultiIndex = startMultiIndex;
        }
    }

    private class SegmentInfo {
        private int index = 0;
        private int type = MobileMessageFormatUtils.access$700();
        private int size = 0;
        private ArrayList content = new ArrayList();

        private SegmentInfo() {
        }

        private void setContent(String _content) {
            this.content.clear();
            this.content.add(_content);
        }

        private void setContent(ArrayList _content) {
            this.content = _content;
        }

        private String getContent() {
            return this.content.size() > 0 ? (this.content.get(0) == null ? "" : this.content.get(0).toString()) : "";
        }

        private String getContent(int index) {
            return this.content.size() > index ? (this.content.get(index) == null ? "" : this.content.get(index).toString()) : "";
        }

        private int getSize() {
            return this.content.size();
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }
    }
}

